/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.chain.commands;

import org.apache.struts.action.Action;
import org.apache.struts.chain.commands.ActionCommandBase;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.config.ActionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCreateAction
extends ActionCommandBase {
    private final Logger log = LoggerFactory.getLogger(AbstractCreateAction.class);

    @Override
    protected boolean execute_(ActionContext actionCtx) throws Exception {
        Boolean valid = actionCtx.getFormValid();
        if (valid == null || !valid.booleanValue()) {
            this.log.trace("Invalid form; not going to execute.");
            return false;
        }
        if (actionCtx.getAction() != null) {
            this.log.trace("already have an action [{}]", (Object)actionCtx.getAction());
            return false;
        }
        ActionConfig actionConfig = actionCtx.getActionConfig();
        String type = actionConfig.getType();
        if (type == null) {
            String command = actionConfig.getCommand();
            if (command == null && actionConfig.getForward() == null && actionConfig.getInclude() == null) {
                this.log.error("no type or command for {}", (Object)actionConfig.getPath());
            } else {
                this.log.trace("no type for {}", (Object)actionConfig.getPath());
            }
            return false;
        }
        Action action = this.getAction(actionCtx, type, actionConfig);
        this.log.trace("setting action to {}", (Object)action);
        actionCtx.setAction(action);
        return false;
    }

    protected abstract Action getAction(ActionContext var1, String var2, ActionConfig var3) throws Exception;
}

