/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.chain.commands;

import org.apache.struts.chain.commands.ActionCommandBase;
import org.apache.struts.chain.commands.UnauthorizedActionException;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.config.ActionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthorizeAction
extends ActionCommandBase {
    private final Logger log = LoggerFactory.getLogger(AbstractAuthorizeAction.class);

    @Override
    protected boolean execute_(ActionContext actionCtx) throws Exception {
        boolean throwEx;
        ActionConfig actionConfig = actionCtx.getActionConfig();
        if (!this.isAuthorizationRequired(actionConfig)) {
            return false;
        }
        try {
            throwEx = !this.isAuthorized(actionCtx, actionConfig.getRoleNames(), actionConfig);
        }
        catch (UnauthorizedActionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throwEx = true;
            this.log.error("Unable to complete authorization process", (Throwable)ex);
        }
        if (throwEx) {
            throw new UnauthorizedActionException(this.getErrorMessage(actionCtx, actionConfig));
        }
        return false;
    }

    protected boolean isAuthorizationRequired(ActionConfig actionConfig) {
        String[] roles = actionConfig.getRoleNames();
        return roles != null && roles.length > 0;
    }

    protected abstract boolean isAuthorized(ActionContext var1, String[] var2, ActionConfig var3) throws Exception;

    protected abstract String getErrorMessage(ActionContext var1, ActionConfig var2);
}

