/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.action;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.ModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionHandler {
    public static final String INCLUDE_PATH = "INCLUDE_PATH";
    public static final String SILENT_IF_COMMITTED = "SILENT_IF_COMMITTED";
    private final Logger log = LoggerFactory.getLogger(ExceptionHandler.class);
    private static MessageResources messages = MessageResources.getMessageResources("org.apache.struts.action.LocalStrings");

    public ActionForward execute(Exception ex, ExceptionConfig ae, ActionMapping mapping, ActionForm formInstance, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String property;
        ActionMessage error;
        this.log.debug("ExceptionHandler executing for exception ", (Throwable)ex);
        ActionForward forward = ae.getPath() != null ? new ActionForward(ae.getPath()) : mapping.getInputForward();
        if (ex instanceof ModuleException) {
            error = ((ModuleException)ex).getActionMessage();
            property = ((ModuleException)ex).getProperty();
        } else if (ae.getKey() != null) {
            error = new ActionMessage(ae.getKey(), ex.getMessage());
            property = error.getKey();
        } else {
            error = null;
            property = null;
        }
        this.logException(ex);
        request.setAttribute("org.apache.struts.action.EXCEPTION", (Object)ex);
        this.storeException(request, property, error, forward, ae.getScope());
        if (!response.isCommitted()) {
            return forward;
        }
        this.log.debug("Response is already committed, so forwarding will not work. Attempt alternate handling.");
        if (!this.silent(ae)) {
            this.handleCommittedResponse(ex, ae, mapping, formInstance, request, response, forward);
        } else {
            this.log.warn("ExceptionHandler configured with {} and response is committed.", (Object)SILENT_IF_COMMITTED, (Object)ex);
        }
        return null;
    }

    protected void handleCommittedResponse(Exception ex, ExceptionConfig config, ActionMapping mapping, ActionForm formInstance, HttpServletRequest request, HttpServletResponse response, ActionForward actionForward) {
        String includePath = this.determineIncludePath(config, actionForward);
        if (includePath != null) {
            if (includePath.startsWith("/")) {
                this.log.debug("response committed, but attempt to include results of actionForward path");
                RequestDispatcher requestDispatcher = request.getRequestDispatcher(includePath);
                try {
                    requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                catch (IOException e) {
                    this.log.error("IOException when trying to include the error page path {}", (Object)includePath, (Object)e);
                }
                catch (ServletException e) {
                    this.log.error("ServletException when trying to include the error page path {}", (Object)includePath, (Object)e);
                }
            } else {
                this.log.warn("Suspicious includePath doesn't seem likely to work, so skipping it: {}; expected path to start with '/'", (Object)includePath);
            }
        }
        this.log.debug("Include not available or failed; try writing to the response directly.");
        try {
            response.getWriter().println("Unexpected error: " + ex);
            response.getWriter().println("<!-- ");
            ex.printStackTrace(response.getWriter());
            response.getWriter().println("-->");
        }
        catch (IOException e) {
            this.log.error("Error giving minimal information about exception", (Throwable)e);
            this.log.error("Original exception: ", (Throwable)ex);
        }
    }

    protected String determineIncludePath(ExceptionConfig config, ActionForward actionForward) {
        String includePath = config.getProperty(INCLUDE_PATH);
        if (includePath == null) {
            includePath = actionForward.getPath();
        }
        return includePath;
    }

    protected void logException(Exception e) {
        this.log.atDebug().setMessage(() -> messages.getMessage("exception.LOG")).setCause((Throwable)e).log();
    }

    protected void storeException(HttpServletRequest request, String property, ActionMessage error, ActionForward forward, String scope) {
        if (error != null) {
            ActionMessages errors = new ActionMessages();
            errors.add(property, error);
            if ("request".equals(scope)) {
                request.setAttribute("org.apache.struts.action.ERROR", (Object)errors);
            } else {
                request.getSession().setAttribute("org.apache.struts.action.ERROR", (Object)errors);
            }
        }
    }

    private boolean silent(ExceptionConfig config) {
        return "true".equals(config.getProperty(SILENT_IF_COMMITTED));
    }
}

