/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.action;

import java.util.Arrays;
import org.apache.struts.action.ActionForward;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ForwardConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionMapping
extends ActionConfig {
    private static final long serialVersionUID = 2801090844264312287L;
    private final transient Logger log = LoggerFactory.getLogger(ActionMapping.class);

    public ActionForward findForward(String forwardName) {
        ForwardConfig config = this.findForwardConfig(forwardName);
        if (config == null) {
            config = this.getModuleConfig().findForwardConfig(forwardName);
        }
        if (config == null) {
            this.log.warn("Unable to find '{}' forward.", (Object)forwardName);
        }
        return (ActionForward)config;
    }

    public ActionForward findRequiredForward(String forwardName) {
        ActionForward forward = this.findForward(forwardName);
        if (forward == null) {
            throw new IllegalStateException("Unable to find '" + forwardName + "' forward of action path '" + this.getPath() + "'");
        }
        return forward;
    }

    public String[] findForwards() {
        ForwardConfig[] fcs = this.findForwardConfigs();
        String[] results = new String[fcs.length];
        Arrays.setAll(results, i -> fcs[i].getName());
        return results;
    }

    public ActionForward getInputForward() {
        String input = this.getInput();
        if (this.getModuleConfig().getControllerConfig().getInputForward()) {
            if (input != null) {
                return this.findForward(input);
            }
            return this.findForward("input");
        }
        return new ActionForward(input);
    }
}

