/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.ConditionOperator;
import com.azure.resourcemanager.monitor.models.RuleCondition;
import com.azure.resourcemanager.monitor.models.RuleDataSource;
import com.azure.resourcemanager.monitor.models.TimeAggregationOperator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.Duration;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="odata\\.type")
@JsonTypeName(value="Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition")
@JsonFlatten
public class ThresholdRuleCondition
extends RuleCondition {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ThresholdRuleCondition.class);
    @JsonProperty(value="operator", required=true)
    private ConditionOperator operator;
    @JsonProperty(value="threshold", required=true)
    private double threshold;
    @JsonProperty(value="windowSize")
    private Duration windowSize;
    @JsonProperty(value="timeAggregation")
    private TimeAggregationOperator timeAggregation;

    public ConditionOperator operator() {
        return this.operator;
    }

    public ThresholdRuleCondition withOperator(ConditionOperator operator) {
        this.operator = operator;
        return this;
    }

    public double threshold() {
        return this.threshold;
    }

    public ThresholdRuleCondition withThreshold(double threshold) {
        this.threshold = threshold;
        return this;
    }

    public Duration windowSize() {
        return this.windowSize;
    }

    public ThresholdRuleCondition withWindowSize(Duration windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    public TimeAggregationOperator timeAggregation() {
        return this.timeAggregation;
    }

    public ThresholdRuleCondition withTimeAggregation(TimeAggregationOperator timeAggregation) {
        this.timeAggregation = timeAggregation;
        return this;
    }

    @Override
    public ThresholdRuleCondition withDataSource(RuleDataSource dataSource) {
        super.withDataSource(dataSource);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.operator() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property operator in model ThresholdRuleCondition"));
        }
    }
}

