/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.EmailNotification;
import com.azure.resourcemanager.monitor.models.WebhookNotification;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class AutoscaleNotification {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AutoscaleNotification.class);
    @JsonProperty(value="operation", required=true)
    private String operation = "Scale";
    @JsonProperty(value="email")
    private EmailNotification email;
    @JsonProperty(value="webhooks")
    private List<WebhookNotification> webhooks;

    public String operation() {
        return this.operation;
    }

    public AutoscaleNotification withOperation(String operation) {
        this.operation = operation;
        return this;
    }

    public EmailNotification email() {
        return this.email;
    }

    public AutoscaleNotification withEmail(EmailNotification email) {
        this.email = email;
        return this;
    }

    public List<WebhookNotification> webhooks() {
        return this.webhooks;
    }

    public AutoscaleNotification withWebhooks(List<WebhookNotification> webhooks) {
        this.webhooks = webhooks;
        return this;
    }

    public void validate() {
        if (this.email() != null) {
            this.email().validate();
        }
        if (this.webhooks() != null) {
            this.webhooks().forEach(e -> e.validate());
        }
    }
}

