/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.serializer.SerializerFactory;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.monitor.implementation.MonitorClientImpl;
import java.time.Duration;

@ServiceClientBuilder(serviceClients={MonitorClientImpl.class})
public final class MonitorClientBuilder {
    private String subscriptionId;
    private String endpoint;
    private AzureEnvironment environment;
    private Duration defaultPollInterval;
    private HttpPipeline pipeline;
    private SerializerAdapter serializerAdapter;

    public MonitorClientBuilder subscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public MonitorClientBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public MonitorClientBuilder environment(AzureEnvironment environment) {
        this.environment = environment;
        return this;
    }

    public MonitorClientBuilder defaultPollInterval(Duration defaultPollInterval) {
        this.defaultPollInterval = defaultPollInterval;
        return this;
    }

    public MonitorClientBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public MonitorClientBuilder serializerAdapter(SerializerAdapter serializerAdapter) {
        this.serializerAdapter = serializerAdapter;
        return this;
    }

    public MonitorClientImpl buildClient() {
        if (this.endpoint == null) {
            this.endpoint = "https://management.azure.com";
        }
        if (this.environment == null) {
            this.environment = AzureEnvironment.AZURE;
        }
        if (this.defaultPollInterval == null) {
            this.defaultPollInterval = Duration.ofSeconds(30L);
        }
        if (this.pipeline == null) {
            this.pipeline = new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build();
        }
        if (this.serializerAdapter == null) {
            this.serializerAdapter = SerializerFactory.createDefaultManagementSerializerAdapter();
        }
        MonitorClientImpl client = new MonitorClientImpl(this.pipeline, this.serializerAdapter, this.defaultPollInterval, this.environment, this.subscriptionId, this.endpoint);
        return client;
    }
}

