/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.monitor.fluent.BaselinesClient;
import com.azure.resourcemanager.monitor.fluent.models.SingleMetricBaselineInner;
import com.azure.resourcemanager.monitor.implementation.MonitorClientImpl;
import com.azure.resourcemanager.monitor.models.MetricBaselinesResponse;
import com.azure.resourcemanager.monitor.models.ResultType;
import java.time.Duration;
import reactor.core.publisher.Mono;

public final class BaselinesClientImpl
implements BaselinesClient {
    private final ClientLogger logger = new ClientLogger(BaselinesClientImpl.class);
    private final BaselinesService service;
    private final MonitorClientImpl client;

    BaselinesClientImpl(MonitorClientImpl client) {
        this.service = (BaselinesService)RestProxy.create(BaselinesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SingleMetricBaselineInner>> listSinglePageAsync(String resourceUri, String metricnames, String metricnamespace, String timespan, Duration interval, String aggregation, String sensitivities, String filter, ResultType resultType) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String apiVersion = "2019-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceUri, metricnames, metricnamespace, timespan, interval, aggregation, sensitivities, filter, resultType, "2019-03-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricBaselinesResponse)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SingleMetricBaselineInner>> listSinglePageAsync(String resourceUri, String metricnames, String metricnamespace, String timespan, Duration interval, String aggregation, String sensitivities, String filter, ResultType resultType, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String apiVersion = "2019-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceUri, metricnames, metricnamespace, timespan, interval, aggregation, sensitivities, filter, resultType, "2019-03-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricBaselinesResponse)res.getValue()).value(), null, null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SingleMetricBaselineInner> listAsync(String resourceUri, String metricnames, String metricnamespace, String timespan, Duration interval, String aggregation, String sensitivities, String filter, ResultType resultType) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceUri, metricnames, metricnamespace, timespan, interval, aggregation, sensitivities, filter, resultType));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SingleMetricBaselineInner> listAsync(String resourceUri) {
        String metricnames = null;
        String metricnamespace = null;
        String timespan = null;
        Duration interval = null;
        String aggregation = null;
        String sensitivities = null;
        String filter = null;
        ResultType resultType = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceUri, metricnames, metricnamespace, timespan, interval, aggregation, sensitivities, filter, resultType));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SingleMetricBaselineInner> listAsync(String resourceUri, String metricnames, String metricnamespace, String timespan, Duration interval, String aggregation, String sensitivities, String filter, ResultType resultType, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceUri, metricnames, metricnamespace, timespan, interval, aggregation, sensitivities, filter, resultType, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SingleMetricBaselineInner> list(String resourceUri) {
        String metricnames = null;
        String metricnamespace = null;
        String timespan = null;
        Duration interval = null;
        String aggregation = null;
        String sensitivities = null;
        String filter = null;
        ResultType resultType = null;
        return new PagedIterable(this.listAsync(resourceUri, metricnames, metricnamespace, timespan, interval, aggregation, sensitivities, filter, resultType));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SingleMetricBaselineInner> list(String resourceUri, String metricnames, String metricnamespace, String timespan, Duration interval, String aggregation, String sensitivities, String filter, ResultType resultType, Context context) {
        return new PagedIterable(this.listAsync(resourceUri, metricnames, metricnamespace, timespan, interval, aggregation, sensitivities, filter, resultType, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MonitorClientBaselin")
    private static interface BaselinesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceUri}/providers/Microsoft.Insights/metricBaselines")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MetricBaselinesResponse>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceUri", encoded=true) String var2, @QueryParam(value="metricnames") String var3, @QueryParam(value="metricnamespace") String var4, @QueryParam(value="timespan") String var5, @QueryParam(value="interval") Duration var6, @QueryParam(value="aggregation") String var7, @QueryParam(value="sensitivities") String var8, @QueryParam(value="$filter") String var9, @QueryParam(value="resultType") ResultType var10, @QueryParam(value="api-version") String var11, @HeaderParam(value="Accept") String var12, Context var13);
    }
}

