/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.MetricAlertAction;
import com.azure.resourcemanager.monitor.models.MetricAlertCriteria;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class MetricAlertResourceInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(MetricAlertResourceInner.class);
    @JsonProperty(value="properties.description")
    private String description;
    @JsonProperty(value="properties.severity", required=true)
    private int severity;
    @JsonProperty(value="properties.enabled", required=true)
    private boolean enabled;
    @JsonProperty(value="properties.scopes", required=true)
    private List<String> scopes;
    @JsonProperty(value="properties.evaluationFrequency", required=true)
    private Duration evaluationFrequency;
    @JsonProperty(value="properties.windowSize", required=true)
    private Duration windowSize;
    @JsonProperty(value="properties.targetResourceType")
    private String targetResourceType;
    @JsonProperty(value="properties.targetResourceRegion")
    private String targetResourceRegion;
    @JsonProperty(value="properties.criteria", required=true)
    private MetricAlertCriteria criteria;
    @JsonProperty(value="properties.autoMitigate")
    private Boolean autoMitigate;
    @JsonProperty(value="properties.actions")
    private List<MetricAlertAction> actions;
    @JsonProperty(value="properties.lastUpdatedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastUpdatedTime;
    @JsonProperty(value="properties.isMigrated", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean isMigrated;

    public String description() {
        return this.description;
    }

    public MetricAlertResourceInner withDescription(String description) {
        this.description = description;
        return this;
    }

    public int severity() {
        return this.severity;
    }

    public MetricAlertResourceInner withSeverity(int severity) {
        this.severity = severity;
        return this;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public MetricAlertResourceInner withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public List<String> scopes() {
        return this.scopes;
    }

    public MetricAlertResourceInner withScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public Duration evaluationFrequency() {
        return this.evaluationFrequency;
    }

    public MetricAlertResourceInner withEvaluationFrequency(Duration evaluationFrequency) {
        this.evaluationFrequency = evaluationFrequency;
        return this;
    }

    public Duration windowSize() {
        return this.windowSize;
    }

    public MetricAlertResourceInner withWindowSize(Duration windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    public String targetResourceType() {
        return this.targetResourceType;
    }

    public MetricAlertResourceInner withTargetResourceType(String targetResourceType) {
        this.targetResourceType = targetResourceType;
        return this;
    }

    public String targetResourceRegion() {
        return this.targetResourceRegion;
    }

    public MetricAlertResourceInner withTargetResourceRegion(String targetResourceRegion) {
        this.targetResourceRegion = targetResourceRegion;
        return this;
    }

    public MetricAlertCriteria criteria() {
        return this.criteria;
    }

    public MetricAlertResourceInner withCriteria(MetricAlertCriteria criteria) {
        this.criteria = criteria;
        return this;
    }

    public Boolean autoMitigate() {
        return this.autoMitigate;
    }

    public MetricAlertResourceInner withAutoMitigate(Boolean autoMitigate) {
        this.autoMitigate = autoMitigate;
        return this;
    }

    public List<MetricAlertAction> actions() {
        return this.actions;
    }

    public MetricAlertResourceInner withActions(List<MetricAlertAction> actions) {
        this.actions = actions;
        return this;
    }

    public OffsetDateTime lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Boolean isMigrated() {
        return this.isMigrated;
    }

    public MetricAlertResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public MetricAlertResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.scopes() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property scopes in model MetricAlertResourceInner"));
        }
        if (this.evaluationFrequency() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property evaluationFrequency in model MetricAlertResourceInner"));
        }
        if (this.windowSize() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property windowSize in model MetricAlertResourceInner"));
        }
        if (this.criteria() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property criteria in model MetricAlertResourceInner"));
        }
        this.criteria().validate();
        if (this.actions() != null) {
            this.actions().forEach(e -> e.validate());
        }
    }
}

