/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles.xmlDefinition;

import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.NoSuchDefinitionException;
import org.apache.struts.tiles.xmlDefinition.XmlAttribute;
import org.apache.struts.tiles.xmlDefinition.XmlDefinitionsSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlDefinition
extends ComponentDefinition {
    private static final long serialVersionUID = -5843791058928194033L;
    private String inherit;
    private final transient Logger log = LoggerFactory.getLogger(XmlDefinition.class);
    private boolean isVisited = false;

    public void addAttribute(XmlAttribute attribute) {
        this.putAttribute(attribute.getName(), attribute.getValue());
    }

    public void setExtends(String name) {
        this.inherit = name;
    }

    public String getExtends() {
        return this.inherit;
    }

    public boolean isExtending() {
        return this.inherit != null;
    }

    public void setIsVisited(boolean isVisited) {
        this.isVisited = isVisited;
    }

    public void resolveInheritance(XmlDefinitionsSet definitionsSet) throws NoSuchDefinitionException {
        if (this.isVisited || !this.isExtending()) {
            return;
        }
        this.log.debug("Resolve definition for child name='{}' extends='{}'.", (Object)this.getName(), (Object)this.getExtends());
        this.setIsVisited(true);
        XmlDefinition parent = definitionsSet.getDefinition(this.getExtends());
        if (parent == null) {
            String msg = "Error while resolving definition inheritance: child '" + this.getName() + "' can't find its ancestor '" + this.getExtends() + "'. Please check your description file.";
            this.log.error(msg);
            throw new NoSuchDefinitionException(msg);
        }
        parent.resolveInheritance(definitionsSet);
        for (String name : parent.getAttributes().keySet()) {
            if (this.getAttributes().containsKey(name)) continue;
            this.putAttribute(name, parent.getAttribute(name));
        }
        if (this.path == null) {
            this.setPath(parent.getPath());
        }
        if (this.role == null) {
            this.setRole(parent.getRole());
        }
        if (this.controller == null) {
            this.setController(parent.getController());
            this.setControllerType(parent.getControllerType());
        }
    }

    public void overload(XmlDefinition child) {
        if (child.getPath() != null) {
            this.path = child.getPath();
        }
        if (child.getExtends() != null) {
            this.inherit = child.getExtends();
        }
        if (child.getRole() != null) {
            this.role = child.getRole();
        }
        if (child.getController() != null) {
            this.controller = child.getController();
            this.controllerType = child.getControllerType();
        }
        this.attributes.putAll(child.getAttributes());
    }
}

