/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles.xmlDefinition;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.FactoryNotFoundException;
import org.apache.struts.tiles.xmlDefinition.DefinitionsFactory;
import org.apache.struts.tiles.xmlDefinition.FactorySet;
import org.apache.struts.tiles.xmlDefinition.XmlDefinitionsSet;
import org.apache.struts.tiles.xmlDefinition.XmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class I18nFactorySet
extends FactorySet {
    private static final long serialVersionUID = 3883838354881166525L;
    private final transient Logger log = LoggerFactory.getLogger(I18nFactorySet.class);
    public static final String DEFINITIONS_CONFIG_PARAMETER_NAME = "definitions-config";
    public static final String PARSER_DETAILS_PARAMETER_NAME = "definitions-parser-details";
    public static final String PARSER_VALIDATE_PARAMETER_NAME = "definitions-parser-validate";
    public static final String[] DEFAULT_DEFINITION_FILENAMES = new String[]{"/WEB-INF/tileDefinitions.xml", "/WEB-INF/componentDefinitions.xml", "/WEB-INF/instanceDefinitions.xml"};
    public static final String FILENAME_EXTENSION = ".xml";
    protected DefinitionsFactory defaultFactory = null;
    protected transient XmlParser xmlParser;
    protected boolean isValidatingParser = false;
    protected int parserDetailLevel = 0;
    private ArrayList<String> filenames = null;
    private HashMap<String, DefinitionsFactory> loaded = null;

    public I18nFactorySet() {
    }

    public I18nFactorySet(ServletContext servletContext, Map<String, Object> properties) throws DefinitionsFactoryException {
        this.initFactory(servletContext, properties);
    }

    @Override
    public void initFactory(ServletContext servletContext, Map<String, Object> properties) throws DefinitionsFactoryException {
        String filename;
        String value = (String)properties.get(PARSER_VALIDATE_PARAMETER_NAME);
        if (value != null) {
            this.isValidatingParser = Boolean.valueOf(value);
        }
        if ((value = (String)properties.get(PARSER_DETAILS_PARAMETER_NAME)) != null) {
            try {
                this.parserDetailLevel = Integer.valueOf(value);
            }
            catch (NumberFormatException ex) {
                this.log.error("Bad format for parameter '{}'. Integer expected.", (Object)PARSER_DETAILS_PARAMETER_NAME);
            }
        }
        if ((filename = (String)properties.get(DEFINITIONS_CONFIG_PARAMETER_NAME)) != null) {
            try {
                this.initFactory(servletContext, filename);
                this.log.debug("Factory initialized from file '{}'.", (Object)filename);
            }
            catch (FileNotFoundException ex) {
                this.log.error("{} : Can't find file '{}'", (Object)ex.getMessage(), (Object)filename);
                throw new FactoryNotFoundException(ex.getMessage() + " : Can't find file '" + filename + "'", ex);
            }
        } else {
            for (int i = 0; i < DEFAULT_DEFINITION_FILENAMES.length; ++i) {
                filename = DEFAULT_DEFINITION_FILENAMES[i];
                try {
                    this.initFactory(servletContext, filename);
                    this.log.info("Factory initialized from file '{}'.", (Object)filename);
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    protected void initFactory(ServletContext servletContext, String proposedFilename) throws DefinitionsFactoryException, FileNotFoundException {
        StringTokenizer tokenizer = new StringTokenizer(proposedFilename, ",");
        this.filenames = new ArrayList(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            String fn = tokenizer.nextToken().trim();
            if (fn.isEmpty()) {
                this.log.warn("Factory initialization - ignore empty file");
                continue;
            }
            if (fn.contains("\u0000")) {
                this.log.warn("Factory initialization - ignore file with nul-characters '{}'", (Object)fn.replace('\u0000', '_'));
                continue;
            }
            try {
                Path p = Paths.get(fn, new String[0]).normalize();
                if (p.toString().charAt(0) != '.') {
                    this.filenames.add(p.toString());
                    continue;
                }
                this.log.warn("Factory initialization - path not normalized '{}'", (Object)p.toString());
            }
            catch (InvalidPathException e) {
                this.log.warn("Factory initialization - illegal path '{}'", (Object)e.getInput(), (Object)e);
            }
        }
        this.loaded = new HashMap();
        this.defaultFactory = this.createDefaultFactory(servletContext);
        this.log.debug("default factory: {}", (Object)this.defaultFactory);
    }

    @Override
    protected DefinitionsFactory getDefaultFactory() {
        return this.defaultFactory;
    }

    protected DefinitionsFactory createDefaultFactory(ServletContext servletContext) throws DefinitionsFactoryException, FileNotFoundException {
        XmlDefinitionsSet rootXmlConfig = this.parseXmlFiles(servletContext, "", null);
        if (rootXmlConfig == null) {
            throw new FileNotFoundException();
        }
        rootXmlConfig.resolveInheritances();
        this.log.debug(rootXmlConfig.toString());
        DefinitionsFactory factory = new DefinitionsFactory(rootXmlConfig);
        this.log.debug("factory loaded : {}", (Object)factory);
        return factory;
    }

    @Override
    protected Object getDefinitionsFactoryKey(String name, ServletRequest request, ServletContext servletContext) {
        Locale locale = null;
        try {
            HttpSession session = ((HttpServletRequest)request).getSession(false);
            if (session != null) {
                locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
            }
        }
        catch (ClassCastException ex) {
            this.log.error("I18nFactorySet.getDefinitionsFactoryKey");
            ex.printStackTrace();
        }
        return locale;
    }

    @Override
    protected DefinitionsFactory createFactory(Object key, ServletRequest request, ServletContext servletContext) throws DefinitionsFactoryException {
        if (key == null) {
            return this.getDefaultFactory();
        }
        List<String> possiblePostfixes = this.calculateSuffixes((Locale)key);
        XmlDefinitionsSet lastXmlFile = null;
        DefinitionsFactory factory = null;
        String curPostfix = null;
        int i = 0;
        for (i = possiblePostfixes.size() - 1; i >= 0; --i) {
            curPostfix = possiblePostfixes.get(i);
            factory = this.loaded.get(curPostfix);
            if (factory != null) {
                return factory;
            }
            lastXmlFile = this.parseXmlFiles(servletContext, curPostfix, null);
            if (lastXmlFile != null) break;
        }
        if (lastXmlFile == null) {
            return this.getDefaultFactory();
        }
        String lastPostfix = curPostfix;
        XmlDefinitionsSet rootXmlConfig = this.parseXmlFiles(servletContext, "", null);
        for (int j = 0; j < i; ++j) {
            curPostfix = possiblePostfixes.get(j);
            this.parseXmlFiles(servletContext, curPostfix, rootXmlConfig);
        }
        rootXmlConfig.extend(lastXmlFile);
        rootXmlConfig.resolveInheritances();
        factory = new DefinitionsFactory(rootXmlConfig);
        this.loaded.put(lastPostfix, factory);
        this.log.debug("factory loaded : {}", (Object)factory);
        return factory;
    }

    private List<String> calculateSuffixes(Locale locale) {
        ArrayList<String> suffixes = new ArrayList<String>(3);
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        StringBuilder suffix = new StringBuilder();
        suffix.append('_');
        suffix.append(language);
        if (language.length() > 0) {
            suffixes.add(suffix.toString());
        }
        suffix.append('_');
        suffix.append(country);
        if (country.length() > 0) {
            suffixes.add(suffix.toString());
        }
        suffix.append('_');
        suffix.append(variant);
        if (variant.length() > 0) {
            suffixes.add(suffix.toString());
        }
        return suffixes;
    }

    protected XmlDefinitionsSet parseXmlFiles(ServletContext servletContext, String postfix, XmlDefinitionsSet xmlDefinitions) throws DefinitionsFactoryException {
        if (postfix != null && postfix.length() == 0) {
            postfix = null;
        }
        for (String filename : this.filenames) {
            String fn = this.concatPostfix(filename, postfix);
            xmlDefinitions = this.parseXmlFile(servletContext, fn, xmlDefinitions);
        }
        return xmlDefinitions;
    }

    protected XmlDefinitionsSet parseXmlFile(ServletContext servletContext, String filename, XmlDefinitionsSet xmlDefinitions) throws DefinitionsFactoryException {
        InputStream input = null;
        try {
            Object realPath2;
            input = servletContext.getResourceAsStream(filename);
            if (null == input) {
                try {
                    realPath2 = servletContext.getRealPath(filename);
                    if (realPath2 != null) {
                        input = new FileInputStream((String)realPath2);
                    }
                }
                catch (Exception realPath2) {
                    // empty catch block
                }
            }
            if (input == null) {
                input = this.getClass().getResourceAsStream(filename);
            }
            if (input == null) {
                this.log.debug("Can't open file '{}'", (Object)filename);
                realPath2 = xmlDefinitions;
                return realPath2;
            }
            this.xmlParser = new XmlParser();
            this.xmlParser.setValidating(this.isValidatingParser);
            if (xmlDefinitions == null) {
                xmlDefinitions = new XmlDefinitionsSet();
            }
            this.xmlParser.parse(input, xmlDefinitions);
        }
        catch (SAXException ex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Error while parsing file '{}'.", (Object)filename);
                ex.printStackTrace();
            }
            throw new DefinitionsFactoryException("Error while parsing file '" + filename + "'. " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new DefinitionsFactoryException("IO Error while parsing file '" + filename + "'. " + ex.getMessage(), ex);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ioe) {
                    this.log.warn("Error closing input stream", (Throwable)ioe);
                }
            }
        }
        return xmlDefinitions;
    }

    private String concatPostfix(String name, String postfix) {
        if (postfix == null) {
            return name;
        }
        int dotIndex = name.lastIndexOf(".");
        int lastNameStart = name.lastIndexOf(File.pathSeparator);
        if (dotIndex < 1 || dotIndex < lastNameStart) {
            return name + postfix;
        }
        String ext = name.substring(dotIndex);
        name = name.substring(0, dotIndex);
        return name + postfix + ext;
    }

    @Override
    public String toString() {
        StringBuilder buff = new StringBuilder("I18nFactorySet : \n");
        buff.append("--- default factory ---\n");
        buff.append(this.defaultFactory.toString());
        buff.append("\n--- other factories ---\n");
        for (Object factory : this.factories.values()) {
            buff.append(factory.toString()).append("---------- \n");
        }
        return buff.toString();
    }
}

