/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles.actions;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.DefinitionsUtil;
import org.apache.struts.tiles.FactoryNotFoundException;
import org.apache.struts.tiles.NoSuchDefinitionException;
import org.apache.struts.tiles.TilesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefinitionDispatcherAction
extends Action {
    private static final long serialVersionUID = 8663194696860741591L;
    private final transient Logger log = LoggerFactory.getLogger(DefinitionDispatcherAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String name;
        String parameter = mapping.getParameter();
        if (parameter == null) {
            parameter = "def";
        }
        if ((name = request.getParameter(parameter)) == null) {
            this.log.error("Can't get parameter '{}'.", (Object)parameter);
            return mapping.findForward("error");
        }
        try {
            ComponentDefinition definition = TilesUtil.getDefinition(name, (ServletRequest)request, this.getServlet().getServletContext());
            this.log.debug("Get Definition {}", (Object)definition);
            DefinitionsUtil.setActionDefinition((ServletRequest)request, definition);
        }
        catch (FactoryNotFoundException e) {
            this.log.error("Can't get definition factory.", (Throwable)e);
            return mapping.findForward("error");
        }
        catch (NoSuchDefinitionException e) {
            this.log.error("Can't get definition '{}'.", (Object)name, (Object)e);
            return mapping.findForward("error");
        }
        catch (DefinitionsFactoryException e) {
            this.log.error("General Factory error '{}'.", (Object)e.getMessage(), (Object)e);
            return mapping.findForward("error");
        }
        catch (Exception e) {
            this.log.error("General error '{}'.", (Object)e.getMessage(), (Object)e);
            return mapping.findForward("error");
        }
        return mapping.findForward("success");
    }

    @Deprecated
    protected void printError(HttpServletResponse response, String msg) throws IOException {
        response.setContentType("text/plain");
        PrintWriter writer = response.getWriter();
        writer.println(msg);
        writer.flush();
        writer.close();
    }
}

