/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.Controller;
import org.apache.struts.tiles.DefinitionsFactory;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.DefinitionsUtil;
import org.apache.struts.tiles.NoSuchDefinitionException;
import org.apache.struts.tiles.TilesUtil;
import org.apache.struts.tiles.TilesUtilStrutsImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TilesRequestProcessor
extends RequestProcessor {
    private static final long serialVersionUID = -6522610348048179731L;
    protected DefinitionsFactory definitionsFactory = null;
    private final transient Logger log = LoggerFactory.getLogger(TilesRequestProcessor.class);

    public void init(ActionServlet servlet, ModuleConfig moduleConfig) throws ServletException {
        super.init(servlet, moduleConfig);
        this.initDefinitionsMapping();
    }

    protected void initDefinitionsMapping() throws ServletException {
        this.definitionsFactory = ((TilesUtilStrutsImpl)TilesUtil.getTilesUtil()).getDefinitionsFactory(this.getServletContext(), this.moduleConfig);
        if (this.definitionsFactory == null) {
            this.log.info("Definition Factory not found for module '{}'. Have you declared the appropriate plugin in struts-config.xml ?", (Object)this.moduleConfig.getPrefix());
            return;
        }
        this.log.info("Tiles definition factory found for request processor '{}'.", (Object)this.moduleConfig.getPrefix());
    }

    @Deprecated
    protected boolean processTilesDefinition(String definitionName, boolean contextRelative, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return this.processTilesDefinition(definitionName, request, response);
    }

    protected boolean processTilesDefinition(String definitionName, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean doInclude = false;
        Controller controller = null;
        String uri = null;
        ComponentContext tileContext = null;
        try {
            tileContext = ComponentContext.getContext((ServletRequest)request);
            doInclude = tileContext != null;
            ComponentDefinition definition = null;
            if (this.definitionsFactory != null) {
                try {
                    definition = this.definitionsFactory.getDefinition(definitionName, (ServletRequest)request, this.getServletContext());
                }
                catch (NoSuchDefinitionException ex) {
                    this.log.debug("NoSuchDefinitionException {}", (Object)ex.getMessage());
                }
                if (definition != null) {
                    uri = definition.getPath();
                    controller = definition.getOrCreateController();
                    if (tileContext == null) {
                        tileContext = new ComponentContext(definition.getAttributes());
                        ComponentContext.setContext(tileContext, (ServletRequest)request);
                    } else {
                        tileContext.addMissing(definition.getAttributes());
                    }
                }
            }
            if ((definition = DefinitionsUtil.getActionDefinition((ServletRequest)request)) != null) {
                if (definition.getPath() != null) {
                    uri = definition.getPath();
                }
                if (definition.getOrCreateController() != null) {
                    controller = definition.getOrCreateController();
                }
                if (tileContext == null) {
                    tileContext = new ComponentContext(definition.getAttributes());
                    ComponentContext.setContext(tileContext, (ServletRequest)request);
                } else {
                    tileContext.addMissing(definition.getAttributes());
                }
            }
        }
        catch (InstantiationException ex) {
            this.log.error("Can't create associated controller", (Throwable)ex);
            throw new ServletException("Can't create associated controller", (Throwable)ex);
        }
        catch (DefinitionsFactoryException ex) {
            throw new ServletException((Throwable)ex);
        }
        if (uri == null) {
            return false;
        }
        if (controller != null) {
            try {
                controller.execute(tileContext, request, response, this.getServletContext());
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        this.log.debug("uri={} doInclude={}", (Object)uri, (Object)doInclude);
        if (doInclude) {
            this.doInclude(uri, request, response);
        } else {
            this.doForward(uri, request, response);
        }
        return true;
    }

    protected void doForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (response.isCommitted()) {
            this.doInclude(uri, request, response);
        } else {
            super.doForward(uri, request, response);
        }
    }

    protected void processForwardConfig(HttpServletRequest request, HttpServletResponse response, ForwardConfig forward) throws IOException, ServletException {
        if (forward == null) {
            return;
        }
        this.log.debug("processForwardConfig({})", (Object)forward.getPath());
        if (this.processTilesDefinition(forward.getPath(), request, response)) {
            this.log.debug("  '{}' - processed as definition", (Object)forward.getPath());
            return;
        }
        this.log.debug("  '{}' - processed as uri", (Object)forward.getPath());
        super.processForwardConfig(request, response, forward);
    }

    protected void internalModuleRelativeForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.processTilesDefinition(uri, request, response)) {
            return;
        }
        super.internalModuleRelativeForward(uri, request, response);
    }

    protected void internalModuleRelativeInclude(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.processTilesDefinition(uri, request, response)) {
            return;
        }
        super.internalModuleRelativeInclude(uri, request, response);
    }

    public DefinitionsFactory getDefinitionsFactory() {
        return this.definitionsFactory;
    }
}

