/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.jsp.PageContext;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ComponentContext
implements Serializable {
    private static final long serialVersionUID = 5887062776582589341L;
    private HashMap<String, Object> attributes = null;

    public ComponentContext() {
    }

    public ComponentContext(Map<String, Object> attributes) {
        if (attributes != null) {
            this.attributes = new HashMap<String, Object>(attributes);
        }
    }

    public void addAll(Map<String, Object> newAttributes) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>(newAttributes);
            return;
        }
        this.attributes.putAll(newAttributes);
    }

    public void addMissing(Map<String, Object> defaultAttributes) {
        if (defaultAttributes == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>(defaultAttributes);
            return;
        }
        for (Map.Entry<String, Object> entry : defaultAttributes.entrySet()) {
            if (this.attributes.containsKey(entry.getKey())) continue;
            this.attributes.put(entry.getKey(), entry.getValue());
        }
    }

    public Object getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public Iterator<String> getAttributeNames() {
        if (this.attributes == null) {
            return Collections.emptyListIterator();
        }
        return this.attributes.keySet().iterator();
    }

    public void putAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(name, value);
    }

    public Object findAttribute(String beanName, PageContext pageContext) {
        Object attribute = this.getAttribute(beanName);
        if (attribute == null) {
            attribute = pageContext.findAttribute(beanName);
        }
        return attribute;
    }

    public Object getAttribute(String beanName, int scope, PageContext pageContext) {
        if (scope == 8) {
            return this.getAttribute(beanName);
        }
        return pageContext.getAttribute(beanName, scope);
    }

    public static ComponentContext getContext(ServletRequest request) {
        if (request.getAttribute("jakarta.servlet.jsp.jspException") != null) {
            return null;
        }
        return (ComponentContext)request.getAttribute("org.apache.struts.taglib.tiles.CompContext");
    }

    public static void setContext(ComponentContext context, ServletRequest request) {
        request.setAttribute("org.apache.struts.taglib.tiles.CompContext", (Object)context);
    }
}

