/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.sharing.SharingFileAccessError;
import com.dropbox.core.v2.sharing.SharingUserError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class GetFileMetadataError {
    public static final GetFileMetadataError OTHER = new GetFileMetadataError().withTag(Tag.OTHER);
    private Tag _tag;
    private SharingUserError userErrorValue;
    private SharingFileAccessError accessErrorValue;

    private GetFileMetadataError() {
    }

    private GetFileMetadataError withTag(Tag _tag) {
        GetFileMetadataError result = new GetFileMetadataError();
        result._tag = _tag;
        return result;
    }

    private GetFileMetadataError withTagAndUserError(Tag _tag, SharingUserError userErrorValue) {
        GetFileMetadataError result = new GetFileMetadataError();
        result._tag = _tag;
        result.userErrorValue = userErrorValue;
        return result;
    }

    private GetFileMetadataError withTagAndAccessError(Tag _tag, SharingFileAccessError accessErrorValue) {
        GetFileMetadataError result = new GetFileMetadataError();
        result._tag = _tag;
        result.accessErrorValue = accessErrorValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isUserError() {
        return this._tag == Tag.USER_ERROR;
    }

    public static GetFileMetadataError userError(SharingUserError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new GetFileMetadataError().withTagAndUserError(Tag.USER_ERROR, value);
    }

    public SharingUserError getUserErrorValue() {
        if (this._tag != Tag.USER_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.USER_ERROR, but was Tag." + this._tag.name());
        }
        return this.userErrorValue;
    }

    public boolean isAccessError() {
        return this._tag == Tag.ACCESS_ERROR;
    }

    public static GetFileMetadataError accessError(SharingFileAccessError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new GetFileMetadataError().withTagAndAccessError(Tag.ACCESS_ERROR, value);
    }

    public SharingFileAccessError getAccessErrorValue() {
        if (this._tag != Tag.ACCESS_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.ACCESS_ERROR, but was Tag." + this._tag.name());
        }
        return this.accessErrorValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.userErrorValue, this.accessErrorValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof GetFileMetadataError) {
            GetFileMetadataError other = (GetFileMetadataError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case USER_ERROR: {
                    return this.userErrorValue == other.userErrorValue || this.userErrorValue.equals((Object)other.userErrorValue);
                }
                case ACCESS_ERROR: {
                    return this.accessErrorValue == other.accessErrorValue || this.accessErrorValue.equals((Object)other.accessErrorValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<GetFileMetadataError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GetFileMetadataError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case USER_ERROR: {
                    g.writeStartObject();
                    this.writeTag("user_error", g);
                    g.writeFieldName("user_error");
                    SharingUserError.Serializer.INSTANCE.serialize(value.userErrorValue, g);
                    g.writeEndObject();
                    break;
                }
                case ACCESS_ERROR: {
                    g.writeStartObject();
                    this.writeTag("access_error", g);
                    g.writeFieldName("access_error");
                    SharingFileAccessError.Serializer.INSTANCE.serialize(value.accessErrorValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public GetFileMetadataError deserialize(JsonParser p) throws IOException, JsonParseException {
            GetFileMetadataError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("user_error".equals(tag)) {
                SharingUserError fieldValue = null;
                Serializer.expectField("user_error", p);
                fieldValue = SharingUserError.Serializer.INSTANCE.deserialize(p);
                value = GetFileMetadataError.userError(fieldValue);
            } else if ("access_error".equals(tag)) {
                SharingFileAccessError fieldValue = null;
                Serializer.expectField("access_error", p);
                fieldValue = SharingFileAccessError.Serializer.INSTANCE.deserialize(p);
                value = GetFileMetadataError.accessError(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        USER_ERROR,
        ACCESS_ERROR,
        OTHER;

    }
}

