/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

class AddTagArg {
    @Nonnull
    protected final String path;
    @Nonnull
    protected final String tagText;

    public AddTagArg(@Nonnull String path, @Nonnull String tagText) {
        if (path == null) {
            throw new IllegalArgumentException("Required value for 'path' is null");
        }
        if (!Pattern.matches("/(.|\\R)*", path)) {
            throw new IllegalArgumentException("String 'path' does not match pattern");
        }
        this.path = path;
        if (tagText == null) {
            throw new IllegalArgumentException("Required value for 'tagText' is null");
        }
        if (tagText.length() < 1) {
            throw new IllegalArgumentException("String 'tagText' is shorter than 1");
        }
        if (tagText.length() > 32) {
            throw new IllegalArgumentException("String 'tagText' is longer than 32");
        }
        if (!Pattern.matches("[\\w]+", tagText)) {
            throw new IllegalArgumentException("String 'tagText' does not match pattern");
        }
        this.tagText = tagText;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nonnull
    public String getTagText() {
        return this.tagText;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path, this.tagText});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            AddTagArg other = (AddTagArg)obj;
            return !(this.path != other.path && !this.path.equals(other.path) || this.tagText != other.tagText && !this.tagText.equals(other.tagText));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<AddTagArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(AddTagArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("path");
            StoneSerializers.string().serialize(value.path, g);
            g.writeFieldName("tag_text");
            StoneSerializers.string().serialize(value.tagText, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public AddTagArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_tagText;
            String f_path;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_path = null;
                f_tagText = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("path".equals(field)) {
                        f_path = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("tag_text".equals(field)) {
                        f_tagText = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_path == null) {
                    throw new JsonParseException(p, "Required field \"path\" missing.");
                }
                if (f_tagText == null) {
                    throw new JsonParseException(p, "Required field \"tag_text\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            AddTagArg value = new AddTagArg(f_path, f_tagText);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

