/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.ico;

import java.io.DataInput;
import java.io.IOException;
import javax.imageio.IIOException;

abstract class DIBHeader {
    protected int size;
    protected int width;
    protected int height;
    protected int planes;
    protected int bitCount;
    protected int compression;
    protected int imageSize;
    protected int xPixelsPerMeter;
    protected int yPixelsPerMeter;
    protected int colorsUsed;
    protected int colorsImportant;

    protected DIBHeader() {
    }

    public static DIBHeader read(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        DIBHeader dIBHeader = DIBHeader.createHeader(n);
        dIBHeader.read(n, dataInput);
        return dIBHeader;
    }

    private static DIBHeader createHeader(int n) throws IOException {
        switch (n) {
            case 12: 
            case 64: {
                throw new IIOException(String.format("OS/2 Bitmap Information Header (size: %s) not supported", n));
            }
            case 40: {
                return new WindowsV3DIBHeader();
            }
            case 108: 
            case 124: {
                throw new IIOException(String.format("Windows Bitmap Information Header (size: %s) not supported", n));
            }
        }
        throw new IIOException(String.format("Unknown Bitmap Information Header (size: %s)", n));
    }

    protected abstract void read(int var1, DataInput var2) throws IOException;

    public final int getSize() {
        return this.size;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getPlanes() {
        return this.planes;
    }

    public final int getBitCount() {
        return this.bitCount;
    }

    public int getCompression() {
        return this.compression;
    }

    public int getImageSize() {
        return this.imageSize;
    }

    public int getXPixelsPerMeter() {
        return this.xPixelsPerMeter;
    }

    public int getYPixelsPerMeter() {
        return this.yPixelsPerMeter;
    }

    public int getColorsUsed() {
        return this.colorsUsed;
    }

    public int getColorsImportant() {
        return this.colorsImportant;
    }

    public String toString() {
        return String.format("%s: size: %d bytes, width: %d, height: %d, planes: %d, bit count: %d, compression: %d, image size: %d%s, X pixels per m: %d, Y pixels per m: %d, colors used: %d, colors important: %d%s", this.getClass().getSimpleName(), this.getSize(), this.getWidth(), this.getHeight(), this.getPlanes(), this.getBitCount(), this.getCompression(), this.getImageSize(), this.getImageSize() == 0 ? " (unknown)" : "", this.getXPixelsPerMeter(), this.getYPixelsPerMeter(), this.getColorsUsed(), this.getColorsImportant(), this.getColorsImportant() == 0 ? " (all)" : "");
    }

    static final class WindowsV3DIBHeader
    extends DIBHeader {
        WindowsV3DIBHeader() {
        }

        protected void read(int n, DataInput dataInput) throws IOException {
            if (n != 40) {
                throw new IIOException(String.format("Size: %s !=: %s", n, 40));
            }
            this.size = n;
            this.width = dataInput.readInt();
            this.height = dataInput.readInt();
            this.planes = dataInput.readUnsignedShort();
            this.bitCount = dataInput.readUnsignedShort();
            this.compression = dataInput.readInt();
            this.imageSize = dataInput.readInt();
            this.xPixelsPerMeter = dataInput.readInt();
            this.yPixelsPerMeter = dataInput.readInt();
            this.colorsUsed = dataInput.readInt();
            this.colorsImportant = dataInput.readInt();
        }
    }
}

