/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.GroupsClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfAppRoleAssignment;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject0;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject1;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject2;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject3;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject4;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject5;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject6;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfExtension;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject0;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject1;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject2;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject3;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject4;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfProfilePhoto;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfResourceSpecificPermissionGrant;
import com.azure.resourcemanager.authorization.fluent.models.GroupsAssignLicenseRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.GroupsCheckMemberGroupsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.GroupsCheckMemberObjectsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.GroupsGetAvailableExtensionPropertiesRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.GroupsGetByIdsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.GroupsGetMemberGroupsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.GroupsGetMemberObjectsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.GroupsOrderby;
import com.azure.resourcemanager.authorization.fluent.models.GroupsSelect;
import com.azure.resourcemanager.authorization.fluent.models.GroupsValidatePropertiesRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphAppRoleAssignmentInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtensionInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtensionPropertyInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphGroupInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphProfilePhotoInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphResourceSpecificPermissionGrantInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class GroupsClientImpl
implements GroupsClient {
    private final ClientLogger logger = new ClientLogger(GroupsClientImpl.class);
    private final GroupsService service;
    private final MicrosoftGraphClientImpl client;

    GroupsClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (GroupsService)RestProxy.create(GroupsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphAppRoleAssignmentInner>> listAppRoleAssignmentsSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listAppRoleAssignments(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfAppRoleAssignment)res.getValue()).value(), ((CollectionOfAppRoleAssignment)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphAppRoleAssignmentInner>> listAppRoleAssignmentsSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listAppRoleAssignments(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfAppRoleAssignment)res.getValue()).value(), ((CollectionOfAppRoleAssignment)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignmentsAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listAppRoleAssignmentsSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignmentsAsync(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listAppRoleAssignmentsSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignmentsAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listAppRoleAssignmentsSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignments(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<GroupsOrderby> orderby = null;
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listAppRoleAssignmentsAsync(groupId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignments(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listAppRoleAssignmentsAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> createAppRoleAssignmentsWithResponseAsync(String groupId, MicrosoftGraphAppRoleAssignmentInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createAppRoleAssignments(this.client.getEndpoint(), groupId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> createAppRoleAssignmentsWithResponseAsync(String groupId, MicrosoftGraphAppRoleAssignmentInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createAppRoleAssignments(this.client.getEndpoint(), groupId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphAppRoleAssignmentInner> createAppRoleAssignmentsAsync(String groupId, MicrosoftGraphAppRoleAssignmentInner body) {
        return this.createAppRoleAssignmentsWithResponseAsync(groupId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphAppRoleAssignmentInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphAppRoleAssignmentInner createAppRoleAssignments(String groupId, MicrosoftGraphAppRoleAssignmentInner body) {
        return (MicrosoftGraphAppRoleAssignmentInner)this.createAppRoleAssignmentsAsync(groupId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphAppRoleAssignmentInner> createAppRoleAssignmentsWithResponse(String groupId, MicrosoftGraphAppRoleAssignmentInner body, Context context) {
        return (Response)this.createAppRoleAssignmentsWithResponseAsync(groupId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> getAppRoleAssignmentsWithResponseAsync(String groupId, String appRoleAssignmentId, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getAppRoleAssignments(this.client.getEndpoint(), groupId, appRoleAssignmentId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> getAppRoleAssignmentsWithResponseAsync(String groupId, String appRoleAssignmentId, List<GroupsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getAppRoleAssignments(this.client.getEndpoint(), groupId, appRoleAssignmentId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphAppRoleAssignmentInner> getAppRoleAssignmentsAsync(String groupId, String appRoleAssignmentId, List<GroupsSelect> select, List<String> expand) {
        return this.getAppRoleAssignmentsWithResponseAsync(groupId, appRoleAssignmentId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphAppRoleAssignmentInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphAppRoleAssignmentInner> getAppRoleAssignmentsAsync(String groupId, String appRoleAssignmentId) {
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return this.getAppRoleAssignmentsWithResponseAsync(groupId, appRoleAssignmentId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphAppRoleAssignmentInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphAppRoleAssignmentInner getAppRoleAssignments(String groupId, String appRoleAssignmentId) {
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphAppRoleAssignmentInner)this.getAppRoleAssignmentsAsync(groupId, appRoleAssignmentId, select, expand).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphAppRoleAssignmentInner> getAppRoleAssignmentsWithResponse(String groupId, String appRoleAssignmentId, List<GroupsSelect> select, List<String> expand, Context context) {
        return (Response)this.getAppRoleAssignmentsWithResponseAsync(groupId, appRoleAssignmentId, select, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateAppRoleAssignmentsWithResponseAsync(String groupId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateAppRoleAssignments(this.client.getEndpoint(), groupId, appRoleAssignmentId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateAppRoleAssignmentsWithResponseAsync(String groupId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateAppRoleAssignments(this.client.getEndpoint(), groupId, appRoleAssignmentId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateAppRoleAssignmentsAsync(String groupId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body) {
        return this.updateAppRoleAssignmentsWithResponseAsync(groupId, appRoleAssignmentId, body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateAppRoleAssignments(String groupId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body) {
        this.updateAppRoleAssignmentsAsync(groupId, appRoleAssignmentId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateAppRoleAssignmentsWithResponse(String groupId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body, Context context) {
        return (Response)this.updateAppRoleAssignmentsWithResponseAsync(groupId, appRoleAssignmentId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAppRoleAssignmentsWithResponseAsync(String groupId, String appRoleAssignmentId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteAppRoleAssignments(this.client.getEndpoint(), groupId, appRoleAssignmentId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteAppRoleAssignmentsWithResponseAsync(String groupId, String appRoleAssignmentId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteAppRoleAssignments(this.client.getEndpoint(), groupId, appRoleAssignmentId, ifMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAppRoleAssignmentsAsync(String groupId, String appRoleAssignmentId, String ifMatch) {
        return this.deleteAppRoleAssignmentsWithResponseAsync(groupId, appRoleAssignmentId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAppRoleAssignmentsAsync(String groupId, String appRoleAssignmentId) {
        String ifMatch = null;
        return this.deleteAppRoleAssignmentsWithResponseAsync(groupId, appRoleAssignmentId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAppRoleAssignments(String groupId, String appRoleAssignmentId) {
        String ifMatch = null;
        this.deleteAppRoleAssignmentsAsync(groupId, appRoleAssignmentId, ifMatch).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteAppRoleAssignmentsWithResponse(String groupId, String appRoleAssignmentId, String ifMatch, Context context) {
        return (Response)this.deleteAppRoleAssignmentsWithResponseAsync(groupId, appRoleAssignmentId, ifMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listAcceptedSendersSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listAcceptedSenders(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject)res.getValue()).value(), ((CollectionOfDirectoryObject)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listAcceptedSendersSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listAcceptedSenders(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject)res.getValue()).value(), ((CollectionOfDirectoryObject)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listAcceptedSendersAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listAcceptedSendersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listAcceptedSendersNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listAcceptedSendersAsync(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listAcceptedSendersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listAcceptedSendersNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listAcceptedSendersAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listAcceptedSendersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listAcceptedSendersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listAcceptedSenders(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<GroupsOrderby> orderby = null;
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listAcceptedSendersAsync(groupId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listAcceptedSenders(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listAcceptedSendersAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> createAcceptedSendersWithResponseAsync(String groupId, MicrosoftGraphDirectoryObjectInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createAcceptedSenders(this.client.getEndpoint(), groupId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> createAcceptedSendersWithResponseAsync(String groupId, MicrosoftGraphDirectoryObjectInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createAcceptedSenders(this.client.getEndpoint(), groupId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> createAcceptedSendersAsync(String groupId, MicrosoftGraphDirectoryObjectInner body) {
        return this.createAcceptedSendersWithResponseAsync(groupId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryObjectInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphDirectoryObjectInner createAcceptedSenders(String groupId, MicrosoftGraphDirectoryObjectInner body) {
        return (MicrosoftGraphDirectoryObjectInner)this.createAcceptedSendersAsync(groupId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryObjectInner> createAcceptedSendersWithResponse(String groupId, MicrosoftGraphDirectoryObjectInner body, Context context) {
        return (Response)this.createAcceptedSendersWithResponseAsync(groupId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> getAcceptedSendersWithResponseAsync(String groupId, String directoryObjectId, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getAcceptedSenders(this.client.getEndpoint(), groupId, directoryObjectId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> getAcceptedSendersWithResponseAsync(String groupId, String directoryObjectId, List<GroupsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getAcceptedSenders(this.client.getEndpoint(), groupId, directoryObjectId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> getAcceptedSendersAsync(String groupId, String directoryObjectId, List<GroupsSelect> select, List<String> expand) {
        return this.getAcceptedSendersWithResponseAsync(groupId, directoryObjectId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryObjectInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> getAcceptedSendersAsync(String groupId, String directoryObjectId) {
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return this.getAcceptedSendersWithResponseAsync(groupId, directoryObjectId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryObjectInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphDirectoryObjectInner getAcceptedSenders(String groupId, String directoryObjectId) {
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphDirectoryObjectInner)this.getAcceptedSendersAsync(groupId, directoryObjectId, select, expand).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryObjectInner> getAcceptedSendersWithResponse(String groupId, String directoryObjectId, List<GroupsSelect> select, List<String> expand, Context context) {
        return (Response)this.getAcceptedSendersWithResponseAsync(groupId, directoryObjectId, select, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateAcceptedSendersWithResponseAsync(String groupId, String directoryObjectId, MicrosoftGraphDirectoryObjectInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateAcceptedSenders(this.client.getEndpoint(), groupId, directoryObjectId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateAcceptedSendersWithResponseAsync(String groupId, String directoryObjectId, MicrosoftGraphDirectoryObjectInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateAcceptedSenders(this.client.getEndpoint(), groupId, directoryObjectId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateAcceptedSendersAsync(String groupId, String directoryObjectId, MicrosoftGraphDirectoryObjectInner body) {
        return this.updateAcceptedSendersWithResponseAsync(groupId, directoryObjectId, body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateAcceptedSenders(String groupId, String directoryObjectId, MicrosoftGraphDirectoryObjectInner body) {
        this.updateAcceptedSendersAsync(groupId, directoryObjectId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateAcceptedSendersWithResponse(String groupId, String directoryObjectId, MicrosoftGraphDirectoryObjectInner body, Context context) {
        return (Response)this.updateAcceptedSendersWithResponseAsync(groupId, directoryObjectId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAcceptedSendersWithResponseAsync(String groupId, String directoryObjectId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteAcceptedSenders(this.client.getEndpoint(), groupId, directoryObjectId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteAcceptedSendersWithResponseAsync(String groupId, String directoryObjectId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteAcceptedSenders(this.client.getEndpoint(), groupId, directoryObjectId, ifMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAcceptedSendersAsync(String groupId, String directoryObjectId, String ifMatch) {
        return this.deleteAcceptedSendersWithResponseAsync(groupId, directoryObjectId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAcceptedSendersAsync(String groupId, String directoryObjectId) {
        String ifMatch = null;
        return this.deleteAcceptedSendersWithResponseAsync(groupId, directoryObjectId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAcceptedSenders(String groupId, String directoryObjectId) {
        String ifMatch = null;
        this.deleteAcceptedSendersAsync(groupId, directoryObjectId, ifMatch).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteAcceptedSendersWithResponse(String groupId, String directoryObjectId, String ifMatch, Context context) {
        return (Response)this.deleteAcceptedSendersWithResponseAsync(groupId, directoryObjectId, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> getCreatedOnBehalfOfWithResponseAsync(String groupId, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getCreatedOnBehalfOf(this.client.getEndpoint(), groupId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> getCreatedOnBehalfOfWithResponseAsync(String groupId, List<GroupsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getCreatedOnBehalfOf(this.client.getEndpoint(), groupId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> getCreatedOnBehalfOfAsync(String groupId, List<GroupsSelect> select, List<String> expand) {
        return this.getCreatedOnBehalfOfWithResponseAsync(groupId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryObjectInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> getCreatedOnBehalfOfAsync(String groupId) {
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return this.getCreatedOnBehalfOfWithResponseAsync(groupId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryObjectInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphDirectoryObjectInner getCreatedOnBehalfOf(String groupId) {
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphDirectoryObjectInner)this.getCreatedOnBehalfOfAsync(groupId, select, expand).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryObjectInner> getCreatedOnBehalfOfWithResponse(String groupId, List<GroupsSelect> select, List<String> expand, Context context) {
        return (Response)this.getCreatedOnBehalfOfWithResponseAsync(groupId, select, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<String>> getRefCreatedOnBehalfOfWithResponseAsync(String groupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getRefCreatedOnBehalfOf(this.client.getEndpoint(), groupId, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<String>> getRefCreatedOnBehalfOfWithResponseAsync(String groupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getRefCreatedOnBehalfOf(this.client.getEndpoint(), groupId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> getRefCreatedOnBehalfOfAsync(String groupId) {
        return this.getRefCreatedOnBehalfOfWithResponseAsync(groupId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((String)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public String getRefCreatedOnBehalfOf(String groupId) {
        return (String)this.getRefCreatedOnBehalfOfAsync(groupId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> getRefCreatedOnBehalfOfWithResponse(String groupId, Context context) {
        return (Response)this.getRefCreatedOnBehalfOfWithResponseAsync(groupId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setRefCreatedOnBehalfOfWithResponseAsync(String groupId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.setRefCreatedOnBehalfOf(this.client.getEndpoint(), groupId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> setRefCreatedOnBehalfOfWithResponseAsync(String groupId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.setRefCreatedOnBehalfOf(this.client.getEndpoint(), groupId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setRefCreatedOnBehalfOfAsync(String groupId, Map<String, Object> body) {
        return this.setRefCreatedOnBehalfOfWithResponseAsync(groupId, body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setRefCreatedOnBehalfOf(String groupId, Map<String, Object> body) {
        this.setRefCreatedOnBehalfOfAsync(groupId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setRefCreatedOnBehalfOfWithResponse(String groupId, Map<String, Object> body, Context context) {
        return (Response)this.setRefCreatedOnBehalfOfWithResponseAsync(groupId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteRefCreatedOnBehalfOfWithResponseAsync(String groupId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteRefCreatedOnBehalfOf(this.client.getEndpoint(), groupId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteRefCreatedOnBehalfOfWithResponseAsync(String groupId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteRefCreatedOnBehalfOf(this.client.getEndpoint(), groupId, ifMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteRefCreatedOnBehalfOfAsync(String groupId, String ifMatch) {
        return this.deleteRefCreatedOnBehalfOfWithResponseAsync(groupId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteRefCreatedOnBehalfOfAsync(String groupId) {
        String ifMatch = null;
        return this.deleteRefCreatedOnBehalfOfWithResponseAsync(groupId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteRefCreatedOnBehalfOf(String groupId) {
        String ifMatch = null;
        this.deleteRefCreatedOnBehalfOfAsync(groupId, ifMatch).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteRefCreatedOnBehalfOfWithResponse(String groupId, String ifMatch, Context context) {
        return (Response)this.deleteRefCreatedOnBehalfOfWithResponseAsync(groupId, ifMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listExtensionsSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<String> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listExtensions(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtension)res.getValue()).value(), ((CollectionOfExtension)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listExtensionsSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<String> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listExtensions(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtension)res.getValue()).value(), ((CollectionOfExtension)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<String> select, List<String> expand) {
        return new PagedFlux(() -> this.listExtensionsSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listExtensionsNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listExtensionsSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listExtensionsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<String> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listExtensionsSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listExtensionsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphExtensionInner> listExtensions(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<GroupsOrderby> orderby = null;
        List<String> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listExtensionsAsync(groupId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphExtensionInner> listExtensions(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<String> select, List<String> expand, Context context) {
        return new PagedIterable(this.listExtensionsAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphExtensionInner>> createExtensionsWithResponseAsync(String groupId, MicrosoftGraphExtensionInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createExtensions(this.client.getEndpoint(), groupId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphExtensionInner>> createExtensionsWithResponseAsync(String groupId, MicrosoftGraphExtensionInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createExtensions(this.client.getEndpoint(), groupId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphExtensionInner> createExtensionsAsync(String groupId, MicrosoftGraphExtensionInner body) {
        return this.createExtensionsWithResponseAsync(groupId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphExtensionInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphExtensionInner createExtensions(String groupId, MicrosoftGraphExtensionInner body) {
        return (MicrosoftGraphExtensionInner)this.createExtensionsAsync(groupId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphExtensionInner> createExtensionsWithResponse(String groupId, MicrosoftGraphExtensionInner body, Context context) {
        return (Response)this.createExtensionsWithResponseAsync(groupId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphExtensionInner>> getExtensionsWithResponseAsync(String groupId, String extensionId, List<String> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getExtensions(this.client.getEndpoint(), groupId, extensionId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphExtensionInner>> getExtensionsWithResponseAsync(String groupId, String extensionId, List<String> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getExtensions(this.client.getEndpoint(), groupId, extensionId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphExtensionInner> getExtensionsAsync(String groupId, String extensionId, List<String> select, List<String> expand) {
        return this.getExtensionsWithResponseAsync(groupId, extensionId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphExtensionInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphExtensionInner> getExtensionsAsync(String groupId, String extensionId) {
        List<String> select = null;
        List<String> expand = null;
        return this.getExtensionsWithResponseAsync(groupId, extensionId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphExtensionInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphExtensionInner getExtensions(String groupId, String extensionId) {
        List<String> select = null;
        List<String> expand = null;
        return (MicrosoftGraphExtensionInner)this.getExtensionsAsync(groupId, extensionId, select, expand).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphExtensionInner> getExtensionsWithResponse(String groupId, String extensionId, List<String> select, List<String> expand, Context context) {
        return (Response)this.getExtensionsWithResponseAsync(groupId, extensionId, select, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateExtensionsWithResponseAsync(String groupId, String extensionId, MicrosoftGraphExtensionInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateExtensions(this.client.getEndpoint(), groupId, extensionId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateExtensionsWithResponseAsync(String groupId, String extensionId, MicrosoftGraphExtensionInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateExtensions(this.client.getEndpoint(), groupId, extensionId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateExtensionsAsync(String groupId, String extensionId, MicrosoftGraphExtensionInner body) {
        return this.updateExtensionsWithResponseAsync(groupId, extensionId, body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateExtensions(String groupId, String extensionId, MicrosoftGraphExtensionInner body) {
        this.updateExtensionsAsync(groupId, extensionId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateExtensionsWithResponse(String groupId, String extensionId, MicrosoftGraphExtensionInner body, Context context) {
        return (Response)this.updateExtensionsWithResponseAsync(groupId, extensionId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteExtensionsWithResponseAsync(String groupId, String extensionId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteExtensions(this.client.getEndpoint(), groupId, extensionId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteExtensionsWithResponseAsync(String groupId, String extensionId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteExtensions(this.client.getEndpoint(), groupId, extensionId, ifMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteExtensionsAsync(String groupId, String extensionId, String ifMatch) {
        return this.deleteExtensionsWithResponseAsync(groupId, extensionId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteExtensionsAsync(String groupId, String extensionId) {
        String ifMatch = null;
        return this.deleteExtensionsWithResponseAsync(groupId, extensionId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteExtensions(String groupId, String extensionId) {
        String ifMatch = null;
        this.deleteExtensionsAsync(groupId, extensionId, ifMatch).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteExtensionsWithResponse(String groupId, String extensionId, String ifMatch, Context context) {
        return (Response)this.deleteExtensionsWithResponseAsync(groupId, extensionId, ifMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listMemberOf(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject0)res.getValue()).value(), ((CollectionOfDirectoryObject0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listMemberOf(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject0)res.getValue()).value(), ((CollectionOfDirectoryObject0)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMemberOfAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listMemberOfSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMemberOfNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMemberOfAsync(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listMemberOfSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMemberOfNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listMemberOfAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listMemberOfSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMemberOfNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMemberOf(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<GroupsOrderby> orderby = null;
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listMemberOfAsync(groupId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMemberOf(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listMemberOfAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMemberOfSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefMemberOf(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMemberOfSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefMemberOf(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefMemberOfAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby) {
        return new PagedFlux(() -> this.listRefMemberOfSinglePageAsync(groupId, top, skip, search, filter, count, orderby), nextLink -> this.listRefMemberOfNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefMemberOfAsync(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefMemberOfSinglePageAsync(groupId, top, skip, search, filter, count, orderby), nextLink -> this.listRefMemberOfNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<String> listRefMemberOfAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefMemberOfSinglePageAsync(groupId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefMemberOfNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefMemberOf(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<GroupsOrderby> orderby = null;
        return new PagedIterable(this.listRefMemberOfAsync(groupId, top, skip, search, filter, count, orderby));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefMemberOf(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefMemberOfAsync(groupId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefMemberOfWithResponseAsync(String groupId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefMemberOf(this.client.getEndpoint(), groupId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefMemberOfWithResponseAsync(String groupId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefMemberOf(this.client.getEndpoint(), groupId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefMemberOfAsync(String groupId, Map<String, Object> body) {
        return this.createRefMemberOfWithResponseAsync(groupId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, Object> createRefMemberOf(String groupId, Map<String, Object> body) {
        return (Map)this.createRefMemberOfAsync(groupId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefMemberOfWithResponse(String groupId, Map<String, Object> body, Context context) {
        return (Response)this.createRefMemberOfWithResponseAsync(groupId, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listMembers(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject1)res.getValue()).value(), ((CollectionOfDirectoryObject1)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listMembers(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject1)res.getValue()).value(), ((CollectionOfDirectoryObject1)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMembersNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersAsync(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMembersNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMembersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMembers(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<GroupsOrderby> orderby = null;
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listMembersAsync(groupId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMembers(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listMembersAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefMembers(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject0)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefMembers(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject0)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject0)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefMembersAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby) {
        return new PagedFlux(() -> this.listRefMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby), nextLink -> this.listRefMembersNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefMembersAsync(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby), nextLink -> this.listRefMembersNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<String> listRefMembersAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefMembersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefMembers(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<GroupsOrderby> orderby = null;
        return new PagedIterable(this.listRefMembersAsync(groupId, top, skip, search, filter, count, orderby));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefMembers(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefMembersAsync(groupId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createRefMembersWithResponseAsync(String groupId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefMembers(this.client.getEndpoint(), groupId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> createRefMembersWithResponseAsync(String groupId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefMembers(this.client.getEndpoint(), groupId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createRefMembersAsync(String groupId, Map<String, Object> body) {
        return this.createRefMembersWithResponseAsync(groupId, body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createRefMembers(String groupId, Map<String, Object> body) {
        this.createRefMembersAsync(groupId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createRefMembersWithResponse(String groupId, Map<String, Object> body, Context context) {
        return (Response)this.createRefMembersWithResponseAsync(groupId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteRefMemberWithResponseAsync(String groupId, String directoryObjectId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteRefMember(this.client.getEndpoint(), groupId, directoryObjectId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteRefMemberWithResponseAsync(String groupId, String directoryObjectId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteRefMember(this.client.getEndpoint(), groupId, directoryObjectId, ifMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteRefMemberAsync(String groupId, String directoryObjectId, String ifMatch) {
        return this.deleteRefMemberWithResponseAsync(groupId, directoryObjectId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteRefMemberAsync(String groupId, String directoryObjectId) {
        String ifMatch = null;
        return this.deleteRefMemberWithResponseAsync(groupId, directoryObjectId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteRefMember(String groupId, String directoryObjectId) {
        String ifMatch = null;
        this.deleteRefMemberAsync(groupId, directoryObjectId, ifMatch).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteRefMemberWithResponse(String groupId, String directoryObjectId, String ifMatch, Context context) {
        return (Response)this.deleteRefMemberWithResponseAsync(groupId, directoryObjectId, ifMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersWithLicenseErrorsSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listMembersWithLicenseErrors(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject2)res.getValue()).value(), ((CollectionOfDirectoryObject2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersWithLicenseErrorsSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listMembersWithLicenseErrors(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject2)res.getValue()).value(), ((CollectionOfDirectoryObject2)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersWithLicenseErrorsAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listMembersWithLicenseErrorsSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMembersWithLicenseErrorsNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersWithLicenseErrorsAsync(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listMembersWithLicenseErrorsSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMembersWithLicenseErrorsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersWithLicenseErrorsAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listMembersWithLicenseErrorsSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMembersWithLicenseErrorsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMembersWithLicenseErrors(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<GroupsOrderby> orderby = null;
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listMembersWithLicenseErrorsAsync(groupId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMembersWithLicenseErrors(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listMembersWithLicenseErrorsAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersWithLicenseErrorsSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefMembersWithLicenseErrors(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject1)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject1)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersWithLicenseErrorsSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefMembersWithLicenseErrors(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject1)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject1)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefMembersWithLicenseErrorsAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby) {
        return new PagedFlux(() -> this.listRefMembersWithLicenseErrorsSinglePageAsync(groupId, top, skip, search, filter, count, orderby), nextLink -> this.listRefMembersWithLicenseErrorsNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefMembersWithLicenseErrorsAsync(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefMembersWithLicenseErrorsSinglePageAsync(groupId, top, skip, search, filter, count, orderby), nextLink -> this.listRefMembersWithLicenseErrorsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<String> listRefMembersWithLicenseErrorsAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefMembersWithLicenseErrorsSinglePageAsync(groupId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefMembersWithLicenseErrorsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefMembersWithLicenseErrors(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<GroupsOrderby> orderby = null;
        return new PagedIterable(this.listRefMembersWithLicenseErrorsAsync(groupId, top, skip, search, filter, count, orderby));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefMembersWithLicenseErrors(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefMembersWithLicenseErrorsAsync(groupId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefMembersWithLicenseErrorsWithResponseAsync(String groupId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefMembersWithLicenseErrors(this.client.getEndpoint(), groupId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefMembersWithLicenseErrorsWithResponseAsync(String groupId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefMembersWithLicenseErrors(this.client.getEndpoint(), groupId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefMembersWithLicenseErrorsAsync(String groupId, Map<String, Object> body) {
        return this.createRefMembersWithLicenseErrorsWithResponseAsync(groupId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, Object> createRefMembersWithLicenseErrors(String groupId, Map<String, Object> body) {
        return (Map)this.createRefMembersWithLicenseErrorsAsync(groupId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefMembersWithLicenseErrorsWithResponse(String groupId, Map<String, Object> body, Context context) {
        return (Response)this.createRefMembersWithLicenseErrorsWithResponseAsync(groupId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> addFavoriteWithResponseAsync(String groupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.addFavorite(this.client.getEndpoint(), groupId, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> addFavoriteWithResponseAsync(String groupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.addFavorite(this.client.getEndpoint(), groupId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> addFavoriteAsync(String groupId) {
        return this.addFavoriteWithResponseAsync(groupId).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void addFavorite(String groupId) {
        this.addFavoriteAsync(groupId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> addFavoriteWithResponse(String groupId, Context context) {
        return (Response)this.addFavoriteWithResponseAsync(groupId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphGroupInner>> assignLicenseWithResponseAsync(String groupId, GroupsAssignLicenseRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.assignLicense(this.client.getEndpoint(), groupId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphGroupInner>> assignLicenseWithResponseAsync(String groupId, GroupsAssignLicenseRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.assignLicense(this.client.getEndpoint(), groupId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphGroupInner> assignLicenseAsync(String groupId, GroupsAssignLicenseRequestBody body) {
        return this.assignLicenseWithResponseAsync(groupId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphGroupInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphGroupInner assignLicense(String groupId, GroupsAssignLicenseRequestBody body) {
        return (MicrosoftGraphGroupInner)this.assignLicenseAsync(groupId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphGroupInner> assignLicenseWithResponse(String groupId, GroupsAssignLicenseRequestBody body, Context context) {
        return (Response)this.assignLicenseWithResponseAsync(groupId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<MicrosoftGraphResourceSpecificPermissionGrantInner>>> checkGrantedPermissionsForAppWithResponseAsync(String groupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkGrantedPermissionsForApp(this.client.getEndpoint(), groupId, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<MicrosoftGraphResourceSpecificPermissionGrantInner>>> checkGrantedPermissionsForAppWithResponseAsync(String groupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkGrantedPermissionsForApp(this.client.getEndpoint(), groupId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<MicrosoftGraphResourceSpecificPermissionGrantInner>> checkGrantedPermissionsForAppAsync(String groupId) {
        return this.checkGrantedPermissionsForAppWithResponseAsync(groupId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<MicrosoftGraphResourceSpecificPermissionGrantInner> checkGrantedPermissionsForApp(String groupId) {
        return (List)this.checkGrantedPermissionsForAppAsync(groupId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<MicrosoftGraphResourceSpecificPermissionGrantInner>> checkGrantedPermissionsForAppWithResponse(String groupId, Context context) {
        return (Response)this.checkGrantedPermissionsForAppWithResponseAsync(groupId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<String>>> checkMemberGroupsWithResponseAsync(String groupId, GroupsCheckMemberGroupsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkMemberGroups(this.client.getEndpoint(), groupId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<String>>> checkMemberGroupsWithResponseAsync(String groupId, GroupsCheckMemberGroupsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkMemberGroups(this.client.getEndpoint(), groupId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<String>> checkMemberGroupsAsync(String groupId, GroupsCheckMemberGroupsRequestBody body) {
        return this.checkMemberGroupsWithResponseAsync(groupId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<String> checkMemberGroups(String groupId, GroupsCheckMemberGroupsRequestBody body) {
        return (List)this.checkMemberGroupsAsync(groupId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<String>> checkMemberGroupsWithResponse(String groupId, GroupsCheckMemberGroupsRequestBody body, Context context) {
        return (Response)this.checkMemberGroupsWithResponseAsync(groupId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<String>>> checkMemberObjectsWithResponseAsync(String groupId, GroupsCheckMemberObjectsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkMemberObjects(this.client.getEndpoint(), groupId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<String>>> checkMemberObjectsWithResponseAsync(String groupId, GroupsCheckMemberObjectsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkMemberObjects(this.client.getEndpoint(), groupId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<String>> checkMemberObjectsAsync(String groupId, GroupsCheckMemberObjectsRequestBody body) {
        return this.checkMemberObjectsWithResponseAsync(groupId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<String> checkMemberObjects(String groupId, GroupsCheckMemberObjectsRequestBody body) {
        return (List)this.checkMemberObjectsAsync(groupId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<String>> checkMemberObjectsWithResponse(String groupId, GroupsCheckMemberObjectsRequestBody body, Context context) {
        return (Response)this.checkMemberObjectsWithResponseAsync(groupId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<String>>> getMemberGroupsWithResponseAsync(String groupId, GroupsGetMemberGroupsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMemberGroups(this.client.getEndpoint(), groupId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<String>>> getMemberGroupsWithResponseAsync(String groupId, GroupsGetMemberGroupsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getMemberGroups(this.client.getEndpoint(), groupId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<String>> getMemberGroupsAsync(String groupId, GroupsGetMemberGroupsRequestBody body) {
        return this.getMemberGroupsWithResponseAsync(groupId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<String> getMemberGroups(String groupId, GroupsGetMemberGroupsRequestBody body) {
        return (List)this.getMemberGroupsAsync(groupId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<String>> getMemberGroupsWithResponse(String groupId, GroupsGetMemberGroupsRequestBody body, Context context) {
        return (Response)this.getMemberGroupsWithResponseAsync(groupId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<String>>> getMemberObjectsWithResponseAsync(String groupId, GroupsGetMemberObjectsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMemberObjects(this.client.getEndpoint(), groupId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<String>>> getMemberObjectsWithResponseAsync(String groupId, GroupsGetMemberObjectsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getMemberObjects(this.client.getEndpoint(), groupId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<String>> getMemberObjectsAsync(String groupId, GroupsGetMemberObjectsRequestBody body) {
        return this.getMemberObjectsWithResponseAsync(groupId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<String> getMemberObjects(String groupId, GroupsGetMemberObjectsRequestBody body) {
        return (List)this.getMemberObjectsAsync(groupId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<String>> getMemberObjectsWithResponse(String groupId, GroupsGetMemberObjectsRequestBody body, Context context) {
        return (Response)this.getMemberObjectsWithResponseAsync(groupId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeFavoriteWithResponseAsync(String groupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.removeFavorite(this.client.getEndpoint(), groupId, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> removeFavoriteWithResponseAsync(String groupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.removeFavorite(this.client.getEndpoint(), groupId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> removeFavoriteAsync(String groupId) {
        return this.removeFavoriteWithResponseAsync(groupId).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void removeFavorite(String groupId) {
        this.removeFavoriteAsync(groupId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeFavoriteWithResponse(String groupId, Context context) {
        return (Response)this.removeFavoriteWithResponseAsync(groupId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renewWithResponseAsync(String groupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.renew(this.client.getEndpoint(), groupId, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> renewWithResponseAsync(String groupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.renew(this.client.getEndpoint(), groupId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renewAsync(String groupId) {
        return this.renewWithResponseAsync(groupId).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void renew(String groupId) {
        this.renewAsync(groupId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> renewWithResponse(String groupId, Context context) {
        return (Response)this.renewWithResponseAsync(groupId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> resetUnseenCountWithResponseAsync(String groupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.resetUnseenCount(this.client.getEndpoint(), groupId, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> resetUnseenCountWithResponseAsync(String groupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.resetUnseenCount(this.client.getEndpoint(), groupId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> resetUnseenCountAsync(String groupId) {
        return this.resetUnseenCountWithResponseAsync(groupId).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void resetUnseenCount(String groupId) {
        this.resetUnseenCountAsync(groupId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> resetUnseenCountWithResponse(String groupId, Context context) {
        return (Response)this.resetUnseenCountWithResponseAsync(groupId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> restoreWithResponseAsync(String groupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restore(this.client.getEndpoint(), groupId, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> restoreWithResponseAsync(String groupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.restore(this.client.getEndpoint(), groupId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> restoreAsync(String groupId) {
        return this.restoreWithResponseAsync(groupId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryObjectInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphDirectoryObjectInner restore(String groupId) {
        return (MicrosoftGraphDirectoryObjectInner)this.restoreAsync(groupId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryObjectInner> restoreWithResponse(String groupId, Context context) {
        return (Response)this.restoreWithResponseAsync(groupId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> subscribeByMailWithResponseAsync(String groupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.subscribeByMail(this.client.getEndpoint(), groupId, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> subscribeByMailWithResponseAsync(String groupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.subscribeByMail(this.client.getEndpoint(), groupId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> subscribeByMailAsync(String groupId) {
        return this.subscribeByMailWithResponseAsync(groupId).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void subscribeByMail(String groupId) {
        this.subscribeByMailAsync(groupId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> subscribeByMailWithResponse(String groupId, Context context) {
        return (Response)this.subscribeByMailWithResponseAsync(groupId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> unsubscribeByMailWithResponseAsync(String groupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.unsubscribeByMail(this.client.getEndpoint(), groupId, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> unsubscribeByMailWithResponseAsync(String groupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.unsubscribeByMail(this.client.getEndpoint(), groupId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> unsubscribeByMailAsync(String groupId) {
        return this.unsubscribeByMailWithResponseAsync(groupId).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void unsubscribeByMail(String groupId) {
        this.unsubscribeByMailAsync(groupId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> unsubscribeByMailWithResponse(String groupId, Context context) {
        return (Response)this.unsubscribeByMailWithResponseAsync(groupId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> validatePropertiesWithResponseAsync(String groupId, GroupsValidatePropertiesRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateProperties(this.client.getEndpoint(), groupId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> validatePropertiesWithResponseAsync(String groupId, GroupsValidatePropertiesRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validateProperties(this.client.getEndpoint(), groupId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> validatePropertiesAsync(String groupId, GroupsValidatePropertiesRequestBody body) {
        return this.validatePropertiesWithResponseAsync(groupId, body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void validateProperties(String groupId, GroupsValidatePropertiesRequestBody body) {
        this.validatePropertiesAsync(groupId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> validatePropertiesWithResponse(String groupId, GroupsValidatePropertiesRequestBody body, Context context) {
        return (Response)this.validatePropertiesWithResponseAsync(groupId, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listOwnersSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listOwners(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject3)res.getValue()).value(), ((CollectionOfDirectoryObject3)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listOwnersSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listOwners(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject3)res.getValue()).value(), ((CollectionOfDirectoryObject3)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listOwnersAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listOwnersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listOwnersNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listOwnersAsync(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listOwnersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listOwnersNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listOwnersAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listOwnersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listOwnersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listOwners(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<GroupsOrderby> orderby = null;
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listOwnersAsync(groupId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listOwners(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listOwnersAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefOwnersSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefOwners(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefOwnersSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefOwners(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject2)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefOwnersAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby) {
        return new PagedFlux(() -> this.listRefOwnersSinglePageAsync(groupId, top, skip, search, filter, count, orderby), nextLink -> this.listRefOwnersNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefOwnersAsync(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefOwnersSinglePageAsync(groupId, top, skip, search, filter, count, orderby), nextLink -> this.listRefOwnersNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<String> listRefOwnersAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefOwnersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefOwnersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefOwners(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<GroupsOrderby> orderby = null;
        return new PagedIterable(this.listRefOwnersAsync(groupId, top, skip, search, filter, count, orderby));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefOwners(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefOwnersAsync(groupId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefOwnersWithResponseAsync(String groupId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefOwners(this.client.getEndpoint(), groupId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefOwnersWithResponseAsync(String groupId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefOwners(this.client.getEndpoint(), groupId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefOwnersAsync(String groupId, Map<String, Object> body) {
        return this.createRefOwnersWithResponseAsync(groupId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, Object> createRefOwners(String groupId, Map<String, Object> body) {
        return (Map)this.createRefOwnersAsync(groupId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefOwnersWithResponse(String groupId, Map<String, Object> body, Context context) {
        return (Response)this.createRefOwnersWithResponseAsync(groupId, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphResourceSpecificPermissionGrantInner>> listPermissionGrantsSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listPermissionGrants(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfResourceSpecificPermissionGrant)res.getValue()).value(), ((CollectionOfResourceSpecificPermissionGrant)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphResourceSpecificPermissionGrantInner>> listPermissionGrantsSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listPermissionGrants(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfResourceSpecificPermissionGrant)res.getValue()).value(), ((CollectionOfResourceSpecificPermissionGrant)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphResourceSpecificPermissionGrantInner> listPermissionGrantsAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listPermissionGrantsSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listPermissionGrantsNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphResourceSpecificPermissionGrantInner> listPermissionGrantsAsync(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listPermissionGrantsSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listPermissionGrantsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphResourceSpecificPermissionGrantInner> listPermissionGrantsAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listPermissionGrantsSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listPermissionGrantsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphResourceSpecificPermissionGrantInner> listPermissionGrants(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<GroupsOrderby> orderby = null;
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listPermissionGrantsAsync(groupId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphResourceSpecificPermissionGrantInner> listPermissionGrants(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listPermissionGrantsAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphResourceSpecificPermissionGrantInner>> createPermissionGrantsWithResponseAsync(String groupId, MicrosoftGraphResourceSpecificPermissionGrantInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createPermissionGrants(this.client.getEndpoint(), groupId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphResourceSpecificPermissionGrantInner>> createPermissionGrantsWithResponseAsync(String groupId, MicrosoftGraphResourceSpecificPermissionGrantInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createPermissionGrants(this.client.getEndpoint(), groupId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphResourceSpecificPermissionGrantInner> createPermissionGrantsAsync(String groupId, MicrosoftGraphResourceSpecificPermissionGrantInner body) {
        return this.createPermissionGrantsWithResponseAsync(groupId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphResourceSpecificPermissionGrantInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphResourceSpecificPermissionGrantInner createPermissionGrants(String groupId, MicrosoftGraphResourceSpecificPermissionGrantInner body) {
        return (MicrosoftGraphResourceSpecificPermissionGrantInner)this.createPermissionGrantsAsync(groupId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphResourceSpecificPermissionGrantInner> createPermissionGrantsWithResponse(String groupId, MicrosoftGraphResourceSpecificPermissionGrantInner body, Context context) {
        return (Response)this.createPermissionGrantsWithResponseAsync(groupId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphResourceSpecificPermissionGrantInner>> getPermissionGrantsWithResponseAsync(String groupId, String resourceSpecificPermissionGrantId, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (resourceSpecificPermissionGrantId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceSpecificPermissionGrantId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getPermissionGrants(this.client.getEndpoint(), groupId, resourceSpecificPermissionGrantId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphResourceSpecificPermissionGrantInner>> getPermissionGrantsWithResponseAsync(String groupId, String resourceSpecificPermissionGrantId, List<GroupsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (resourceSpecificPermissionGrantId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceSpecificPermissionGrantId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getPermissionGrants(this.client.getEndpoint(), groupId, resourceSpecificPermissionGrantId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphResourceSpecificPermissionGrantInner> getPermissionGrantsAsync(String groupId, String resourceSpecificPermissionGrantId, List<GroupsSelect> select, List<String> expand) {
        return this.getPermissionGrantsWithResponseAsync(groupId, resourceSpecificPermissionGrantId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphResourceSpecificPermissionGrantInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphResourceSpecificPermissionGrantInner> getPermissionGrantsAsync(String groupId, String resourceSpecificPermissionGrantId) {
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return this.getPermissionGrantsWithResponseAsync(groupId, resourceSpecificPermissionGrantId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphResourceSpecificPermissionGrantInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphResourceSpecificPermissionGrantInner getPermissionGrants(String groupId, String resourceSpecificPermissionGrantId) {
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphResourceSpecificPermissionGrantInner)this.getPermissionGrantsAsync(groupId, resourceSpecificPermissionGrantId, select, expand).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphResourceSpecificPermissionGrantInner> getPermissionGrantsWithResponse(String groupId, String resourceSpecificPermissionGrantId, List<GroupsSelect> select, List<String> expand, Context context) {
        return (Response)this.getPermissionGrantsWithResponseAsync(groupId, resourceSpecificPermissionGrantId, select, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updatePermissionGrantsWithResponseAsync(String groupId, String resourceSpecificPermissionGrantId, MicrosoftGraphResourceSpecificPermissionGrantInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (resourceSpecificPermissionGrantId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceSpecificPermissionGrantId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updatePermissionGrants(this.client.getEndpoint(), groupId, resourceSpecificPermissionGrantId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updatePermissionGrantsWithResponseAsync(String groupId, String resourceSpecificPermissionGrantId, MicrosoftGraphResourceSpecificPermissionGrantInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (resourceSpecificPermissionGrantId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceSpecificPermissionGrantId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updatePermissionGrants(this.client.getEndpoint(), groupId, resourceSpecificPermissionGrantId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updatePermissionGrantsAsync(String groupId, String resourceSpecificPermissionGrantId, MicrosoftGraphResourceSpecificPermissionGrantInner body) {
        return this.updatePermissionGrantsWithResponseAsync(groupId, resourceSpecificPermissionGrantId, body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updatePermissionGrants(String groupId, String resourceSpecificPermissionGrantId, MicrosoftGraphResourceSpecificPermissionGrantInner body) {
        this.updatePermissionGrantsAsync(groupId, resourceSpecificPermissionGrantId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updatePermissionGrantsWithResponse(String groupId, String resourceSpecificPermissionGrantId, MicrosoftGraphResourceSpecificPermissionGrantInner body, Context context) {
        return (Response)this.updatePermissionGrantsWithResponseAsync(groupId, resourceSpecificPermissionGrantId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deletePermissionGrantsWithResponseAsync(String groupId, String resourceSpecificPermissionGrantId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (resourceSpecificPermissionGrantId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceSpecificPermissionGrantId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deletePermissionGrants(this.client.getEndpoint(), groupId, resourceSpecificPermissionGrantId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deletePermissionGrantsWithResponseAsync(String groupId, String resourceSpecificPermissionGrantId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (resourceSpecificPermissionGrantId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceSpecificPermissionGrantId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deletePermissionGrants(this.client.getEndpoint(), groupId, resourceSpecificPermissionGrantId, ifMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deletePermissionGrantsAsync(String groupId, String resourceSpecificPermissionGrantId, String ifMatch) {
        return this.deletePermissionGrantsWithResponseAsync(groupId, resourceSpecificPermissionGrantId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deletePermissionGrantsAsync(String groupId, String resourceSpecificPermissionGrantId) {
        String ifMatch = null;
        return this.deletePermissionGrantsWithResponseAsync(groupId, resourceSpecificPermissionGrantId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deletePermissionGrants(String groupId, String resourceSpecificPermissionGrantId) {
        String ifMatch = null;
        this.deletePermissionGrantsAsync(groupId, resourceSpecificPermissionGrantId, ifMatch).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deletePermissionGrantsWithResponse(String groupId, String resourceSpecificPermissionGrantId, String ifMatch, Context context) {
        return (Response)this.deletePermissionGrantsWithResponseAsync(groupId, resourceSpecificPermissionGrantId, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphProfilePhotoInner>> getPhotoWithResponseAsync(String groupId, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getPhoto(this.client.getEndpoint(), groupId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphProfilePhotoInner>> getPhotoWithResponseAsync(String groupId, List<GroupsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getPhoto(this.client.getEndpoint(), groupId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphProfilePhotoInner> getPhotoAsync(String groupId, List<GroupsSelect> select, List<String> expand) {
        return this.getPhotoWithResponseAsync(groupId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphProfilePhotoInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphProfilePhotoInner> getPhotoAsync(String groupId) {
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return this.getPhotoWithResponseAsync(groupId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphProfilePhotoInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphProfilePhotoInner getPhoto(String groupId) {
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphProfilePhotoInner)this.getPhotoAsync(groupId, select, expand).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphProfilePhotoInner> getPhotoWithResponse(String groupId, List<GroupsSelect> select, List<String> expand, Context context) {
        return (Response)this.getPhotoWithResponseAsync(groupId, select, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updatePhotoWithResponseAsync(String groupId, MicrosoftGraphProfilePhotoInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updatePhoto(this.client.getEndpoint(), groupId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updatePhotoWithResponseAsync(String groupId, MicrosoftGraphProfilePhotoInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updatePhoto(this.client.getEndpoint(), groupId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updatePhotoAsync(String groupId, MicrosoftGraphProfilePhotoInner body) {
        return this.updatePhotoWithResponseAsync(groupId, body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updatePhoto(String groupId, MicrosoftGraphProfilePhotoInner body) {
        this.updatePhotoAsync(groupId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updatePhotoWithResponse(String groupId, MicrosoftGraphProfilePhotoInner body, Context context) {
        return (Response)this.updatePhotoWithResponseAsync(groupId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deletePhotoWithResponseAsync(String groupId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deletePhoto(this.client.getEndpoint(), groupId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deletePhotoWithResponseAsync(String groupId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deletePhoto(this.client.getEndpoint(), groupId, ifMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deletePhotoAsync(String groupId, String ifMatch) {
        return this.deletePhotoWithResponseAsync(groupId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deletePhotoAsync(String groupId) {
        String ifMatch = null;
        return this.deletePhotoWithResponseAsync(groupId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deletePhoto(String groupId) {
        String ifMatch = null;
        this.deletePhotoAsync(groupId, ifMatch).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deletePhotoWithResponse(String groupId, String ifMatch, Context context) {
        return (Response)this.deletePhotoWithResponseAsync(groupId, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> getPhotoContentWithResponseAsync(String groupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/octet-stream, application/json";
        return FluxUtil.withContext(context -> this.service.getPhotoContent(this.client.getEndpoint(), groupId, "application/octet-stream, application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<StreamResponse> getPhotoContentWithResponseAsync(String groupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/octet-stream, application/json";
        context = this.client.mergeContext(context);
        return this.service.getPhotoContent(this.client.getEndpoint(), groupId, "application/octet-stream, application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> getPhotoContentAsync(String groupId) {
        return this.getPhotoContentWithResponseAsync(groupId).flatMapMany(StreamResponse::getValue);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public InputStream getPhotoContent(String groupId) {
        final Iterator iterator = this.getPhotoContentAsync(groupId).map(ByteBufferBackedInputStream::new).toStream().iterator();
        Enumeration<InputStream> enumeration = new Enumeration<InputStream>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public InputStream nextElement() {
                return (InputStream)iterator.next();
            }
        };
        return new SequenceInputStream((Enumeration<? extends InputStream>)enumeration);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public StreamResponse getPhotoContentWithResponse(String groupId, Context context) {
        return (StreamResponse)this.getPhotoContentWithResponseAsync(groupId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setPhotoContentWithResponseAsync(String groupId, Flux<ByteBuffer> data, long contentLength) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (data == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter data is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.setPhotoContent(this.client.getEndpoint(), groupId, data, contentLength, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> setPhotoContentWithResponseAsync(String groupId, Flux<ByteBuffer> data, long contentLength, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (data == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter data is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.setPhotoContent(this.client.getEndpoint(), groupId, data, contentLength, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setPhotoContentAsync(String groupId, Flux<ByteBuffer> data, long contentLength) {
        return this.setPhotoContentWithResponseAsync(groupId, data, contentLength).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setPhotoContent(String groupId, Flux<ByteBuffer> data, long contentLength) {
        this.setPhotoContentAsync(groupId, data, contentLength).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setPhotoContentWithResponse(String groupId, Flux<ByteBuffer> data, long contentLength, Context context) {
        return (Response)this.setPhotoContentWithResponseAsync(groupId, data, contentLength, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphProfilePhotoInner>> listPhotosSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listPhotos(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfProfilePhoto)res.getValue()).value(), ((CollectionOfProfilePhoto)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphProfilePhotoInner>> listPhotosSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listPhotos(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfProfilePhoto)res.getValue()).value(), ((CollectionOfProfilePhoto)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphProfilePhotoInner> listPhotosAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listPhotosSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listPhotosNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphProfilePhotoInner> listPhotosAsync(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listPhotosSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listPhotosNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphProfilePhotoInner> listPhotosAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listPhotosSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listPhotosNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphProfilePhotoInner> listPhotos(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<GroupsOrderby> orderby = null;
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listPhotosAsync(groupId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphProfilePhotoInner> listPhotos(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listPhotosAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphProfilePhotoInner>> createPhotosWithResponseAsync(String groupId, MicrosoftGraphProfilePhotoInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createPhotos(this.client.getEndpoint(), groupId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphProfilePhotoInner>> createPhotosWithResponseAsync(String groupId, MicrosoftGraphProfilePhotoInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createPhotos(this.client.getEndpoint(), groupId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphProfilePhotoInner> createPhotosAsync(String groupId, MicrosoftGraphProfilePhotoInner body) {
        return this.createPhotosWithResponseAsync(groupId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphProfilePhotoInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphProfilePhotoInner createPhotos(String groupId, MicrosoftGraphProfilePhotoInner body) {
        return (MicrosoftGraphProfilePhotoInner)this.createPhotosAsync(groupId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphProfilePhotoInner> createPhotosWithResponse(String groupId, MicrosoftGraphProfilePhotoInner body, Context context) {
        return (Response)this.createPhotosWithResponseAsync(groupId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphProfilePhotoInner>> getPhotosWithResponseAsync(String groupId, String profilePhotoId, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getPhotos(this.client.getEndpoint(), groupId, profilePhotoId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphProfilePhotoInner>> getPhotosWithResponseAsync(String groupId, String profilePhotoId, List<GroupsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getPhotos(this.client.getEndpoint(), groupId, profilePhotoId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphProfilePhotoInner> getPhotosAsync(String groupId, String profilePhotoId, List<GroupsSelect> select, List<String> expand) {
        return this.getPhotosWithResponseAsync(groupId, profilePhotoId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphProfilePhotoInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphProfilePhotoInner> getPhotosAsync(String groupId, String profilePhotoId) {
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return this.getPhotosWithResponseAsync(groupId, profilePhotoId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphProfilePhotoInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphProfilePhotoInner getPhotos(String groupId, String profilePhotoId) {
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphProfilePhotoInner)this.getPhotosAsync(groupId, profilePhotoId, select, expand).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphProfilePhotoInner> getPhotosWithResponse(String groupId, String profilePhotoId, List<GroupsSelect> select, List<String> expand, Context context) {
        return (Response)this.getPhotosWithResponseAsync(groupId, profilePhotoId, select, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updatePhotosWithResponseAsync(String groupId, String profilePhotoId, MicrosoftGraphProfilePhotoInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updatePhotos(this.client.getEndpoint(), groupId, profilePhotoId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updatePhotosWithResponseAsync(String groupId, String profilePhotoId, MicrosoftGraphProfilePhotoInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updatePhotos(this.client.getEndpoint(), groupId, profilePhotoId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updatePhotosAsync(String groupId, String profilePhotoId, MicrosoftGraphProfilePhotoInner body) {
        return this.updatePhotosWithResponseAsync(groupId, profilePhotoId, body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updatePhotos(String groupId, String profilePhotoId, MicrosoftGraphProfilePhotoInner body) {
        this.updatePhotosAsync(groupId, profilePhotoId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updatePhotosWithResponse(String groupId, String profilePhotoId, MicrosoftGraphProfilePhotoInner body, Context context) {
        return (Response)this.updatePhotosWithResponseAsync(groupId, profilePhotoId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deletePhotosWithResponseAsync(String groupId, String profilePhotoId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deletePhotos(this.client.getEndpoint(), groupId, profilePhotoId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deletePhotosWithResponseAsync(String groupId, String profilePhotoId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deletePhotos(this.client.getEndpoint(), groupId, profilePhotoId, ifMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deletePhotosAsync(String groupId, String profilePhotoId, String ifMatch) {
        return this.deletePhotosWithResponseAsync(groupId, profilePhotoId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deletePhotosAsync(String groupId, String profilePhotoId) {
        String ifMatch = null;
        return this.deletePhotosWithResponseAsync(groupId, profilePhotoId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deletePhotos(String groupId, String profilePhotoId) {
        String ifMatch = null;
        this.deletePhotosAsync(groupId, profilePhotoId, ifMatch).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deletePhotosWithResponse(String groupId, String profilePhotoId, String ifMatch, Context context) {
        return (Response)this.deletePhotosWithResponseAsync(groupId, profilePhotoId, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> getPhotosContentWithResponseAsync(String groupId, String profilePhotoId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        String accept = "application/octet-stream, application/json";
        return FluxUtil.withContext(context -> this.service.getPhotosContent(this.client.getEndpoint(), groupId, profilePhotoId, "application/octet-stream, application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<StreamResponse> getPhotosContentWithResponseAsync(String groupId, String profilePhotoId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        String accept = "application/octet-stream, application/json";
        context = this.client.mergeContext(context);
        return this.service.getPhotosContent(this.client.getEndpoint(), groupId, profilePhotoId, "application/octet-stream, application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> getPhotosContentAsync(String groupId, String profilePhotoId) {
        return this.getPhotosContentWithResponseAsync(groupId, profilePhotoId).flatMapMany(StreamResponse::getValue);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public InputStream getPhotosContent(String groupId, String profilePhotoId) {
        final Iterator iterator = this.getPhotosContentAsync(groupId, profilePhotoId).map(ByteBufferBackedInputStream::new).toStream().iterator();
        Enumeration<InputStream> enumeration = new Enumeration<InputStream>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public InputStream nextElement() {
                return (InputStream)iterator.next();
            }
        };
        return new SequenceInputStream((Enumeration<? extends InputStream>)enumeration);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public StreamResponse getPhotosContentWithResponse(String groupId, String profilePhotoId, Context context) {
        return (StreamResponse)this.getPhotosContentWithResponseAsync(groupId, profilePhotoId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setPhotosContentWithResponseAsync(String groupId, String profilePhotoId, Flux<ByteBuffer> data, long contentLength) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        if (data == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter data is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.setPhotosContent(this.client.getEndpoint(), groupId, profilePhotoId, data, contentLength, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> setPhotosContentWithResponseAsync(String groupId, String profilePhotoId, Flux<ByteBuffer> data, long contentLength, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        if (data == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter data is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.setPhotosContent(this.client.getEndpoint(), groupId, profilePhotoId, data, contentLength, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setPhotosContentAsync(String groupId, String profilePhotoId, Flux<ByteBuffer> data, long contentLength) {
        return this.setPhotosContentWithResponseAsync(groupId, profilePhotoId, data, contentLength).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setPhotosContent(String groupId, String profilePhotoId, Flux<ByteBuffer> data, long contentLength) {
        this.setPhotosContentAsync(groupId, profilePhotoId, data, contentLength).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setPhotosContentWithResponse(String groupId, String profilePhotoId, Flux<ByteBuffer> data, long contentLength, Context context) {
        return (Response)this.setPhotosContentWithResponseAsync(groupId, profilePhotoId, data, contentLength, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listRejectedSendersSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRejectedSenders(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject4)res.getValue()).value(), ((CollectionOfDirectoryObject4)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listRejectedSendersSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRejectedSenders(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject4)res.getValue()).value(), ((CollectionOfDirectoryObject4)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listRejectedSendersAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listRejectedSendersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listRejectedSendersNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listRejectedSendersAsync(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listRejectedSendersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listRejectedSendersNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listRejectedSendersAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listRejectedSendersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listRejectedSendersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listRejectedSenders(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<GroupsOrderby> orderby = null;
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listRejectedSendersAsync(groupId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listRejectedSenders(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listRejectedSendersAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> createRejectedSendersWithResponseAsync(String groupId, MicrosoftGraphDirectoryObjectInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRejectedSenders(this.client.getEndpoint(), groupId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> createRejectedSendersWithResponseAsync(String groupId, MicrosoftGraphDirectoryObjectInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRejectedSenders(this.client.getEndpoint(), groupId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> createRejectedSendersAsync(String groupId, MicrosoftGraphDirectoryObjectInner body) {
        return this.createRejectedSendersWithResponseAsync(groupId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryObjectInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphDirectoryObjectInner createRejectedSenders(String groupId, MicrosoftGraphDirectoryObjectInner body) {
        return (MicrosoftGraphDirectoryObjectInner)this.createRejectedSendersAsync(groupId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryObjectInner> createRejectedSendersWithResponse(String groupId, MicrosoftGraphDirectoryObjectInner body, Context context) {
        return (Response)this.createRejectedSendersWithResponseAsync(groupId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> getRejectedSendersWithResponseAsync(String groupId, String directoryObjectId, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getRejectedSenders(this.client.getEndpoint(), groupId, directoryObjectId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> getRejectedSendersWithResponseAsync(String groupId, String directoryObjectId, List<GroupsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getRejectedSenders(this.client.getEndpoint(), groupId, directoryObjectId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> getRejectedSendersAsync(String groupId, String directoryObjectId, List<GroupsSelect> select, List<String> expand) {
        return this.getRejectedSendersWithResponseAsync(groupId, directoryObjectId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryObjectInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> getRejectedSendersAsync(String groupId, String directoryObjectId) {
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return this.getRejectedSendersWithResponseAsync(groupId, directoryObjectId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryObjectInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphDirectoryObjectInner getRejectedSenders(String groupId, String directoryObjectId) {
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphDirectoryObjectInner)this.getRejectedSendersAsync(groupId, directoryObjectId, select, expand).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryObjectInner> getRejectedSendersWithResponse(String groupId, String directoryObjectId, List<GroupsSelect> select, List<String> expand, Context context) {
        return (Response)this.getRejectedSendersWithResponseAsync(groupId, directoryObjectId, select, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateRejectedSendersWithResponseAsync(String groupId, String directoryObjectId, MicrosoftGraphDirectoryObjectInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateRejectedSenders(this.client.getEndpoint(), groupId, directoryObjectId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateRejectedSendersWithResponseAsync(String groupId, String directoryObjectId, MicrosoftGraphDirectoryObjectInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateRejectedSenders(this.client.getEndpoint(), groupId, directoryObjectId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateRejectedSendersAsync(String groupId, String directoryObjectId, MicrosoftGraphDirectoryObjectInner body) {
        return this.updateRejectedSendersWithResponseAsync(groupId, directoryObjectId, body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateRejectedSenders(String groupId, String directoryObjectId, MicrosoftGraphDirectoryObjectInner body) {
        this.updateRejectedSendersAsync(groupId, directoryObjectId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateRejectedSendersWithResponse(String groupId, String directoryObjectId, MicrosoftGraphDirectoryObjectInner body, Context context) {
        return (Response)this.updateRejectedSendersWithResponseAsync(groupId, directoryObjectId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteRejectedSendersWithResponseAsync(String groupId, String directoryObjectId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteRejectedSenders(this.client.getEndpoint(), groupId, directoryObjectId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteRejectedSendersWithResponseAsync(String groupId, String directoryObjectId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteRejectedSenders(this.client.getEndpoint(), groupId, directoryObjectId, ifMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteRejectedSendersAsync(String groupId, String directoryObjectId, String ifMatch) {
        return this.deleteRejectedSendersWithResponseAsync(groupId, directoryObjectId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteRejectedSendersAsync(String groupId, String directoryObjectId) {
        String ifMatch = null;
        return this.deleteRejectedSendersWithResponseAsync(groupId, directoryObjectId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteRejectedSenders(String groupId, String directoryObjectId) {
        String ifMatch = null;
        this.deleteRejectedSendersAsync(groupId, directoryObjectId, ifMatch).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteRejectedSendersWithResponse(String groupId, String directoryObjectId, String ifMatch, Context context) {
        return (Response)this.deleteRejectedSendersWithResponseAsync(groupId, directoryObjectId, ifMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listTransitiveMemberOf(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject5)res.getValue()).value(), ((CollectionOfDirectoryObject5)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listTransitiveMemberOf(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject5)res.getValue()).value(), ((CollectionOfDirectoryObject5)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOfAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listTransitiveMemberOfSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listTransitiveMemberOfNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOfAsync(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listTransitiveMemberOfSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listTransitiveMemberOfNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOfAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listTransitiveMemberOfSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listTransitiveMemberOfNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOf(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<GroupsOrderby> orderby = null;
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listTransitiveMemberOfAsync(groupId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOf(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listTransitiveMemberOfAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMemberOfSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefTransitiveMemberOf(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject3)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject3)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMemberOfSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefTransitiveMemberOf(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject3)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject3)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefTransitiveMemberOfAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby) {
        return new PagedFlux(() -> this.listRefTransitiveMemberOfSinglePageAsync(groupId, top, skip, search, filter, count, orderby), nextLink -> this.listRefTransitiveMemberOfNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefTransitiveMemberOfAsync(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefTransitiveMemberOfSinglePageAsync(groupId, top, skip, search, filter, count, orderby), nextLink -> this.listRefTransitiveMemberOfNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<String> listRefTransitiveMemberOfAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefTransitiveMemberOfSinglePageAsync(groupId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefTransitiveMemberOfNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefTransitiveMemberOf(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<GroupsOrderby> orderby = null;
        return new PagedIterable(this.listRefTransitiveMemberOfAsync(groupId, top, skip, search, filter, count, orderby));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefTransitiveMemberOf(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefTransitiveMemberOfAsync(groupId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefTransitiveMemberOfWithResponseAsync(String groupId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefTransitiveMemberOf(this.client.getEndpoint(), groupId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefTransitiveMemberOfWithResponseAsync(String groupId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefTransitiveMemberOf(this.client.getEndpoint(), groupId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefTransitiveMemberOfAsync(String groupId, Map<String, Object> body) {
        return this.createRefTransitiveMemberOfWithResponseAsync(groupId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, Object> createRefTransitiveMemberOf(String groupId, Map<String, Object> body) {
        return (Map)this.createRefTransitiveMemberOfAsync(groupId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefTransitiveMemberOfWithResponse(String groupId, Map<String, Object> body, Context context) {
        return (Response)this.createRefTransitiveMemberOfWithResponseAsync(groupId, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMembersSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listTransitiveMembers(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject6)res.getValue()).value(), ((CollectionOfDirectoryObject6)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMembersSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listTransitiveMembers(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject6)res.getValue()).value(), ((CollectionOfDirectoryObject6)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMembersAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listTransitiveMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listTransitiveMembersNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMembersAsync(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listTransitiveMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listTransitiveMembersNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMembersAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listTransitiveMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listTransitiveMembersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listTransitiveMembers(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<GroupsOrderby> orderby = null;
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listTransitiveMembersAsync(groupId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listTransitiveMembers(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listTransitiveMembersAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMembersSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefTransitiveMembers(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject4)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject4)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMembersSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefTransitiveMembers(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject4)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject4)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefTransitiveMembersAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby) {
        return new PagedFlux(() -> this.listRefTransitiveMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby), nextLink -> this.listRefTransitiveMembersNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefTransitiveMembersAsync(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefTransitiveMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby), nextLink -> this.listRefTransitiveMembersNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<String> listRefTransitiveMembersAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefTransitiveMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefTransitiveMembersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefTransitiveMembers(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<GroupsOrderby> orderby = null;
        return new PagedIterable(this.listRefTransitiveMembersAsync(groupId, top, skip, search, filter, count, orderby));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefTransitiveMembers(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefTransitiveMembersAsync(groupId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefTransitiveMembersWithResponseAsync(String groupId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefTransitiveMembers(this.client.getEndpoint(), groupId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefTransitiveMembersWithResponseAsync(String groupId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefTransitiveMembers(this.client.getEndpoint(), groupId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefTransitiveMembersAsync(String groupId, Map<String, Object> body) {
        return this.createRefTransitiveMembersWithResponseAsync(groupId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, Object> createRefTransitiveMembers(String groupId, Map<String, Object> body) {
        return (Map)this.createRefTransitiveMembersAsync(groupId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefTransitiveMembersWithResponse(String groupId, Map<String, Object> body, Context context) {
        return (Response)this.createRefTransitiveMembersWithResponseAsync(groupId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<MicrosoftGraphGroupInner>>> deltaWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delta(this.client.getEndpoint(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<MicrosoftGraphGroupInner>>> deltaWithResponseAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delta(this.client.getEndpoint(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<MicrosoftGraphGroupInner>> deltaAsync() {
        return this.deltaWithResponseAsync().flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<MicrosoftGraphGroupInner> delta() {
        return (List)this.deltaAsync().block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<MicrosoftGraphGroupInner>> deltaWithResponse(Context context) {
        return (Response)this.deltaWithResponseAsync(context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionPropertiesWithResponseAsync(GroupsGetAvailableExtensionPropertiesRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAvailableExtensionProperties(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionPropertiesWithResponseAsync(GroupsGetAvailableExtensionPropertiesRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAvailableExtensionProperties(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<MicrosoftGraphExtensionPropertyInner>> getAvailableExtensionPropertiesAsync(GroupsGetAvailableExtensionPropertiesRequestBody body) {
        return this.getAvailableExtensionPropertiesWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<MicrosoftGraphExtensionPropertyInner> getAvailableExtensionProperties(GroupsGetAvailableExtensionPropertiesRequestBody body) {
        return (List)this.getAvailableExtensionPropertiesAsync(body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<MicrosoftGraphExtensionPropertyInner>> getAvailableExtensionPropertiesWithResponse(GroupsGetAvailableExtensionPropertiesRequestBody body, Context context) {
        return (Response)this.getAvailableExtensionPropertiesWithResponseAsync(body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIdsWithResponseAsync(GroupsGetByIdsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByIds(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIdsWithResponseAsync(GroupsGetByIdsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByIds(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<MicrosoftGraphDirectoryObjectInner>> getByIdsAsync(GroupsGetByIdsRequestBody body) {
        return this.getByIdsWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<MicrosoftGraphDirectoryObjectInner> getByIds(GroupsGetByIdsRequestBody body) {
        return (List)this.getByIdsAsync(body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<MicrosoftGraphDirectoryObjectInner>> getByIdsWithResponse(GroupsGetByIdsRequestBody body, Context context) {
        return (Response)this.getByIdsWithResponseAsync(body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> validatePropertiesWithResponseAsync(GroupsValidatePropertiesRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateProperties(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> validatePropertiesWithResponseAsync(GroupsValidatePropertiesRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validateProperties(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> validatePropertiesAsync(GroupsValidatePropertiesRequestBody body) {
        return this.validatePropertiesWithResponseAsync(body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void validateProperties(GroupsValidatePropertiesRequestBody body) {
        this.validatePropertiesAsync(body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> validatePropertiesWithResponse(GroupsValidatePropertiesRequestBody body, Context context) {
        return (Response)this.validatePropertiesWithResponseAsync(body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphAppRoleAssignmentInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfAppRoleAssignment)res.getValue()).value(), ((CollectionOfAppRoleAssignment)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphAppRoleAssignmentInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfAppRoleAssignment)res.getValue()).value(), ((CollectionOfAppRoleAssignment)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listAcceptedSendersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listAcceptedSendersNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject)res.getValue()).value(), ((CollectionOfDirectoryObject)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listAcceptedSendersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listAcceptedSendersNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject)res.getValue()).value(), ((CollectionOfDirectoryObject)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listExtensionsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listExtensionsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtension)res.getValue()).value(), ((CollectionOfExtension)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listExtensionsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listExtensionsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtension)res.getValue()).value(), ((CollectionOfExtension)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMemberOfNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject0)res.getValue()).value(), ((CollectionOfDirectoryObject0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMemberOfNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject0)res.getValue()).value(), ((CollectionOfDirectoryObject0)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefMemberOfNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMemberOfNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefMemberOfNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMembersNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject1)res.getValue()).value(), ((CollectionOfDirectoryObject1)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMembersNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject1)res.getValue()).value(), ((CollectionOfDirectoryObject1)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefMembersNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject0)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefMembersNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject0)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject0)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersWithLicenseErrorsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMembersWithLicenseErrorsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject2)res.getValue()).value(), ((CollectionOfDirectoryObject2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersWithLicenseErrorsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMembersWithLicenseErrorsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject2)res.getValue()).value(), ((CollectionOfDirectoryObject2)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersWithLicenseErrorsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefMembersWithLicenseErrorsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject1)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject1)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersWithLicenseErrorsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefMembersWithLicenseErrorsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject1)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject1)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listOwnersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listOwnersNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject3)res.getValue()).value(), ((CollectionOfDirectoryObject3)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listOwnersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listOwnersNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject3)res.getValue()).value(), ((CollectionOfDirectoryObject3)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefOwnersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefOwnersNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefOwnersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefOwnersNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject2)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphResourceSpecificPermissionGrantInner>> listPermissionGrantsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listPermissionGrantsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfResourceSpecificPermissionGrant)res.getValue()).value(), ((CollectionOfResourceSpecificPermissionGrant)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphResourceSpecificPermissionGrantInner>> listPermissionGrantsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listPermissionGrantsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfResourceSpecificPermissionGrant)res.getValue()).value(), ((CollectionOfResourceSpecificPermissionGrant)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphProfilePhotoInner>> listPhotosNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listPhotosNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfProfilePhoto)res.getValue()).value(), ((CollectionOfProfilePhoto)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphProfilePhotoInner>> listPhotosNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listPhotosNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfProfilePhoto)res.getValue()).value(), ((CollectionOfProfilePhoto)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listRejectedSendersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRejectedSendersNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject4)res.getValue()).value(), ((CollectionOfDirectoryObject4)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listRejectedSendersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRejectedSendersNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject4)res.getValue()).value(), ((CollectionOfDirectoryObject4)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listTransitiveMemberOfNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject5)res.getValue()).value(), ((CollectionOfDirectoryObject5)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listTransitiveMemberOfNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject5)res.getValue()).value(), ((CollectionOfDirectoryObject5)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefTransitiveMemberOfNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject3)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject3)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMemberOfNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefTransitiveMemberOfNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject3)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject3)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMembersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listTransitiveMembersNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject6)res.getValue()).value(), ((CollectionOfDirectoryObject6)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMembersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listTransitiveMembersNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject6)res.getValue()).value(), ((CollectionOfDirectoryObject6)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMembersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefTransitiveMembersNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject4)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject4)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMembersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefTransitiveMembersNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject4)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject4)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    private static interface GroupsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/appRoleAssignments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfAppRoleAssignment>> listAppRoleAssignments(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/appRoleAssignments")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> createAppRoleAssignments(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @BodyParam(value="application/json") MicrosoftGraphAppRoleAssignmentInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/appRoleAssignments/{appRoleAssignment-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> getAppRoleAssignments(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @PathParam(value="appRoleAssignment-id") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/groups/{group-id}/appRoleAssignments/{appRoleAssignment-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateAppRoleAssignments(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @PathParam(value="appRoleAssignment-id") String var3, @BodyParam(value="application/json") MicrosoftGraphAppRoleAssignmentInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/groups/{group-id}/appRoleAssignments/{appRoleAssignment-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteAppRoleAssignments(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @PathParam(value="appRoleAssignment-id") String var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/acceptedSenders")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject>> listAcceptedSenders(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/acceptedSenders")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDirectoryObjectInner>> createAcceptedSenders(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @BodyParam(value="application/json") MicrosoftGraphDirectoryObjectInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/acceptedSenders/{directoryObject-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDirectoryObjectInner>> getAcceptedSenders(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @PathParam(value="directoryObject-id") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/groups/{group-id}/acceptedSenders/{directoryObject-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateAcceptedSenders(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @PathParam(value="directoryObject-id") String var3, @BodyParam(value="application/json") MicrosoftGraphDirectoryObjectInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/groups/{group-id}/acceptedSenders/{directoryObject-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteAcceptedSenders(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @PathParam(value="directoryObject-id") String var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/createdOnBehalfOf")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDirectoryObjectInner>> getCreatedOnBehalfOf(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @QueryParam(value="$select") String var3, @QueryParam(value="$expand") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/createdOnBehalfOf/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<String>> getRefCreatedOnBehalfOf(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/groups/{group-id}/createdOnBehalfOf/$ref")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> setRefCreatedOnBehalfOf(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/groups/{group-id}/createdOnBehalfOf/$ref")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteRefCreatedOnBehalfOf(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @HeaderParam(value="If-Match") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/extensions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfExtension>> listExtensions(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/extensions")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphExtensionInner>> createExtensions(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @BodyParam(value="application/json") MicrosoftGraphExtensionInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/extensions/{extension-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphExtensionInner>> getExtensions(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @PathParam(value="extension-id") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/groups/{group-id}/extensions/{extension-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateExtensions(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @PathParam(value="extension-id") String var3, @BodyParam(value="application/json") MicrosoftGraphExtensionInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/groups/{group-id}/extensions/{extension-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteExtensions(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @PathParam(value="extension-id") String var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/memberOf")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject0>> listMemberOf(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/memberOf/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject>> listRefMemberOf(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/memberOf/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefMemberOf(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/members")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject1>> listMembers(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/members/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject0>> listRefMembers(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/members/$ref")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> createRefMembers(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/groups/{group-id}/members/{directoryObject-id}/$ref")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteRefMember(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @PathParam(value="directoryObject-id") String var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/membersWithLicenseErrors")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject2>> listMembersWithLicenseErrors(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/membersWithLicenseErrors/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject1>> listRefMembersWithLicenseErrors(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/membersWithLicenseErrors/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefMembersWithLicenseErrors(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/microsoft.graph.addFavorite")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> addFavorite(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/microsoft.graph.assignLicense")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphGroupInner>> assignLicense(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @BodyParam(value="application/json") GroupsAssignLicenseRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/microsoft.graph.checkGrantedPermissionsForApp")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<MicrosoftGraphResourceSpecificPermissionGrantInner>>> checkGrantedPermissionsForApp(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/microsoft.graph.checkMemberGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> checkMemberGroups(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @BodyParam(value="application/json") GroupsCheckMemberGroupsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/microsoft.graph.checkMemberObjects")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> checkMemberObjects(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @BodyParam(value="application/json") GroupsCheckMemberObjectsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/microsoft.graph.getMemberGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> getMemberGroups(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @BodyParam(value="application/json") GroupsGetMemberGroupsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/microsoft.graph.getMemberObjects")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> getMemberObjects(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @BodyParam(value="application/json") GroupsGetMemberObjectsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/microsoft.graph.removeFavorite")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> removeFavorite(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/microsoft.graph.renew")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> renew(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/microsoft.graph.resetUnseenCount")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> resetUnseenCount(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/microsoft.graph.restore")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDirectoryObjectInner>> restore(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/microsoft.graph.subscribeByMail")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> subscribeByMail(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/microsoft.graph.unsubscribeByMail")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> unsubscribeByMail(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/microsoft.graph.validateProperties")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> validateProperties(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @BodyParam(value="application/json") GroupsValidatePropertiesRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/owners")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject3>> listOwners(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/owners/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject2>> listRefOwners(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/owners/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefOwners(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/permissionGrants")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfResourceSpecificPermissionGrant>> listPermissionGrants(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/permissionGrants")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphResourceSpecificPermissionGrantInner>> createPermissionGrants(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @BodyParam(value="application/json") MicrosoftGraphResourceSpecificPermissionGrantInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/permissionGrants/{resourceSpecificPermissionGrant-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphResourceSpecificPermissionGrantInner>> getPermissionGrants(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @PathParam(value="resourceSpecificPermissionGrant-id") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/groups/{group-id}/permissionGrants/{resourceSpecificPermissionGrant-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updatePermissionGrants(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @PathParam(value="resourceSpecificPermissionGrant-id") String var3, @BodyParam(value="application/json") MicrosoftGraphResourceSpecificPermissionGrantInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/groups/{group-id}/permissionGrants/{resourceSpecificPermissionGrant-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deletePermissionGrants(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @PathParam(value="resourceSpecificPermissionGrant-id") String var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/photo")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphProfilePhotoInner>> getPhoto(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @QueryParam(value="$select") String var3, @QueryParam(value="$expand") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/groups/{group-id}/photo")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updatePhoto(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @BodyParam(value="application/json") MicrosoftGraphProfilePhotoInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/groups/{group-id}/photo")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deletePhoto(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @HeaderParam(value="If-Match") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/photo/$value")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<StreamResponse> getPhotoContent(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/octet-stream"})
        @Put(value="/groups/{group-id}/photo/$value")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> setPhotoContent(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var3, @HeaderParam(value="Content-Length") long var4, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/photos")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfProfilePhoto>> listPhotos(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/photos")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphProfilePhotoInner>> createPhotos(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @BodyParam(value="application/json") MicrosoftGraphProfilePhotoInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/photos/{profilePhoto-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphProfilePhotoInner>> getPhotos(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @PathParam(value="profilePhoto-id") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/groups/{group-id}/photos/{profilePhoto-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updatePhotos(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @PathParam(value="profilePhoto-id") String var3, @BodyParam(value="application/json") MicrosoftGraphProfilePhotoInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/groups/{group-id}/photos/{profilePhoto-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deletePhotos(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @PathParam(value="profilePhoto-id") String var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/photos/{profilePhoto-id}/$value")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<StreamResponse> getPhotosContent(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @PathParam(value="profilePhoto-id") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/octet-stream"})
        @Put(value="/groups/{group-id}/photos/{profilePhoto-id}/$value")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> setPhotosContent(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @PathParam(value="profilePhoto-id") String var3, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var4, @HeaderParam(value="Content-Length") long var5, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/rejectedSenders")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject4>> listRejectedSenders(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/rejectedSenders")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDirectoryObjectInner>> createRejectedSenders(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @BodyParam(value="application/json") MicrosoftGraphDirectoryObjectInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/rejectedSenders/{directoryObject-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDirectoryObjectInner>> getRejectedSenders(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @PathParam(value="directoryObject-id") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/groups/{group-id}/rejectedSenders/{directoryObject-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateRejectedSenders(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @PathParam(value="directoryObject-id") String var3, @BodyParam(value="application/json") MicrosoftGraphDirectoryObjectInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/groups/{group-id}/rejectedSenders/{directoryObject-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteRejectedSenders(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @PathParam(value="directoryObject-id") String var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/transitiveMemberOf")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject5>> listTransitiveMemberOf(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/transitiveMemberOf/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject3>> listRefTransitiveMemberOf(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/transitiveMemberOf/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefTransitiveMemberOf(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/transitiveMembers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject6>> listTransitiveMembers(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/transitiveMembers/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject4>> listRefTransitiveMembers(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/transitiveMembers/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefTransitiveMembers(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/microsoft.graph.delta()")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<MicrosoftGraphGroupInner>>> delta(@HostParam(value="$host") String var1, @HeaderParam(value="Accept") String var2, Context var3);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/microsoft.graph.getAvailableExtensionProperties")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionProperties(@HostParam(value="$host") String var1, @BodyParam(value="application/json") GroupsGetAvailableExtensionPropertiesRequestBody var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/microsoft.graph.getByIds")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIds(@HostParam(value="$host") String var1, @BodyParam(value="application/json") GroupsGetByIdsRequestBody var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/microsoft.graph.validateProperties")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> validateProperties(@HostParam(value="$host") String var1, @BodyParam(value="application/json") GroupsValidatePropertiesRequestBody var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfAppRoleAssignment>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject>> listAcceptedSendersNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfExtension>> listExtensionsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject0>> listMemberOfNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject>> listRefMemberOfNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject1>> listMembersNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject0>> listRefMembersNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject2>> listMembersWithLicenseErrorsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject1>> listRefMembersWithLicenseErrorsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject3>> listOwnersNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject2>> listRefOwnersNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfResourceSpecificPermissionGrant>> listPermissionGrantsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfProfilePhoto>> listPhotosNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject4>> listRejectedSendersNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject5>> listTransitiveMemberOfNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject3>> listRefTransitiveMemberOfNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject6>> listTransitiveMembersNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject4>> listRefTransitiveMembersNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

