/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.DevicesClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject2AutoGenerated2;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject3AutoGenerated2;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject4AutoGenerated2;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject5AutoGenerated;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfExtensionAutoGenerated;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject2AutoGenerated2;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject3AutoGenerated2;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject4AutoGenerated2;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject5;
import com.azure.resourcemanager.authorization.fluent.models.DevicesCheckMemberGroupsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DevicesCheckMemberObjectsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DevicesGetAvailableExtensionPropertiesRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DevicesGetByIdsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DevicesGetMemberGroupsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DevicesGetMemberObjectsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DevicesOrderby;
import com.azure.resourcemanager.authorization.fluent.models.DevicesSelect;
import com.azure.resourcemanager.authorization.fluent.models.DevicesValidatePropertiesRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtensionInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtensionPropertyInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class DevicesClientImpl
implements DevicesClient {
    private final ClientLogger logger = new ClientLogger(DevicesClientImpl.class);
    private final DevicesService service;
    private final MicrosoftGraphClientImpl client;

    DevicesClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (DevicesService)RestProxy.create(DevicesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listExtensionsSinglePageAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, List<String> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listExtensions(this.client.getEndpoint(), deviceId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtensionAutoGenerated)res.getValue()).value(), ((CollectionOfExtensionAutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listExtensionsSinglePageAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, List<String> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listExtensions(this.client.getEndpoint(), deviceId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtensionAutoGenerated)res.getValue()).value(), ((CollectionOfExtensionAutoGenerated)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, List<String> select, List<String> expand) {
        return new PagedFlux(() -> this.listExtensionsSinglePageAsync(deviceId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(String deviceId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listExtensionsSinglePageAsync(deviceId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, List<String> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listExtensionsSinglePageAsync(deviceId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphExtensionInner> listExtensions(String deviceId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<DevicesOrderby> orderby = null;
        List<String> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listExtensionsAsync(deviceId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphExtensionInner> listExtensions(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, List<String> select, List<String> expand, Context context) {
        return new PagedIterable(this.listExtensionsAsync(deviceId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphExtensionInner>> createExtensionsWithResponseAsync(String deviceId, MicrosoftGraphExtensionInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createExtensions(this.client.getEndpoint(), deviceId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphExtensionInner>> createExtensionsWithResponseAsync(String deviceId, MicrosoftGraphExtensionInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createExtensions(this.client.getEndpoint(), deviceId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphExtensionInner> createExtensionsAsync(String deviceId, MicrosoftGraphExtensionInner body) {
        return this.createExtensionsWithResponseAsync(deviceId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphExtensionInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphExtensionInner createExtensions(String deviceId, MicrosoftGraphExtensionInner body) {
        return (MicrosoftGraphExtensionInner)this.createExtensionsAsync(deviceId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphExtensionInner> createExtensionsWithResponse(String deviceId, MicrosoftGraphExtensionInner body, Context context) {
        return (Response)this.createExtensionsWithResponseAsync(deviceId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphExtensionInner>> getExtensionsWithResponseAsync(String deviceId, String extensionId, List<String> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getExtensions(this.client.getEndpoint(), deviceId, extensionId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphExtensionInner>> getExtensionsWithResponseAsync(String deviceId, String extensionId, List<String> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getExtensions(this.client.getEndpoint(), deviceId, extensionId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphExtensionInner> getExtensionsAsync(String deviceId, String extensionId, List<String> select, List<String> expand) {
        return this.getExtensionsWithResponseAsync(deviceId, extensionId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphExtensionInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphExtensionInner> getExtensionsAsync(String deviceId, String extensionId) {
        List<String> select = null;
        List<String> expand = null;
        return this.getExtensionsWithResponseAsync(deviceId, extensionId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphExtensionInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphExtensionInner getExtensions(String deviceId, String extensionId) {
        List<String> select = null;
        List<String> expand = null;
        return (MicrosoftGraphExtensionInner)this.getExtensionsAsync(deviceId, extensionId, select, expand).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphExtensionInner> getExtensionsWithResponse(String deviceId, String extensionId, List<String> select, List<String> expand, Context context) {
        return (Response)this.getExtensionsWithResponseAsync(deviceId, extensionId, select, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateExtensionsWithResponseAsync(String deviceId, String extensionId, MicrosoftGraphExtensionInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateExtensions(this.client.getEndpoint(), deviceId, extensionId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateExtensionsWithResponseAsync(String deviceId, String extensionId, MicrosoftGraphExtensionInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateExtensions(this.client.getEndpoint(), deviceId, extensionId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateExtensionsAsync(String deviceId, String extensionId, MicrosoftGraphExtensionInner body) {
        return this.updateExtensionsWithResponseAsync(deviceId, extensionId, body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateExtensions(String deviceId, String extensionId, MicrosoftGraphExtensionInner body) {
        this.updateExtensionsAsync(deviceId, extensionId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateExtensionsWithResponse(String deviceId, String extensionId, MicrosoftGraphExtensionInner body, Context context) {
        return (Response)this.updateExtensionsWithResponseAsync(deviceId, extensionId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteExtensionsWithResponseAsync(String deviceId, String extensionId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteExtensions(this.client.getEndpoint(), deviceId, extensionId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteExtensionsWithResponseAsync(String deviceId, String extensionId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteExtensions(this.client.getEndpoint(), deviceId, extensionId, ifMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteExtensionsAsync(String deviceId, String extensionId, String ifMatch) {
        return this.deleteExtensionsWithResponseAsync(deviceId, extensionId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteExtensionsAsync(String deviceId, String extensionId) {
        String ifMatch = null;
        return this.deleteExtensionsWithResponseAsync(deviceId, extensionId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteExtensions(String deviceId, String extensionId) {
        String ifMatch = null;
        this.deleteExtensionsAsync(deviceId, extensionId, ifMatch).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteExtensionsWithResponse(String deviceId, String extensionId, String ifMatch, Context context) {
        return (Response)this.deleteExtensionsWithResponseAsync(deviceId, extensionId, ifMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfSinglePageAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, List<DevicesSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listMemberOf(this.client.getEndpoint(), deviceId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject2AutoGenerated2)res.getValue()).value(), ((CollectionOfDirectoryObject2AutoGenerated2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfSinglePageAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, List<DevicesSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listMemberOf(this.client.getEndpoint(), deviceId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject2AutoGenerated2)res.getValue()).value(), ((CollectionOfDirectoryObject2AutoGenerated2)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMemberOfAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, List<DevicesSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listMemberOfSinglePageAsync(deviceId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMemberOfNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMemberOfAsync(String deviceId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listMemberOfSinglePageAsync(deviceId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMemberOfNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listMemberOfAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, List<DevicesSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listMemberOfSinglePageAsync(deviceId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMemberOfNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMemberOf(String deviceId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<DevicesOrderby> orderby = null;
        List<DevicesSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listMemberOfAsync(deviceId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMemberOf(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, List<DevicesSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listMemberOfAsync(deviceId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMemberOfSinglePageAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefMemberOf(this.client.getEndpoint(), deviceId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject2AutoGenerated2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject2AutoGenerated2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMemberOfSinglePageAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefMemberOf(this.client.getEndpoint(), deviceId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject2AutoGenerated2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject2AutoGenerated2)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefMemberOfAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby) {
        return new PagedFlux(() -> this.listRefMemberOfSinglePageAsync(deviceId, top, skip, search, filter, count, orderby), nextLink -> this.listRefMemberOfNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefMemberOfAsync(String deviceId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefMemberOfSinglePageAsync(deviceId, top, skip, search, filter, count, orderby), nextLink -> this.listRefMemberOfNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<String> listRefMemberOfAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefMemberOfSinglePageAsync(deviceId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefMemberOfNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefMemberOf(String deviceId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<DevicesOrderby> orderby = null;
        return new PagedIterable(this.listRefMemberOfAsync(deviceId, top, skip, search, filter, count, orderby));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefMemberOf(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefMemberOfAsync(deviceId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefMemberOfWithResponseAsync(String deviceId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefMemberOf(this.client.getEndpoint(), deviceId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefMemberOfWithResponseAsync(String deviceId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefMemberOf(this.client.getEndpoint(), deviceId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefMemberOfAsync(String deviceId, Map<String, Object> body) {
        return this.createRefMemberOfWithResponseAsync(deviceId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, Object> createRefMemberOf(String deviceId, Map<String, Object> body) {
        return (Map)this.createRefMemberOfAsync(deviceId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefMemberOfWithResponse(String deviceId, Map<String, Object> body, Context context) {
        return (Response)this.createRefMemberOfWithResponseAsync(deviceId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<String>>> checkMemberGroupsWithResponseAsync(String deviceId, DevicesCheckMemberGroupsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkMemberGroups(this.client.getEndpoint(), deviceId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<String>>> checkMemberGroupsWithResponseAsync(String deviceId, DevicesCheckMemberGroupsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkMemberGroups(this.client.getEndpoint(), deviceId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<String>> checkMemberGroupsAsync(String deviceId, DevicesCheckMemberGroupsRequestBody body) {
        return this.checkMemberGroupsWithResponseAsync(deviceId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<String> checkMemberGroups(String deviceId, DevicesCheckMemberGroupsRequestBody body) {
        return (List)this.checkMemberGroupsAsync(deviceId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<String>> checkMemberGroupsWithResponse(String deviceId, DevicesCheckMemberGroupsRequestBody body, Context context) {
        return (Response)this.checkMemberGroupsWithResponseAsync(deviceId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<String>>> checkMemberObjectsWithResponseAsync(String deviceId, DevicesCheckMemberObjectsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkMemberObjects(this.client.getEndpoint(), deviceId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<String>>> checkMemberObjectsWithResponseAsync(String deviceId, DevicesCheckMemberObjectsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkMemberObjects(this.client.getEndpoint(), deviceId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<String>> checkMemberObjectsAsync(String deviceId, DevicesCheckMemberObjectsRequestBody body) {
        return this.checkMemberObjectsWithResponseAsync(deviceId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<String> checkMemberObjects(String deviceId, DevicesCheckMemberObjectsRequestBody body) {
        return (List)this.checkMemberObjectsAsync(deviceId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<String>> checkMemberObjectsWithResponse(String deviceId, DevicesCheckMemberObjectsRequestBody body, Context context) {
        return (Response)this.checkMemberObjectsWithResponseAsync(deviceId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<String>>> getMemberGroupsWithResponseAsync(String deviceId, DevicesGetMemberGroupsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMemberGroups(this.client.getEndpoint(), deviceId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<String>>> getMemberGroupsWithResponseAsync(String deviceId, DevicesGetMemberGroupsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getMemberGroups(this.client.getEndpoint(), deviceId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<String>> getMemberGroupsAsync(String deviceId, DevicesGetMemberGroupsRequestBody body) {
        return this.getMemberGroupsWithResponseAsync(deviceId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<String> getMemberGroups(String deviceId, DevicesGetMemberGroupsRequestBody body) {
        return (List)this.getMemberGroupsAsync(deviceId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<String>> getMemberGroupsWithResponse(String deviceId, DevicesGetMemberGroupsRequestBody body, Context context) {
        return (Response)this.getMemberGroupsWithResponseAsync(deviceId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<String>>> getMemberObjectsWithResponseAsync(String deviceId, DevicesGetMemberObjectsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMemberObjects(this.client.getEndpoint(), deviceId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<String>>> getMemberObjectsWithResponseAsync(String deviceId, DevicesGetMemberObjectsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getMemberObjects(this.client.getEndpoint(), deviceId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<String>> getMemberObjectsAsync(String deviceId, DevicesGetMemberObjectsRequestBody body) {
        return this.getMemberObjectsWithResponseAsync(deviceId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<String> getMemberObjects(String deviceId, DevicesGetMemberObjectsRequestBody body) {
        return (List)this.getMemberObjectsAsync(deviceId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<String>> getMemberObjectsWithResponse(String deviceId, DevicesGetMemberObjectsRequestBody body, Context context) {
        return (Response)this.getMemberObjectsWithResponseAsync(deviceId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> restoreWithResponseAsync(String deviceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restore(this.client.getEndpoint(), deviceId, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> restoreWithResponseAsync(String deviceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.restore(this.client.getEndpoint(), deviceId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> restoreAsync(String deviceId) {
        return this.restoreWithResponseAsync(deviceId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryObjectInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphDirectoryObjectInner restore(String deviceId) {
        return (MicrosoftGraphDirectoryObjectInner)this.restoreAsync(deviceId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryObjectInner> restoreWithResponse(String deviceId, Context context) {
        return (Response)this.restoreWithResponseAsync(deviceId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listRegisteredOwnersSinglePageAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, List<DevicesSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRegisteredOwners(this.client.getEndpoint(), deviceId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject3AutoGenerated2)res.getValue()).value(), ((CollectionOfDirectoryObject3AutoGenerated2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listRegisteredOwnersSinglePageAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, List<DevicesSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRegisteredOwners(this.client.getEndpoint(), deviceId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject3AutoGenerated2)res.getValue()).value(), ((CollectionOfDirectoryObject3AutoGenerated2)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listRegisteredOwnersAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, List<DevicesSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listRegisteredOwnersSinglePageAsync(deviceId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listRegisteredOwnersNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listRegisteredOwnersAsync(String deviceId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listRegisteredOwnersSinglePageAsync(deviceId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listRegisteredOwnersNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listRegisteredOwnersAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, List<DevicesSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listRegisteredOwnersSinglePageAsync(deviceId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listRegisteredOwnersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listRegisteredOwners(String deviceId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<DevicesOrderby> orderby = null;
        List<DevicesSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listRegisteredOwnersAsync(deviceId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listRegisteredOwners(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, List<DevicesSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listRegisteredOwnersAsync(deviceId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefRegisteredOwnersSinglePageAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefRegisteredOwners(this.client.getEndpoint(), deviceId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject3AutoGenerated2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject3AutoGenerated2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefRegisteredOwnersSinglePageAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefRegisteredOwners(this.client.getEndpoint(), deviceId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject3AutoGenerated2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject3AutoGenerated2)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefRegisteredOwnersAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby) {
        return new PagedFlux(() -> this.listRefRegisteredOwnersSinglePageAsync(deviceId, top, skip, search, filter, count, orderby), nextLink -> this.listRefRegisteredOwnersNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefRegisteredOwnersAsync(String deviceId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefRegisteredOwnersSinglePageAsync(deviceId, top, skip, search, filter, count, orderby), nextLink -> this.listRefRegisteredOwnersNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<String> listRefRegisteredOwnersAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefRegisteredOwnersSinglePageAsync(deviceId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefRegisteredOwnersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefRegisteredOwners(String deviceId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<DevicesOrderby> orderby = null;
        return new PagedIterable(this.listRefRegisteredOwnersAsync(deviceId, top, skip, search, filter, count, orderby));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefRegisteredOwners(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefRegisteredOwnersAsync(deviceId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefRegisteredOwnersWithResponseAsync(String deviceId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefRegisteredOwners(this.client.getEndpoint(), deviceId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefRegisteredOwnersWithResponseAsync(String deviceId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefRegisteredOwners(this.client.getEndpoint(), deviceId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefRegisteredOwnersAsync(String deviceId, Map<String, Object> body) {
        return this.createRefRegisteredOwnersWithResponseAsync(deviceId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, Object> createRefRegisteredOwners(String deviceId, Map<String, Object> body) {
        return (Map)this.createRefRegisteredOwnersAsync(deviceId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefRegisteredOwnersWithResponse(String deviceId, Map<String, Object> body, Context context) {
        return (Response)this.createRefRegisteredOwnersWithResponseAsync(deviceId, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listRegisteredUsersSinglePageAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, List<DevicesSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRegisteredUsers(this.client.getEndpoint(), deviceId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject4AutoGenerated2)res.getValue()).value(), ((CollectionOfDirectoryObject4AutoGenerated2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listRegisteredUsersSinglePageAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, List<DevicesSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRegisteredUsers(this.client.getEndpoint(), deviceId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject4AutoGenerated2)res.getValue()).value(), ((CollectionOfDirectoryObject4AutoGenerated2)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listRegisteredUsersAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, List<DevicesSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listRegisteredUsersSinglePageAsync(deviceId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listRegisteredUsersNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listRegisteredUsersAsync(String deviceId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listRegisteredUsersSinglePageAsync(deviceId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listRegisteredUsersNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listRegisteredUsersAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, List<DevicesSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listRegisteredUsersSinglePageAsync(deviceId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listRegisteredUsersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listRegisteredUsers(String deviceId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<DevicesOrderby> orderby = null;
        List<DevicesSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listRegisteredUsersAsync(deviceId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listRegisteredUsers(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, List<DevicesSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listRegisteredUsersAsync(deviceId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefRegisteredUsersSinglePageAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefRegisteredUsers(this.client.getEndpoint(), deviceId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject4AutoGenerated2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject4AutoGenerated2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefRegisteredUsersSinglePageAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefRegisteredUsers(this.client.getEndpoint(), deviceId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject4AutoGenerated2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject4AutoGenerated2)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefRegisteredUsersAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby) {
        return new PagedFlux(() -> this.listRefRegisteredUsersSinglePageAsync(deviceId, top, skip, search, filter, count, orderby), nextLink -> this.listRefRegisteredUsersNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefRegisteredUsersAsync(String deviceId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefRegisteredUsersSinglePageAsync(deviceId, top, skip, search, filter, count, orderby), nextLink -> this.listRefRegisteredUsersNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<String> listRefRegisteredUsersAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefRegisteredUsersSinglePageAsync(deviceId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefRegisteredUsersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefRegisteredUsers(String deviceId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<DevicesOrderby> orderby = null;
        return new PagedIterable(this.listRefRegisteredUsersAsync(deviceId, top, skip, search, filter, count, orderby));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefRegisteredUsers(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefRegisteredUsersAsync(deviceId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefRegisteredUsersWithResponseAsync(String deviceId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefRegisteredUsers(this.client.getEndpoint(), deviceId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefRegisteredUsersWithResponseAsync(String deviceId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefRegisteredUsers(this.client.getEndpoint(), deviceId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefRegisteredUsersAsync(String deviceId, Map<String, Object> body) {
        return this.createRefRegisteredUsersWithResponseAsync(deviceId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, Object> createRefRegisteredUsers(String deviceId, Map<String, Object> body) {
        return (Map)this.createRefRegisteredUsersAsync(deviceId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefRegisteredUsersWithResponse(String deviceId, Map<String, Object> body, Context context) {
        return (Response)this.createRefRegisteredUsersWithResponseAsync(deviceId, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfSinglePageAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, List<DevicesSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listTransitiveMemberOf(this.client.getEndpoint(), deviceId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject5AutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObject5AutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfSinglePageAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, List<DevicesSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listTransitiveMemberOf(this.client.getEndpoint(), deviceId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject5AutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObject5AutoGenerated)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOfAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, List<DevicesSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listTransitiveMemberOfSinglePageAsync(deviceId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listTransitiveMemberOfNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOfAsync(String deviceId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listTransitiveMemberOfSinglePageAsync(deviceId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listTransitiveMemberOfNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOfAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, List<DevicesSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listTransitiveMemberOfSinglePageAsync(deviceId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listTransitiveMemberOfNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOf(String deviceId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<DevicesOrderby> orderby = null;
        List<DevicesSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listTransitiveMemberOfAsync(deviceId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOf(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, List<DevicesSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listTransitiveMemberOfAsync(deviceId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMemberOfSinglePageAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefTransitiveMemberOf(this.client.getEndpoint(), deviceId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject5)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject5)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMemberOfSinglePageAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefTransitiveMemberOf(this.client.getEndpoint(), deviceId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject5)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject5)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefTransitiveMemberOfAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby) {
        return new PagedFlux(() -> this.listRefTransitiveMemberOfSinglePageAsync(deviceId, top, skip, search, filter, count, orderby), nextLink -> this.listRefTransitiveMemberOfNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefTransitiveMemberOfAsync(String deviceId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefTransitiveMemberOfSinglePageAsync(deviceId, top, skip, search, filter, count, orderby), nextLink -> this.listRefTransitiveMemberOfNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<String> listRefTransitiveMemberOfAsync(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefTransitiveMemberOfSinglePageAsync(deviceId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefTransitiveMemberOfNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefTransitiveMemberOf(String deviceId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<DevicesOrderby> orderby = null;
        return new PagedIterable(this.listRefTransitiveMemberOfAsync(deviceId, top, skip, search, filter, count, orderby));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefTransitiveMemberOf(String deviceId, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefTransitiveMemberOfAsync(deviceId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefTransitiveMemberOfWithResponseAsync(String deviceId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefTransitiveMemberOf(this.client.getEndpoint(), deviceId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefTransitiveMemberOfWithResponseAsync(String deviceId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefTransitiveMemberOf(this.client.getEndpoint(), deviceId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefTransitiveMemberOfAsync(String deviceId, Map<String, Object> body) {
        return this.createRefTransitiveMemberOfWithResponseAsync(deviceId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, Object> createRefTransitiveMemberOf(String deviceId, Map<String, Object> body) {
        return (Map)this.createRefTransitiveMemberOfAsync(deviceId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefTransitiveMemberOfWithResponse(String deviceId, Map<String, Object> body, Context context) {
        return (Response)this.createRefTransitiveMemberOfWithResponseAsync(deviceId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionPropertiesWithResponseAsync(DevicesGetAvailableExtensionPropertiesRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAvailableExtensionProperties(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionPropertiesWithResponseAsync(DevicesGetAvailableExtensionPropertiesRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAvailableExtensionProperties(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<MicrosoftGraphExtensionPropertyInner>> getAvailableExtensionPropertiesAsync(DevicesGetAvailableExtensionPropertiesRequestBody body) {
        return this.getAvailableExtensionPropertiesWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<MicrosoftGraphExtensionPropertyInner> getAvailableExtensionProperties(DevicesGetAvailableExtensionPropertiesRequestBody body) {
        return (List)this.getAvailableExtensionPropertiesAsync(body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<MicrosoftGraphExtensionPropertyInner>> getAvailableExtensionPropertiesWithResponse(DevicesGetAvailableExtensionPropertiesRequestBody body, Context context) {
        return (Response)this.getAvailableExtensionPropertiesWithResponseAsync(body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIdsWithResponseAsync(DevicesGetByIdsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByIds(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIdsWithResponseAsync(DevicesGetByIdsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByIds(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<MicrosoftGraphDirectoryObjectInner>> getByIdsAsync(DevicesGetByIdsRequestBody body) {
        return this.getByIdsWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<MicrosoftGraphDirectoryObjectInner> getByIds(DevicesGetByIdsRequestBody body) {
        return (List)this.getByIdsAsync(body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<MicrosoftGraphDirectoryObjectInner>> getByIdsWithResponse(DevicesGetByIdsRequestBody body, Context context) {
        return (Response)this.getByIdsWithResponseAsync(body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> validatePropertiesWithResponseAsync(DevicesValidatePropertiesRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateProperties(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> validatePropertiesWithResponseAsync(DevicesValidatePropertiesRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validateProperties(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> validatePropertiesAsync(DevicesValidatePropertiesRequestBody body) {
        return this.validatePropertiesWithResponseAsync(body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void validateProperties(DevicesValidatePropertiesRequestBody body) {
        this.validatePropertiesAsync(body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> validatePropertiesWithResponse(DevicesValidatePropertiesRequestBody body, Context context) {
        return (Response)this.validatePropertiesWithResponseAsync(body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtensionAutoGenerated)res.getValue()).value(), ((CollectionOfExtensionAutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtensionAutoGenerated)res.getValue()).value(), ((CollectionOfExtensionAutoGenerated)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMemberOfNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject2AutoGenerated2)res.getValue()).value(), ((CollectionOfDirectoryObject2AutoGenerated2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMemberOfNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject2AutoGenerated2)res.getValue()).value(), ((CollectionOfDirectoryObject2AutoGenerated2)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefMemberOfNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject2AutoGenerated2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject2AutoGenerated2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMemberOfNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefMemberOfNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject2AutoGenerated2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject2AutoGenerated2)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listRegisteredOwnersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRegisteredOwnersNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject3AutoGenerated2)res.getValue()).value(), ((CollectionOfDirectoryObject3AutoGenerated2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listRegisteredOwnersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRegisteredOwnersNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject3AutoGenerated2)res.getValue()).value(), ((CollectionOfDirectoryObject3AutoGenerated2)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefRegisteredOwnersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefRegisteredOwnersNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject3AutoGenerated2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject3AutoGenerated2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefRegisteredOwnersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefRegisteredOwnersNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject3AutoGenerated2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject3AutoGenerated2)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listRegisteredUsersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRegisteredUsersNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject4AutoGenerated2)res.getValue()).value(), ((CollectionOfDirectoryObject4AutoGenerated2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listRegisteredUsersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRegisteredUsersNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject4AutoGenerated2)res.getValue()).value(), ((CollectionOfDirectoryObject4AutoGenerated2)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefRegisteredUsersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefRegisteredUsersNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject4AutoGenerated2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject4AutoGenerated2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefRegisteredUsersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefRegisteredUsersNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject4AutoGenerated2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject4AutoGenerated2)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listTransitiveMemberOfNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject5AutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObject5AutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listTransitiveMemberOfNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject5AutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObject5AutoGenerated)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefTransitiveMemberOfNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject5)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject5)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMemberOfNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefTransitiveMemberOfNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject5)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject5)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    private static interface DevicesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/devices/{device-id}/extensions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfExtensionAutoGenerated>> listExtensions(@HostParam(value="$host") String var1, @PathParam(value="device-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/devices/{device-id}/extensions")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphExtensionInner>> createExtensions(@HostParam(value="$host") String var1, @PathParam(value="device-id") String var2, @BodyParam(value="application/json") MicrosoftGraphExtensionInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/devices/{device-id}/extensions/{extension-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphExtensionInner>> getExtensions(@HostParam(value="$host") String var1, @PathParam(value="device-id") String var2, @PathParam(value="extension-id") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/devices/{device-id}/extensions/{extension-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateExtensions(@HostParam(value="$host") String var1, @PathParam(value="device-id") String var2, @PathParam(value="extension-id") String var3, @BodyParam(value="application/json") MicrosoftGraphExtensionInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/devices/{device-id}/extensions/{extension-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteExtensions(@HostParam(value="$host") String var1, @PathParam(value="device-id") String var2, @PathParam(value="extension-id") String var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/devices/{device-id}/memberOf")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject2AutoGenerated2>> listMemberOf(@HostParam(value="$host") String var1, @PathParam(value="device-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/devices/{device-id}/memberOf/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject2AutoGenerated2>> listRefMemberOf(@HostParam(value="$host") String var1, @PathParam(value="device-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/devices/{device-id}/memberOf/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefMemberOf(@HostParam(value="$host") String var1, @PathParam(value="device-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/devices/{device-id}/microsoft.graph.checkMemberGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> checkMemberGroups(@HostParam(value="$host") String var1, @PathParam(value="device-id") String var2, @BodyParam(value="application/json") DevicesCheckMemberGroupsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/devices/{device-id}/microsoft.graph.checkMemberObjects")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> checkMemberObjects(@HostParam(value="$host") String var1, @PathParam(value="device-id") String var2, @BodyParam(value="application/json") DevicesCheckMemberObjectsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/devices/{device-id}/microsoft.graph.getMemberGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> getMemberGroups(@HostParam(value="$host") String var1, @PathParam(value="device-id") String var2, @BodyParam(value="application/json") DevicesGetMemberGroupsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/devices/{device-id}/microsoft.graph.getMemberObjects")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> getMemberObjects(@HostParam(value="$host") String var1, @PathParam(value="device-id") String var2, @BodyParam(value="application/json") DevicesGetMemberObjectsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/devices/{device-id}/microsoft.graph.restore")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDirectoryObjectInner>> restore(@HostParam(value="$host") String var1, @PathParam(value="device-id") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/devices/{device-id}/registeredOwners")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject3AutoGenerated2>> listRegisteredOwners(@HostParam(value="$host") String var1, @PathParam(value="device-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/devices/{device-id}/registeredOwners/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject3AutoGenerated2>> listRefRegisteredOwners(@HostParam(value="$host") String var1, @PathParam(value="device-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/devices/{device-id}/registeredOwners/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefRegisteredOwners(@HostParam(value="$host") String var1, @PathParam(value="device-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/devices/{device-id}/registeredUsers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject4AutoGenerated2>> listRegisteredUsers(@HostParam(value="$host") String var1, @PathParam(value="device-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/devices/{device-id}/registeredUsers/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject4AutoGenerated2>> listRefRegisteredUsers(@HostParam(value="$host") String var1, @PathParam(value="device-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/devices/{device-id}/registeredUsers/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefRegisteredUsers(@HostParam(value="$host") String var1, @PathParam(value="device-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/devices/{device-id}/transitiveMemberOf")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject5AutoGenerated>> listTransitiveMemberOf(@HostParam(value="$host") String var1, @PathParam(value="device-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/devices/{device-id}/transitiveMemberOf/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject5>> listRefTransitiveMemberOf(@HostParam(value="$host") String var1, @PathParam(value="device-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/devices/{device-id}/transitiveMemberOf/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefTransitiveMemberOf(@HostParam(value="$host") String var1, @PathParam(value="device-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/devices/microsoft.graph.getAvailableExtensionProperties")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionProperties(@HostParam(value="$host") String var1, @BodyParam(value="application/json") DevicesGetAvailableExtensionPropertiesRequestBody var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/devices/microsoft.graph.getByIds")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIds(@HostParam(value="$host") String var1, @BodyParam(value="application/json") DevicesGetByIdsRequestBody var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/devices/microsoft.graph.validateProperties")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> validateProperties(@HostParam(value="$host") String var1, @BodyParam(value="application/json") DevicesValidatePropertiesRequestBody var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfExtensionAutoGenerated>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject2AutoGenerated2>> listMemberOfNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject2AutoGenerated2>> listRefMemberOfNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject3AutoGenerated2>> listRegisteredOwnersNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject3AutoGenerated2>> listRefRegisteredOwnersNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject4AutoGenerated2>> listRegisteredUsersNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject4AutoGenerated2>> listRefRegisteredUsersNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject5AutoGenerated>> listTransitiveMemberOfNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject5>> listRefTransitiveMemberOfNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

