/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.ws;

import com.vmware.vim25.ws.Argument;
import com.vmware.vim25.ws.CustomSSLTrustContextCreator;
import com.vmware.vim25.ws.SoapAction;
import com.vmware.vim25.ws.SoapClient;
import com.vmware.vim25.ws.TrustAllSSL;
import com.vmware.vim25.ws.XmlGen;
import com.vmware.vim25.ws.XmlGenDom;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WSClient
extends SoapClient {
    private static final Log log = LogFactory.getLog(WSClient.class);
    private final SSLSocketFactory sslSocketFactory;
    private XmlGen xmlGen = new XmlGenDom();

    public WSClient(String serverUrl) throws MalformedURLException, RemoteException {
        this(serverUrl, true);
    }

    public WSClient(String serverUrl, boolean ignoreCert) throws MalformedURLException, RemoteException {
        this(serverUrl, ignoreCert, null);
    }

    public WSClient(String serverUrl, boolean ignoreCert, TrustManager trustManager) throws MalformedURLException, RemoteException {
        if (ignoreCert && trustManager != null) {
            log.warn((Object)"The option to ignore certs has been set along with a provided trust manager. This is not a valid scenario and the trust manager will be ignored.");
        }
        if (serverUrl.endsWith("/")) {
            serverUrl = serverUrl.substring(0, serverUrl.length() - 1);
        }
        log.trace((Object)("Creating WSClient to server URL: " + serverUrl));
        log.trace((Object)("Ignore ssl: " + ignoreCert));
        this.trustManager = trustManager;
        this.baseUrl = new URL(serverUrl);
        this.sslSocketFactory = ignoreCert ? this.getTrustAllSocketFactory(true) : this.getCustomTrustManagerSocketFactory(trustManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(String methodName, Argument[] paras, String returnType) throws RemoteException {
        log.trace((Object)("Invoking method: " + methodName));
        String soapMsg = this.marshall(methodName, paras);
        int iRetry = 0;
        while (true) {
            Object object;
            HttpURLConnection postCon;
            block22: {
                if (this.controller != null && this.controller.isDebugSoapRequest()) {
                    this.controller.printDebug("WSClient", "invoke-" + methodName, "Open connection : " + this.baseUrl.getPath());
                }
                postCon = (HttpURLConnection)this.baseUrl.openConnection();
                if (this.controller != null && this.controller.isDebugSoapRequest()) {
                    this.controller.printDebug("WSClient", "invoke", "post SOAP Message : " + soapMsg);
                }
                InputStream is = this.post(postCon, soapMsg);
                try {
                    log.trace((Object)("Converting xml response from server to: " + returnType));
                    Object oUnMarshall = this.unMarshall(returnType, is, soapMsg);
                    if (postCon.getResponseCode() != 200) {
                        throw new ServiceException(postCon.getResponseMessage(), postCon.getResponseCode());
                    }
                    object = oUnMarshall;
                    if (is == null) break block22;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            try {
                                if (is != null) {
                                    is.close();
                                }
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                if (postCon != null) {
                                    postCon.disconnect();
                                }
                                throw throwable2;
                            }
                        }
                        catch (Throwable t) {
                            long lRetrySleep;
                            if (this.controller == null) {
                                throw t;
                            }
                            if ((lRetrySleep = this.controller.getRetryAfterMs(t, ++iRetry, methodName)) < 0L) {
                                throw t;
                            }
                            if (lRetrySleep <= 0L) continue;
                            Thread.sleep(lRetrySleep);
                            continue;
                        }
                    }
                    catch (Throwable t1) {
                        log.error((Object)("Exception caught while invoking method: " + methodName), t1);
                        try {
                            throw (RemoteException)t1;
                        }
                        catch (ClassCastException ignore) {
                            throw new RemoteException("Exception caught trying to invoke method " + methodName, t1);
                        }
                    }
                }
                is.close();
            }
            if (postCon != null) {
                postCon.disconnect();
            }
            return object;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public StringBuffer invokeAsString(String methodName, Argument[] paras) throws RemoteException {
        String soapMsg = XmlGen.toXML(methodName, paras, this.vimNameSpace);
        try {
            HttpURLConnection postCon = (HttpURLConnection)this.baseUrl.openConnection();
            try {
                StringBuffer stringBuffer;
                block10: {
                    InputStream is = this.post(postCon, soapMsg);
                    try {
                        stringBuffer = this.readStream(is);
                        if (is == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            is.close();
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return stringBuffer;
            }
            finally {
                if (postCon != null) {
                    postCon.disconnect();
                }
            }
        }
        catch (Exception e) {
            throw new RemoteException("VI SDK invoke exception:" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream post(HttpURLConnection postCon, String soapMsg) throws IOException {
        InputStream is;
        if (this.controller != null && this.controller.isDebugAll()) {
            this.controller.printDebug("WSClient", "post", "Start");
        }
        if (this.sslSocketFactory != null && this.baseUrl.getProtocol().equalsIgnoreCase("https") && (this.controller == null || !this.controller.setSecureConnectionConfig((HttpsURLConnection)postCon))) {
            ((HttpsURLConnection)postCon).setSSLSocketFactory(this.sslSocketFactory);
        }
        log.trace((Object)("POST: " + this.soapAction));
        log.trace((Object)("Payload: " + soapMsg));
        if (this.connectTimeout > 0) {
            postCon.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout > 0) {
            postCon.setReadTimeout(this.readTimeout);
        }
        try {
            postCon.setRequestMethod("POST");
        }
        catch (ProtocolException e) {
            log.debug((Object)"ProtocolException caught.", (Throwable)e);
        }
        postCon.setDoOutput(true);
        postCon.setDoInput(true);
        String soapAction = this.soapAction;
        if (soapAction == null) {
            soapAction = "";
        }
        postCon.setRequestProperty(SoapAction.SOAP_ACTION_HEADER.toString(), soapAction);
        postCon.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
        byte[] abBytes = soapMsg.getBytes("UTF-8");
        postCon.setRequestProperty("Content-Length", String.valueOf(abBytes.length));
        if (this.cookie != null) {
            log.trace((Object)"Setting Cookie.");
            postCon.setRequestProperty("Cookie", this.cookie);
        }
        if (this.controller != null && !this.controller.isKeepConnectionAlive()) {
            postCon.setRequestProperty("Connection", "close");
        }
        if (this.controller != null && this.controller.isDebugAll()) {
            this.controller.printDebug("WSClient", "post", "Connect, cookie=" + this.cookie);
        }
        postCon.connect();
        int BUFFER_SIZE = 16384;
        try (BufferedOutputStream os = new BufferedOutputStream(postCon.getOutputStream(), 16384);){
            ((OutputStream)os).write(abBytes);
        }
        if (this.controller != null && this.controller.isDebugAll()) {
            this.controller.printDebug("WSClient", "post", "GetInputStream");
        }
        try {
            is = postCon.getInputStream();
        }
        catch (IOException ioe) {
            ByteArrayOutputStream baos;
            is = postCon.getErrorStream();
            try {
                baos = new ByteArrayOutputStream(16384);
                try {
                    int iRead;
                    byte[] abData = new byte[16384];
                    while ((iRead = is.read(abData)) != -1) {
                        if (this.controller != null && this.controller.isDebugSoapRequest()) {
                            this.controller.printDebug("WSClient", "post", new String(abData, 0, iRead));
                        }
                        baos.write(abData, 0, iRead);
                    }
                }
                finally {
                    baos.close();
                }
            }
            finally {
                is.close();
            }
            is = new ByteArrayInputStream(baos.toByteArray());
        }
        is = new BufferedInputStream(is, 16384);
        String newCookie = postCon.getHeaderField("Set-Cookie");
        if (this.setCookie(newCookie, "WSClient-post")) {
            log.trace((Object)"Fetching Set-Cookie header to get new Cookie.");
        }
        if (this.controller != null && this.controller.isDebugAll()) {
            this.controller.printDebug("WSClient", "post", "End");
        }
        return is;
    }

    protected InputStream getInputStreamFromConnection(HttpURLConnection postCon) throws RemoteException {
        InputStream is;
        try {
            is = postCon.getInputStream();
            log.trace((Object)"Successfully fetched InputStream.");
        }
        catch (IOException ioe) {
            log.debug((Object)"Caught an IOException. Reading ErrorStream for results.", (Throwable)ioe);
            InputStream errorStream = postCon.getErrorStream();
            if (errorStream != null) {
                is = errorStream;
            }
            throw new RemoteException(MessageFormat.format("An error occurred getting a response from the connection at url {0}", this.baseUrl), ioe);
        }
        return is;
    }

    protected OutputStreamWriter createOutputStreamWriter(OutputStream os) throws UnsupportedEncodingException {
        return new OutputStreamWriter(os, "UTF8");
    }

    protected SSLSocketFactory getTrustAllSocketFactory(boolean ignoreCert) throws RemoteException {
        return ignoreCert ? TrustAllSSL.getTrustContext().getSocketFactory() : null;
    }

    protected SSLSocketFactory getCustomTrustManagerSocketFactory(TrustManager tm) throws RemoteException {
        return tm != null ? CustomSSLTrustContextCreator.getTrustContext(tm).getSocketFactory() : null;
    }

    public static class ServiceException
    extends Exception {
        private int iHttpCode;

        public ServiceException(String sMsg, int iHttpCode) {
            super(sMsg);
            this.iHttpCode = iHttpCode;
        }

        public int getHttpCode() {
            return this.iHttpCode;
        }
    }
}

