/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.ws;

import com.vmware.vim25.ws.Argument;
import com.vmware.vim25.ws.Client;
import com.vmware.vim25.ws.SoapAction;
import com.vmware.vim25.ws.XmlGen;
import com.vmware.vim25.ws.XmlGenDom;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SoapClient
implements Client {
    private static Log log = LogFactory.getLog(SoapClient.class);
    public String soapAction;
    public URL baseUrl = null;
    public String cookie = null;
    public String vimNameSpace = null;
    public int connectTimeout = 0;
    public int readTimeout = 0;
    protected TrustManager trustManager;
    XmlGen xmlGen = new XmlGenDom();
    protected IController controller = null;

    @Override
    public void setSoapActionOnApiVersion(String apiVersion) {
        log.trace((Object)("API Version detected: " + apiVersion));
        this.soapAction = "4.0".equals(apiVersion) ? SoapAction.SOAP_ACTION_V40.toString() : ("4.1".equals(apiVersion) ? SoapAction.SOAP_ACTION_V41.toString() : ("5.0".equals(apiVersion) ? SoapAction.SOAP_ACTION_V50.toString() : ("5.1".equals(apiVersion) ? SoapAction.SOAP_ACTION_V51.toString() : ("5.5".equals(apiVersion) ? SoapAction.SOAP_ACTION_V55.toString() : ("6.0".equals(apiVersion) ? SoapAction.SOAP_ACTION_V60.toString() : ("6.5".equals(apiVersion) ? SoapAction.SOAP_ACTION_V65.toString() : SoapAction.SOAP_ACTION_V65.toString()))))));
        log.trace((Object)("Set soapAction to: " + this.soapAction));
    }

    @Override
    public URL getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public void setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public String getCookie() {
        return this.cookie;
    }

    @Override
    public boolean setCookie(String cookie, String sDescription) {
        if (cookie == null) {
            return false;
        }
        if (this.cookie != null && this.cookie.equals(cookie)) {
            return false;
        }
        if (this.controller != null && this.controller.isDebugAll()) {
            this.controller.printDebug("SoapClient", "setCookie", "[" + sDescription + "] '" + this.cookie + "' -> '" + cookie + "'");
        }
        this.cookie = cookie;
        return true;
    }

    @Override
    public String getVimNameSpace() {
        return this.vimNameSpace;
    }

    @Override
    public void setVimNameSpace(String vimNameSpace) {
        this.vimNameSpace = vimNameSpace;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(int timeoutMilliSec) {
        this.connectTimeout = timeoutMilliSec;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int timeoutMilliSec) {
        this.readTimeout = timeoutMilliSec;
    }

    @Override
    public TrustManager getTrustManager() {
        return this.trustManager;
    }

    @Override
    public StringBuffer readStream(InputStream is) throws IOException {
        String lineStr;
        log.trace((Object)"Building StringBuffer from InputStream response.");
        StringBuffer sb = new StringBuffer();
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        while ((lineStr = in.readLine()) != null) {
            sb.append(lineStr);
        }
        in.close();
        return sb;
    }

    @Override
    public String marshall(String methodName, Argument[] paras) {
        String soapMsg = XmlGen.toXML(methodName, paras, this.vimNameSpace);
        log.trace((Object)("Marshalled Payload String xml: " + soapMsg));
        return soapMsg;
    }

    @Override
    public Object unMarshall(String returnType, InputStream is, String soapMsg) throws Exception {
        return this.xmlGen.fromXML(returnType, is, this.controller, soapMsg);
    }

    public void setController(IController controller) {
        this.controller = controller;
    }

    public static interface IController {
        public static final int DEFAULT_RETRY_MODE = 0;
        public static final int CREATE_SESSION_RETRY_MODE = 1;

        public boolean isDebugSoapRequest();

        public boolean isDebugAll();

        public void printDebug(String var1, String var2, String var3);

        public long getRetryAfterMs(Throwable var1, int var2, String var3);

        public boolean setSecureConnectionConfig(HttpsURLConnection var1);

        public boolean isKeepConnectionAlive();

        public int getRetryMode();

        public void setRetryMode(int var1);
    }
}

