/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.PerfCompositeMetric;
import com.vmware.vim25.PerfCounterInfo;
import com.vmware.vim25.PerfEntityMetricBase;
import com.vmware.vim25.PerfInterval;
import com.vmware.vim25.PerfMetricId;
import com.vmware.vim25.PerfProviderSummary;
import com.vmware.vim25.PerfQuerySpec;
import com.vmware.vim25.PerformanceDescription;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServerConnection;
import java.rmi.RemoteException;
import java.util.Calendar;

public class PerformanceManager
extends ManagedObject {
    public PerformanceManager(ServerConnection serverConnection, ManagedObjectReference mor) {
        super(serverConnection, mor);
    }

    public PerformanceDescription getDescription() {
        return (PerformanceDescription)this.getCurrentProperty("description");
    }

    public PerfInterval[] getHistoricalInterval() {
        return (PerfInterval[])this.getCurrentProperty("historicalInterval");
    }

    public PerfCounterInfo[] getPerfCounter() {
        return (PerfCounterInfo[])this.getCurrentProperty("perfCounter");
    }

    public void createPerfInterval(PerfInterval intervalId) throws RuntimeFault, RemoteException {
        this.getVimService().createPerfInterval(this.getMOR(), intervalId);
    }

    public PerfMetricId[] queryAvailablePerfMetric(ManagedEntity entity, Calendar beginTime, Calendar endTime, Integer intervalId) throws RuntimeFault, RemoteException {
        if (entity == null) {
            throw new IllegalArgumentException("entity must not be null.");
        }
        return this.getVimService().queryAvailablePerfMetric(this.getMOR(), entity.getMOR(), beginTime, endTime, intervalId);
    }

    public PerfEntityMetricBase[] queryPerf(PerfQuerySpec[] querySpec) throws RuntimeFault, RemoteException {
        return this.getVimService().queryPerf(this.getMOR(), querySpec);
    }

    public PerfCompositeMetric queryPerfComposite(PerfQuerySpec querySpec) throws RuntimeFault, RemoteException {
        return this.getVimService().queryPerfComposite(this.getMOR(), querySpec);
    }

    public PerfCounterInfo[] queryPerfCounter(int[] counterIds) throws RuntimeFault, RemoteException {
        return this.getVimService().queryPerfCounter(this.getMOR(), counterIds);
    }

    public PerfCounterInfo[] queryPerfCounterByLevel(int level) throws RuntimeFault, RemoteException {
        return this.getVimService().queryPerfCounterByLevel(this.getMOR(), level);
    }

    public PerfProviderSummary queryPerfProviderSummary(ManagedEntity entity) throws RuntimeFault, RemoteException {
        if (entity == null) {
            throw new IllegalArgumentException("entity must not be null.");
        }
        return this.getVimService().queryPerfProviderSummary(this.getMOR(), entity.getMOR());
    }

    public void removePerfInterval(int samplePeriod) throws RuntimeFault, RemoteException {
        this.getVimService().removePerfInterval(this.getMOR(), samplePeriod);
    }

    public void updatePerfInterval(PerfInterval interval) throws RuntimeFault, RemoteException {
        this.getVimService().updatePerfInterval(this.getMOR(), interval);
    }
}

