/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.AuthMinimumAdminPermission;
import com.vmware.vim25.HostAccessControlEntry;
import com.vmware.vim25.HostAccessMode;
import com.vmware.vim25.HostLockdownMode;
import com.vmware.vim25.InvalidArgument;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NoPermission;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.SecurityError;
import com.vmware.vim25.UserNotFound;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServerConnection;
import java.rmi.RemoteException;

public class HostAccessManager
extends ManagedObject {
    public HostAccessManager(ServerConnection sc, ManagedObjectReference mor) {
        super(sc, mor);
    }

    public HostLockdownMode getLockdownMode() {
        return (HostLockdownMode)((Object)this.getCurrentProperty("lockdownMode"));
    }

    public void changeAccessMode(String principal, boolean isGroup, HostAccessMode accessMode) throws AuthMinimumAdminPermission, InvalidArgument, RuntimeFault, SecurityError, UserNotFound, RemoteException {
        this.getVimService().changeAccessMode(this.getMOR(), principal, isGroup, accessMode);
    }

    public void changeLockdownMode(HostLockdownMode mode) throws AuthMinimumAdminPermission, NoPermission, RuntimeFault, RemoteException {
        this.getVimService().changeHostLockdownMode(this.getMOR(), mode);
    }

    public String[] queryLockdownExceptions() throws RuntimeFault, RemoteException {
        return this.getVimService().queryLockdownExceptions(this.getMOR());
    }

    public String[] querySystemUsers() throws RuntimeFault, RemoteException {
        return this.getVimService().querySystemUsers(this.getMOR());
    }

    public HostAccessControlEntry[] retrieveHostAccessControlEntries() throws RuntimeFault, RemoteException {
        return this.getVimService().retrieveHostAccessControlEntries(this.getMOR());
    }

    public void updateLockdownExceptions(String[] users) throws AuthMinimumAdminPermission, RuntimeFault, UserNotFound, RemoteException {
        this.getVimService().updateLockdownExceptions(this.getMOR(), users);
    }

    public void updateLockdownExceptions() throws AuthMinimumAdminPermission, RuntimeFault, UserNotFound, RemoteException {
        this.updateLockdownExceptions(null);
    }

    public void updateSystemUsers(String[] users) throws InvalidArgument, RuntimeFault, UserNotFound, RemoteException {
        this.getVimService().updateSystemUsers(this.getMOR(), users);
    }

    public void updateSystemUsers() throws InvalidArgument, RuntimeFault, UserNotFound, RemoteException {
        this.updateSystemUsers(null);
    }
}

