/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.nested;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.tagext.Tag;
import java.util.StringTokenizer;
import org.apache.struts.taglib.html.FormTag;
import org.apache.struts.taglib.nested.NestedNameSupport;
import org.apache.struts.taglib.nested.NestedPropertySupport;
import org.apache.struts.taglib.nested.NestedReference;

public class NestedPropertyHelper {
    public static final String NESTED_INCLUDES_KEY = "<nested-includes-key/>";

    public static final String getCurrentProperty(HttpServletRequest request) {
        NestedReference nr = (NestedReference)request.getAttribute(NESTED_INCLUDES_KEY);
        return nr == null ? null : nr.getNestedProperty();
    }

    public static final String getCurrentName(HttpServletRequest request, NestedNameSupport nested) {
        NestedReference nr = (NestedReference)request.getAttribute(NESTED_INCLUDES_KEY);
        if (nr != null) {
            return nr.getBeanName();
        }
        Tag tag = (Tag)nested;
        Tag formTag = null;
        do {
            if ((tag = tag.getParent()) == null || !(tag instanceof FormTag)) continue;
            formTag = tag;
        } while (formTag == null && tag != null);
        if (formTag == null) {
            return "";
        }
        return ((FormTag)formTag).getBeanName();
    }

    public static final String getAdjustedProperty(HttpServletRequest request, String property) {
        String parent = NestedPropertyHelper.getCurrentProperty(request);
        return NestedPropertyHelper.calculateRelativeProperty(property, parent);
    }

    public static final void setProperty(HttpServletRequest request, String property) {
        NestedReference nr = NestedPropertyHelper.referenceInstance(request);
        nr.setNestedProperty(property);
    }

    public static final void setName(HttpServletRequest request, String name) {
        NestedReference nr = NestedPropertyHelper.referenceInstance(request);
        nr.setBeanName(name);
    }

    public static final void deleteReference(HttpServletRequest request) {
        request.removeAttribute(NESTED_INCLUDES_KEY);
    }

    public static void setNestedProperties(HttpServletRequest request, NestedPropertySupport tag) {
        boolean adjustProperty = true;
        if (tag instanceof NestedNameSupport) {
            NestedNameSupport nameTag = (NestedNameSupport)tag;
            if (nameTag.getName() == null || "org.apache.struts.taglib.html.BEAN".equals(nameTag.getName())) {
                nameTag.setName(NestedPropertyHelper.getCurrentName(request, (NestedNameSupport)tag));
            } else {
                adjustProperty = false;
            }
        }
        String property = tag.getProperty();
        if (adjustProperty) {
            property = NestedPropertyHelper.getAdjustedProperty(request, property);
        }
        tag.setProperty(property);
    }

    private static final NestedReference referenceInstance(HttpServletRequest request) {
        NestedReference nr = (NestedReference)request.getAttribute(NESTED_INCLUDES_KEY);
        if (nr == null) {
            nr = new NestedReference();
            request.setAttribute(NESTED_INCLUDES_KEY, (Object)nr);
        }
        return nr;
    }

    private static String calculateRelativeProperty(String property, String parent) {
        String stepping;
        if (parent == null) {
            parent = "";
        }
        if (property == null) {
            property = "";
        }
        if ("./".equals(property) || "this/".equals(property)) {
            return parent;
        }
        if (property.endsWith("/")) {
            stepping = property;
            property = "";
        } else {
            stepping = property.substring(0, property.lastIndexOf(47) + 1);
            property = property.substring(property.lastIndexOf(47) + 1, property.length());
        }
        if (stepping.startsWith("/")) {
            return property;
        }
        StringTokenizer proT = new StringTokenizer(parent, ".");
        int propCount = proT.countTokens();
        StringTokenizer strT = new StringTokenizer(stepping, "/");
        int count = strT.countTokens();
        if (count >= propCount) {
            return property;
        }
        count = propCount - count;
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            result.append(proT.nextToken());
            result.append('.');
        }
        result.append(property);
        if (result.charAt(result.length() - 1) == '.') {
            return result.substring(0, result.length() - 1);
        }
        return result.toString();
    }
}

