/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.logic;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import java.security.Principal;
import java.util.StringTokenizer;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.taglib.logic.ConditionalTagBase;

public class PresentTag
extends ConditionalTagBase {
    private static final long serialVersionUID = 5444827720181318160L;
    public static final String ROLE_DELIMITER = ",";

    @Override
    protected boolean condition() throws JspException {
        return this.condition(true);
    }

    protected boolean condition(boolean desired) throws JspException {
        boolean present = false;
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        if (this.cookie != null) {
            present = this.isCookiePresent(request);
        } else if (this.header != null) {
            String value = request.getHeader(this.header);
            present = value != null;
        } else if (this.name != null) {
            present = this.isBeanPresent();
        } else if (this.parameter != null) {
            String value = request.getParameter(this.parameter);
            present = value != null;
        } else if (this.role != null) {
            StringTokenizer st = new StringTokenizer(this.role, ROLE_DELIMITER, false);
            while (!present && st.hasMoreTokens()) {
                present = request.isUserInRole(st.nextToken());
            }
        } else if (this.user != null) {
            Principal principal = request.getUserPrincipal();
            present = principal != null && this.user.equals(principal.getName());
        } else {
            JspException e = new JspException(messages.getMessage("logic.selector"));
            TagUtils.getInstance().saveException(this.pageContext, e);
            throw e;
        }
        return present == desired;
    }

    protected boolean isBeanPresent() {
        Object value = null;
        try {
            value = this.property != null ? TagUtils.getInstance().lookup(this.pageContext, this.name, this.property, this.scope) : TagUtils.getInstance().lookup(this.pageContext, this.name, this.scope);
        }
        catch (JspException e) {
            value = null;
        }
        return value != null;
    }

    protected boolean isCookiePresent(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return false;
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!this.cookie.equals(cookies[i].getName())) continue;
            return true;
        }
        return false;
    }
}

