/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.html;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.BodyTagSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.Var;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.util.MessageResources;
import org.apache.struts.validator.Resources;

public class JavascriptValidatorTag
extends BodyTagSupport {
    private static final long serialVersionUID = 1844396649370462479L;
    private static final Comparator<ValidatorAction> actionComparator = (va1, va2) -> {
        if (!(va1.getDepends() != null && va1.getDepends().length() != 0 || va2.getDepends() != null && va2.getDepends().length() != 0)) {
            return 0;
        }
        if (va1.getDepends() != null && va1.getDepends().length() > 0 && (va2.getDepends() == null || va2.getDepends().length() == 0)) {
            return 1;
        }
        if ((va1.getDepends() == null || va1.getDepends().length() == 0) && va2.getDepends() != null && va2.getDepends().length() > 0) {
            return -1;
        }
        return va1.getDependencyList().size() - va2.getDependencyList().size();
    };
    protected static final String HTML_BEGIN_COMMENT = "\n<!-- Begin \n";
    protected static final String HTML_END_COMMENT = "//End --> \n";
    protected static String lineEnd = System.getProperty("line.separator");
    protected String bundle = "org.apache.struts.action.MESSAGE";
    protected String formName = null;
    protected String jsFormName = null;
    protected int page = 0;
    protected String methodName = null;
    protected boolean scriptLanguage = true;
    protected String staticJavascript = "true";
    protected String dynamicJavascript = "true";
    protected String src = null;
    protected String htmlComment = "true";
    protected String cdata = "true";

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public String getJsFormName() {
        return this.jsFormName;
    }

    public void setJsFormName(String jsFormName) {
        this.jsFormName = jsFormName;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public String getMethod() {
        return this.methodName;
    }

    public void setMethod(String methodName) {
        this.methodName = methodName;
    }

    public String getStaticJavascript() {
        return this.staticJavascript;
    }

    public void setStaticJavascript(String staticJavascript) {
        this.staticJavascript = staticJavascript;
    }

    public String getDynamicJavascript() {
        return this.dynamicJavascript;
    }

    public void setDynamicJavascript(String dynamicJavascript) {
        this.dynamicJavascript = dynamicJavascript;
    }

    public String getHtmlComment() {
        return this.htmlComment;
    }

    public void setHtmlComment(String htmlComment) {
        this.htmlComment = htmlComment;
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public int doStartTag() throws JspException {
        JspWriter writer = this.pageContext.getOut();
        try {
            writer.print(this.renderJavascript());
        }
        catch (IOException e) {
            throw new JspException(e.getMessage(), (Throwable)e);
        }
        return 2;
    }

    protected String renderJavascript() throws JspException {
        StringBuilder results = new StringBuilder();
        ModuleConfig config = TagUtils.getInstance().getModuleConfig(this.pageContext);
        ValidatorResources resources = (ValidatorResources)this.pageContext.getAttribute("org.apache.commons.validator.VALIDATOR_RESOURCES" + config.getPrefix(), 4);
        if (resources == null) {
            throw new JspException("ValidatorResources not found in application scope under key \"org.apache.commons.validator.VALIDATOR_RESOURCES" + config.getPrefix() + "\"");
        }
        Locale locale = TagUtils.getInstance().getUserLocale(this.pageContext, null);
        Form form = null;
        if ("true".equalsIgnoreCase(this.dynamicJavascript) && (form = resources.getForm(locale, this.formName)) == null) {
            throw new JspException("No form found under '" + this.formName + "' in locale '" + locale + "'.  A form must be defined in the Commons Validator configuration when dynamicJavascript=\"true\" is set.");
        }
        if (form != null) {
            if ("true".equalsIgnoreCase(this.dynamicJavascript)) {
                results.append(this.createDynamicJavascript(config, resources, locale, form));
            } else if ("true".equalsIgnoreCase(this.staticJavascript)) {
                results.append(this.renderStartElement());
                if ("true".equalsIgnoreCase(this.htmlComment)) {
                    results.append(HTML_BEGIN_COMMENT);
                }
            }
        }
        if ("true".equalsIgnoreCase(this.staticJavascript)) {
            results.append(this.getJavascriptStaticMethods(resources));
        }
        if (form != null && ("true".equalsIgnoreCase(this.dynamicJavascript) || "true".equalsIgnoreCase(this.staticJavascript))) {
            results.append(this.getJavascriptEnd());
        }
        return results.toString();
    }

    private String createDynamicJavascript(ModuleConfig config, ValidatorResources resources, Locale locale, Form form) throws JspException {
        String formName;
        StringBuilder results = new StringBuilder();
        MessageResources messages = TagUtils.getInstance().retrieveMessageResources(this.pageContext, this.bundle, true);
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        ServletContext application = this.pageContext.getServletContext();
        List<ValidatorAction> actions = this.createActionList(resources, form);
        String methods = this.createMethods(actions, this.stopOnError(config));
        this.jsFormName = formName = form.getName();
        if (this.jsFormName.charAt(0) == '/') {
            String mappingName = TagUtils.getInstance().getActionMappingName(this.jsFormName);
            ActionMapping mapping = (ActionMapping)config.findActionConfig(mappingName);
            if (mapping == null) {
                JspException e = new JspException(messages.getMessage("formTag.mapping", (Object)mappingName));
                this.pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)e, 2);
                throw e;
            }
            this.jsFormName = mapping.getAttribute();
        }
        results.append(this.getJavascriptBegin(methods));
        for (ValidatorAction va : actions) {
            int jscriptVar = 0;
            String functionName = null;
            functionName = va.getJsFunctionName() != null && va.getJsFunctionName().length() > 0 ? va.getJsFunctionName() : va.getName();
            results.append("    function " + this.jsFormName + "_" + functionName + " () { \n");
            for (Field field : form.getFields()) {
                if (field.isIndexed() || field.getPage() != this.page || !field.isDependency(va.getName())) continue;
                String message = Resources.getMessage((ServletContext)application, (HttpServletRequest)request, (MessageResources)messages, (Locale)locale, (ValidatorAction)va, (Field)field);
                message = message != null ? message : "";
                results.append("     this.a" + jscriptVar++ + " = new Array(\"" + field.getKey() + "\", \"" + this.escapeQuotes(message) + "\", ");
                results.append("new Function (\"varName\", \"");
                Map vars = field.getVars();
                for (Map.Entry entry : vars.entrySet()) {
                    String varName = (String)entry.getKey();
                    Var var = (Var)entry.getValue();
                    String varValue = Resources.getVarValue((Var)var, (ServletContext)application, (HttpServletRequest)request, (boolean)false);
                    String jsType = var.getJsType();
                    if (varName.startsWith("field")) continue;
                    String varValueEscaped = this.escapeJavascript(varValue);
                    if ("int".equalsIgnoreCase(jsType)) {
                        results.append("this." + varName + "=" + varValueEscaped + "; ");
                        continue;
                    }
                    if ("regexp".equalsIgnoreCase(jsType)) {
                        results.append("this." + varName + "=/" + varValueEscaped + "/; ");
                        continue;
                    }
                    if ("string".equalsIgnoreCase(jsType)) {
                        results.append("this." + varName + "='" + varValueEscaped + "'; ");
                        continue;
                    }
                    if ("mask".equalsIgnoreCase(varName)) {
                        results.append("this." + varName + "=/" + varValueEscaped + "/; ");
                        continue;
                    }
                    results.append("this." + varName + "='" + varValueEscaped + "'; ");
                }
                results.append(" return this[varName];\"));\n");
            }
            results.append("    } \n\n");
        }
        return results.toString();
    }

    private String escapeQuotes(String in) {
        if (in == null || in.indexOf("\"") == -1) {
            return in;
        }
        StringBuilder buffer = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(in, "\"", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("\"")) {
                buffer.append("\\");
            }
            buffer.append(token);
        }
        return buffer.toString();
    }

    private String escapeJavascript(String str) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (length == 0) {
            return str;
        }
        StringBuilder out = new StringBuilder(length + 4);
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c == '\"' || c == '\'' || c == '\\' || c == '\n' || c == '\r') {
                out.append('\\');
            }
            out.append(c);
        }
        return out.toString();
    }

    private boolean stopOnError(ModuleConfig config) {
        Object stopOnErrorObj = this.pageContext.getAttribute("org.apache.struts.validator.STOP_ON_ERROR." + config.getPrefix(), 4);
        boolean stopOnError = true;
        if (stopOnErrorObj instanceof Boolean) {
            stopOnError = (Boolean)stopOnErrorObj;
        }
        return stopOnError;
    }

    private String createMethods(List<ValidatorAction> actions, boolean stopOnError) {
        StringBuilder methods = new StringBuilder();
        String methodOperator = stopOnError ? " && " : " & ";
        for (ValidatorAction va : actions) {
            if (methods.length() > 0) {
                methods.append(methodOperator);
            }
            methods.append(va.getMethod()).append("(form)");
        }
        return methods.toString();
    }

    private List<ValidatorAction> createActionList(ValidatorResources resources, Form form) {
        ArrayList<String> actionMethods = new ArrayList<String>();
        for (Field field : form.getFields()) {
            for (String depends : field.getDependencyList()) {
                if (depends == null || actionMethods.contains(depends)) continue;
                actionMethods.add(depends);
            }
        }
        ArrayList<ValidatorAction> actions = new ArrayList<ValidatorAction>();
        Iterator iterator = actionMethods.iterator();
        while (iterator.hasNext()) {
            String depends = (String)iterator.next();
            ValidatorAction va = resources.getValidatorAction(depends);
            if (va == null) {
                throw new NullPointerException("Depends string \"" + depends + "\" was not found in validator-rules.xml.");
            }
            if (va.getJavascript() != null && va.getJavascript().length() > 0) {
                actions.add(va);
                continue;
            }
            iterator.remove();
        }
        Collections.sort(actions, actionComparator);
        return actions;
    }

    public void release() {
        super.release();
        this.bundle = "org.apache.struts.action.MESSAGE";
        this.formName = null;
        this.jsFormName = null;
        this.page = 0;
        this.methodName = null;
        this.staticJavascript = "true";
        this.dynamicJavascript = "true";
        this.htmlComment = "true";
        this.cdata = "true";
        this.src = null;
    }

    protected String getJavascriptBegin(String methods) {
        StringBuilder sb = new StringBuilder();
        String name = this.jsFormName.replace('/', '_');
        name = this.jsFormName.substring(0, 1).toUpperCase() + this.jsFormName.substring(1, this.jsFormName.length());
        sb.append(this.renderStartElement());
        if (this.isXhtml() && "true".equalsIgnoreCase(this.cdata)) {
            sb.append("//<![CDATA[\r\n");
        }
        if (!this.isXhtml() && "true".equals(this.htmlComment)) {
            sb.append(HTML_BEGIN_COMMENT);
        }
        sb.append("\n    var bCancel = false; \n\n");
        if (this.methodName == null || this.methodName.length() == 0) {
            sb.append("    function validate" + name + "(form) { \n");
        } else {
            sb.append("    function " + this.methodName + "(form) { \n");
        }
        sb.append("        if (bCancel) { \n");
        sb.append("            return true; \n");
        sb.append("        } else { \n");
        if (methods == null || methods.length() == 0) {
            sb.append("            return true; \n");
        } else {
            sb.append("            var formValidationResult; \n");
            sb.append("            formValidationResult = " + methods + "; \n");
            if (methods.indexOf("&&") >= 0) {
                sb.append("            return (formValidationResult); \n");
            } else {
                sb.append("            return (formValidationResult == 1); \n");
            }
        }
        sb.append("        } \n");
        sb.append("    } \n\n");
        return sb.toString();
    }

    protected String getJavascriptStaticMethods(ValidatorResources resources) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n");
        for (ValidatorAction va : resources.getValidatorActions().values()) {
            String javascript;
            if (va == null || (javascript = va.getJavascript()) == null || javascript.length() <= 0) continue;
            sb.append(javascript + "\n");
        }
        return sb.toString();
    }

    protected String getJavascriptEnd() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        if (!this.isXhtml() && "true".equals(this.htmlComment)) {
            sb.append(HTML_END_COMMENT);
        }
        if (this.isXhtml() && "true".equalsIgnoreCase(this.cdata)) {
            sb.append("//]]>\r\n");
        }
        sb.append("</script>\n\n");
        return sb.toString();
    }

    protected String renderStartElement() {
        StringBuilder start = new StringBuilder("<script type=\"text/javascript\"");
        if (!this.isXhtml() && this.scriptLanguage) {
            start.append(" language=\"Javascript1.1\"");
        }
        if (this.src != null) {
            start.append(" src=\"" + this.src + "\"");
        }
        start.append("> \n");
        return start.toString();
    }

    private boolean isXhtml() {
        return TagUtils.getInstance().isXhtml(this.pageContext);
    }

    public String getCdata() {
        return this.cdata;
    }

    public void setCdata(String cdata) {
        this.cdata = cdata;
    }

    public boolean getScriptLanguage() {
        return this.scriptLanguage;
    }

    public void setScriptLanguage(boolean scriptLanguage) {
        this.scriptLanguage = scriptLanguage;
    }
}

