/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.html;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.TagSupport;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.util.MessageResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlTag
extends TagSupport {
    private static final long serialVersionUID = -4739352136106954707L;
    private final transient Logger log = LoggerFactory.getLogger(HtmlTag.class);
    protected static MessageResources messages = MessageResources.getMessageResources((String)"org.apache.struts.taglib.html.LocalStrings");
    protected boolean xhtml = false;
    private BigDecimal xhtmlVersion = TagUtils.XHTML_1_0;
    protected boolean lang = false;

    public boolean getXhtml() {
        return this.xhtml;
    }

    public void setXhtml(boolean xhtml) {
        this.xhtml = xhtml;
    }

    public String getXhtmlVersion() {
        return this.xhtmlVersion.toString();
    }

    public void setXhtmlVersion(String xhtmlVersion) {
        this.xhtmlVersion = xhtmlVersion != null ? new BigDecimal(xhtmlVersion) : TagUtils.XHTML_1_0;
    }

    public boolean getLang() {
        return this.lang;
    }

    public void setLang(boolean lang) {
        this.lang = lang;
    }

    public int doStartTag() throws JspException {
        TagUtils.getInstance().write(this.pageContext, this.renderHtmlStartElement());
        return 1;
    }

    protected String renderHtmlStartElement() {
        StringBuilder sb = new StringBuilder("<html");
        String language = null;
        String country = "";
        Locale currentLocale = TagUtils.getInstance().getUserLocale(this.pageContext, "org.apache.struts.action.LOCALE");
        language = currentLocale.getLanguage();
        country = currentLocale.getCountry();
        boolean validLanguage = this.isValidRfc2616(language);
        boolean validCountry = this.isValidRfc2616(country);
        if (this.xhtml) {
            this.pageContext.setAttribute("org.apache.struts.globals.XHTML", (Object)"true", 1);
            this.pageContext.setAttribute("org.apache.struts.globals.XHTML_VERSION", (Object)this.xhtmlVersion, 2);
            if (this.xhtmlVersion.equals(TagUtils.XHTML_1_1)) {
                sb.append(" xmlns=\"http://www.w3.org/1999/xhtml\"");
                sb.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
                sb.append(" xsi:schemaLocation=\"http://www.w3.org/MarkUp/SCHEMA/xhtml11.xsd\"");
            } else if (this.xhtmlVersion.equals(TagUtils.XHTML_2_0)) {
                sb.append(" xmlns=\"http://www.w3.org/2002/06/xhtml2/\"");
                sb.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
                sb.append(" xsi:schemaLocation=\"http://www.w3.org/2002/06/xhtml2/ http://www.w3.org/MarkUp/SCHEMA/xhtml2.xsd\"");
            } else if (this.xhtmlVersion.equals(TagUtils.XHTML_5_0)) {
                sb.append(" xmlns=\"http://www.w3.org/1999/xhtml\"");
            } else {
                if (!this.xhtmlVersion.equals(TagUtils.XHTML_1_0)) {
                    this.log.warn("Defaulting to XHTML 1.0. Unknown version: {}", (Object)this.xhtmlVersion);
                    this.xhtmlVersion = TagUtils.XHTML_1_0;
                }
                sb.append(" xmlns=\"http://www.w3.org/1999/xhtml\"");
            }
        }
        if (this.lang && validLanguage && (!this.xhtml || this.xhtmlVersion.compareTo(TagUtils.XHTML_1_1) < 0)) {
            sb.append(" lang=\"");
            sb.append(language);
            if (validCountry) {
                sb.append("-");
                sb.append(country);
            }
            sb.append("\"");
        }
        if (this.xhtml && validLanguage) {
            sb.append(" xml:lang=\"");
            sb.append(language);
            if (validCountry) {
                sb.append("-");
                sb.append(country);
            }
            sb.append("\"");
        }
        sb.append(">");
        return sb.toString();
    }

    public int doEndTag() throws JspException {
        TagUtils.getInstance().write(this.pageContext, "</html>");
        return 6;
    }

    public void release() {
        this.xhtml = false;
        this.lang = false;
    }

    private boolean isValidRfc2616(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isLetter(c) || c == '-') continue;
            return false;
        }
        return true;
    }
}

