/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.html;

import jakarta.servlet.jsp.JspException;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.taglib.html.BaseInputTag;

public abstract class BaseFieldTag
extends BaseInputTag {
    private static final long serialVersionUID = 6316491607452965571L;
    protected String accept = null;
    protected boolean redisplay = true;
    protected String type = null;

    public String getAccept() {
        return this.accept;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }

    public boolean getRedisplay() {
        return this.redisplay;
    }

    public void setRedisplay(boolean redisplay) {
        this.redisplay = redisplay;
    }

    @Override
    public int doStartTag() throws JspException {
        TagUtils.getInstance().write(this.pageContext, this.renderInputElement());
        return 2;
    }

    protected String renderInputElement() throws JspException {
        StringBuilder results = new StringBuilder("<input");
        this.prepareAttribute(results, "type", this.type);
        this.prepareAttribute(results, "name", this.prepareName());
        this.prepareAttribute(results, "accesskey", this.getAccesskey());
        this.prepareAttribute(results, "accept", this.getAccept());
        this.prepareAttribute(results, "maxlength", this.getMaxlength());
        this.prepareAttribute(results, "size", this.getCols());
        this.prepareAttribute(results, "tabindex", this.getTabindex());
        this.prepareValue(results);
        results.append(this.prepareEventHandlers());
        results.append(this.prepareStyles());
        if (!this.isXhtml()) {
            this.prepareAttribute(results, "autocomplete", this.getAutocomplete());
        }
        this.prepareOtherAttributes(results);
        results.append(this.getElementClose());
        return results.toString();
    }

    protected void prepareValue(StringBuilder results) throws JspException {
        results.append(" value=\"");
        if (this.value != null) {
            results.append(this.formatValue(this.value));
        } else if (this.redisplay || !"password".equals(this.type)) {
            Object value = TagUtils.getInstance().lookup(this.pageContext, this.name, this.property, null);
            results.append(this.formatValue(value));
        }
        results.append('\"');
    }

    protected String formatValue(Object value) throws JspException {
        if (value == null) {
            return "";
        }
        return TagUtils.getInstance().filter(value.toString());
    }

    @Override
    public void release() {
        super.release();
        this.accept = null;
        this.name = "org.apache.struts.taglib.html.BEAN";
        this.redisplay = true;
    }
}

