/*
 * Decompiled with CFR 0.152.
 */
package com.ahsay.pns.repository;

import com.ahsay.pns.entity.VerCode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class VerCodeRepository {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VerCode> findAll(Connection conn) throws SQLException {
        String sql = "Select id, phone, email, ver_code from ver_code";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        ArrayList<VerCode> verCodes = new ArrayList<VerCode>();
        try (ResultSet rs = null;){
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int idx = 1;
                long id = rs.getLong(idx++);
                String phone = rs.getString(idx++);
                String email = rs.getString(idx++);
                String verCode = rs.getString(idx++);
                verCodes.add(new VerCode(id, phone, email, verCode));
            }
        }
        return verCodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VerCode getOne(Connection conn, long id) throws SQLException {
        String sql = "Select id, phone, email, ver_code from ver_code where id = ?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setLong(1, id);
        try (ResultSet rs = null;){
            rs = pstmt.executeQuery();
            if (rs.next()) {
                int idx = 1;
                id = rs.getLong(idx++);
                String phone = rs.getString(idx++);
                String email = rs.getString(idx++);
                String verCode = rs.getString(idx++);
                VerCode verCode2 = new VerCode(id, phone, email, verCode);
                return verCode2;
            }
        }
        return null;
    }

    public static VerCode save(Connection conn, VerCode verCode) throws SQLException {
        VerCode newVerCode = null;
        newVerCode = verCode.getId() == null ? VerCodeRepository.insertVerCode(conn, verCode) : VerCodeRepository.updateVerCode(conn, verCode);
        return newVerCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VerCode insertVerCode(Connection conn, VerCode verCode) throws SQLException {
        String sql = "Insert into ver_code (phone, email, ver_code) Values (?, ?, ?)";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, verCode.getPhone());
        pstmt.setString(2, verCode.getEmail());
        pstmt.setString(3, verCode.getVerCode());
        int result = pstmt.executeUpdate();
        if (result > 0) {
            ResultSet rs = null;
            try {
                VerCode newVerCode;
                rs = pstmt.getGeneratedKeys();
                long id = rs.getLong(1);
                VerCode verCode2 = newVerCode = new VerCode(id, verCode.getPhone(), verCode.getEmail(), verCode.getVerCode());
                return verCode2;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                pstmt.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VerCode updateVerCode(Connection conn, VerCode verCode) throws SQLException {
        String sql = "Update ver_code Set phone = ?, email = ?, ver_code = ? Where id = ?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, verCode.getPhone());
        pstmt.setString(2, verCode.getEmail());
        pstmt.setString(3, verCode.getVerCode());
        pstmt.setLong(4, verCode.getId());
        int result = pstmt.executeUpdate();
        if (result > 0) {
            ResultSet rs = null;
            try {
                VerCode newVerCode;
                rs = pstmt.getGeneratedKeys();
                long id = rs.getLong(1);
                VerCode verCode2 = newVerCode = new VerCode(id, verCode.getPhone(), verCode.getEmail(), verCode.getVerCode());
                return verCode2;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                pstmt.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<VerCode> findByPhoneOrderByIdDesc(Connection conn, String phone) throws SQLException {
        String sql = "Select id, phone, email, ver_code from ver_code Where phone = ?";
        ArrayList<VerCode> verCodes = new ArrayList<VerCode>();
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, phone);
        ResultSet rs = null;
        try {
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int idx = 1;
                long id = rs.getLong(idx++);
                phone = rs.getString(idx++);
                String email = rs.getString(idx++);
                String verCode = rs.getString(idx++);
                verCodes.add(new VerCode(id, phone, email, verCode));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            pstmt.close();
        }
        return verCodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<VerCode> findByEmailOrderByIdDesc(Connection conn, String email) throws SQLException {
        String sql = "Select id, phone, email, ver_code from ver_code Where email = ?";
        ArrayList<VerCode> verCodes = new ArrayList<VerCode>();
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, email);
        ResultSet rs = null;
        try {
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int idx = 1;
                long id = rs.getLong(idx++);
                String phone = rs.getString(idx++);
                email = rs.getString(idx++);
                String verCode = rs.getString(idx++);
                verCodes.add(new VerCode(id, phone, email, verCode));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            pstmt.close();
        }
        return verCodes;
    }
}

