/*
 * Decompiled with CFR 0.152.
 */
package com.ahsay.pns.repository;

import com.ahsay.pns.entity.Recovery;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class RecoveryRepository {
    public static Recovery save(Connection conn, Recovery recovery) throws SQLException {
        Recovery newRecovery = null;
        newRecovery = recovery.getId() == null ? RecoveryRepository.insertRecovery(conn, recovery) : RecoveryRepository.updateRecovery(conn, recovery);
        return newRecovery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Recovery insertRecovery(Connection conn, Recovery recovery) throws SQLException {
        String sql = "Insert Into recovery (client_user_id, device_id, customer_id, phone) Values (?, ?, ?, ?)";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, recovery.getClientUserId());
        pstmt.setString(2, recovery.getDeviceId());
        pstmt.setString(3, recovery.getCustomerId());
        pstmt.setString(4, recovery.getPhone());
        int result = pstmt.executeUpdate();
        if (result > 0) {
            ResultSet rs = null;
            try {
                Recovery newRecovery;
                rs = pstmt.getGeneratedKeys();
                long id = rs.getLong(1);
                Recovery recovery2 = newRecovery = new Recovery(id, recovery.getClientUserId(), recovery.getDeviceId(), recovery.getCustomerId(), recovery.getPhone());
                return recovery2;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                pstmt.close();
            }
        }
        return null;
    }

    private static Recovery updateRecovery(Connection conn, Recovery recovery) throws SQLException {
        String sql = "Update recovery Set client_user_id = ?, device_id = ?, customer_id = ?, phone = ? Where id = ?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, recovery.getClientUserId());
        pstmt.setString(2, recovery.getDeviceId());
        pstmt.setString(3, recovery.getCustomerId());
        pstmt.setString(4, recovery.getPhone());
        pstmt.setLong(4, recovery.getId());
        int result = pstmt.executeUpdate();
        if (result > 0) {
            return recovery;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Recovery> findByClientUserIdAndDeviceIdAndCustomerId(Connection conn, String clientUserId, String deviceId, String customerId) throws SQLException {
        String sql = "Select id, client_user_id, device_id, customer_id, phone From recovery Where client_user_id = ? and device_id = ? and customer_id = ?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, clientUserId);
        pstmt.setString(2, deviceId);
        pstmt.setString(3, customerId);
        ArrayList<Recovery> recoveries = new ArrayList<Recovery>();
        try (ResultSet rs = null;){
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int idx = 1;
                long id = rs.getLong(idx++);
                clientUserId = rs.getString(idx++);
                deviceId = rs.getString(idx++);
                customerId = rs.getString(idx++);
                String phone = rs.getString(idx++);
                recoveries.add(new Recovery(id, clientUserId, deviceId, customerId, phone));
            }
        }
        return recoveries;
    }
}

