/*
 * Decompiled with CFR 0.152.
 */
package com.ahsay.pns.repository;

import com.ahsay.pns.entity.PromoToken;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PromoTokenRepository {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PromoToken> findAll(Connection conn) throws SQLException {
        String sql = "Select id, customer_id, device_id, device_token, platform From promo_token";
        ArrayList<PromoToken> tokens = new ArrayList<PromoToken>();
        ResultSet rs = null;
        PreparedStatement pstmt = conn.prepareStatement(sql);
        try {
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int idx = 1;
                long id = rs.getLong(idx++);
                String customerId = rs.getString(idx++);
                String deviceId = rs.getString(idx++);
                String deviceToken = rs.getString(idx++);
                String platform = rs.getString(idx++);
                tokens.add(new PromoToken(id, customerId, deviceId, deviceToken, platform));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            pstmt.close();
        }
        return tokens;
    }

    public static PromoToken save(Connection conn, PromoToken token) throws SQLException {
        PromoToken newPromoToken = null;
        newPromoToken = token.getId() == 0L ? PromoTokenRepository.insertPromoToken(conn, token) : PromoTokenRepository.updatePromoToken(conn, token);
        return newPromoToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PromoToken insertPromoToken(Connection conn, PromoToken token) throws SQLException {
        String sql = "Insert into promo_token (customer_id, device_id, device_token, platform) Values (?, ?, ?, ?)";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, token.getCustomerId());
        pstmt.setString(2, token.getDeviceId());
        pstmt.setString(3, token.getDeviceToken());
        pstmt.setString(4, token.getPlatform());
        int result = pstmt.executeUpdate();
        if (result > 1) {
            try (ResultSet rs = null;){
                PromoToken savedToken;
                rs = pstmt.getGeneratedKeys();
                long id = rs.getLong(1);
                PromoToken promoToken = savedToken = new PromoToken(id, token.getCustomerId(), token.getDeviceId(), token.getDeviceToken(), token.getPlatform());
                return promoToken;
            }
        }
        return null;
    }

    public static PromoToken updatePromoToken(Connection conn, PromoToken token) throws SQLException {
        String sql = "Update promo_token Set customer_id = ?, device_id = ?, device_token = ?, platform = ? Where id = ?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, token.getCustomerId());
        pstmt.setString(2, token.getDeviceId());
        pstmt.setString(3, token.getDeviceToken());
        pstmt.setString(4, token.getPlatform());
        pstmt.setLong(5, token.getId());
        int result = pstmt.executeUpdate();
        if (result >= 1) {
            return token;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PromoToken> findByCustomerIdAndDeviceId(Connection conn, String customerId, String deviceId) throws SQLException {
        String sql = "Select id, customer_id, device_id, device_token, platform From promo_token where customer_id = ? And device_Id = ?";
        ArrayList<PromoToken> tokens = new ArrayList<PromoToken>();
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, customerId);
        pstmt.setString(2, deviceId);
        ResultSet rs = null;
        try {
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int idx = 1;
                long id = rs.getLong(idx++);
                customerId = rs.getString(idx++);
                deviceId = rs.getString(idx++);
                String deviceToken = rs.getString(idx++);
                String platform = rs.getString(idx++);
                tokens.add(new PromoToken(id, customerId, deviceId, deviceToken, platform));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            pstmt.close();
        }
        return tokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PromoToken> findByCustomerId(Connection conn, String customerId) throws SQLException {
        String sql = "Select id, customer_id, device_id, device_token, platform From promo_token where customer_id = ?";
        ArrayList<PromoToken> tokens = new ArrayList<PromoToken>();
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, customerId);
        ResultSet rs = null;
        try {
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int idx = 1;
                long id = rs.getLong(idx++);
                customerId = rs.getString(idx++);
                String deviceId = rs.getString(idx++);
                String deviceToken = rs.getString(idx++);
                String platform = rs.getString(idx++);
                tokens.add(new PromoToken(id, customerId, deviceId, deviceToken, platform));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            pstmt.close();
        }
        return tokens;
    }
}

