/*
 * Decompiled with CFR 0.152.
 */
package com.ahsay.pns.repository;

import com.ahsay.pns.entity.Lang;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class LangRepository {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Lang> findAll(Connection conn) throws SQLException {
        String sql = "Select id, device_id, lang From lang";
        ArrayList<Lang> langs = new ArrayList<Lang>();
        PreparedStatement pstmt = conn.prepareStatement(sql);
        ResultSet rs = null;
        try {
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int idx = 1;
                long id = rs.getLong(idx++);
                String deviceId = rs.getString(idx++);
                String lang = rs.getString(idx++);
                langs.add(new Lang(id, deviceId, lang));
            }
        }
        finally {
            pstmt.close();
            if (rs != null) {
                rs.close();
            }
        }
        return langs;
    }

    public static Lang save(Connection conn, Lang lang) throws SQLException {
        Lang newLang = null;
        newLang = lang.getId() == null ? LangRepository.insertLang(conn, lang) : LangRepository.updateLang(conn, lang);
        return newLang;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lang insertLang(Connection conn, Lang lang) throws SQLException {
        String sql = "Insert into lang (device_id, lang) Values (?, ?)";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, lang.getDeviceId());
        pstmt.setString(2, lang.getLang());
        int result = pstmt.executeUpdate();
        if (result > 1) {
            try (ResultSet rs = null;){
                rs = pstmt.getGeneratedKeys();
                long generatedId = rs.getLong(1);
                Lang lang2 = new Lang(generatedId, lang.getDeviceId(), lang.getLang());
                return lang2;
            }
        }
        return null;
    }

    public static Lang updateLang(Connection conn, Lang lang) throws SQLException {
        String sql = "Update lang (device_id, lang) Values (?, ?) Where id = ?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, lang.getDeviceId());
        pstmt.setString(2, lang.getLang());
        pstmt.setLong(3, lang.getId());
        int result = pstmt.executeUpdate();
        if (result >= 1) {
            return lang;
        }
        return null;
    }

    public static void deleteAll(Connection conn, Long[] langIds) throws SQLException {
        for (Long lId : langIds) {
            String sql = "Delete From lang Where id in (?)";
            PreparedStatement pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, lId.intValue());
            int n = pstmt.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lang getOne(Connection conn, long id) throws SQLException {
        String sql = "Select id, device_id, lang From lang Where id = ?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setLong(1, id);
        ResultSet rs = null;
        try {
            rs = pstmt.executeQuery();
            if (rs.next()) {
                int idx = 1;
                id = rs.getLong(idx++);
                String deviceId = rs.getString(idx++);
                String lang = rs.getString(idx++);
                Lang lang2 = new Lang(id, deviceId, lang);
                return lang2;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            pstmt.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Lang> findByDeviceId(Connection conn, String deviceId) throws SQLException {
        String sql = "Select id, device_id, lang From lang Where device_id = ?";
        ArrayList<Lang> langs = new ArrayList<Lang>();
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, deviceId);
        ResultSet rs = null;
        try {
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int idx = 1;
                long id = rs.getLong(idx++);
                deviceId = rs.getString(idx++);
                String lang = rs.getString(idx++);
                langs.add(new Lang(id, deviceId, lang));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            pstmt.close();
        }
        return langs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Lang> findByLang(Connection conn, String lang) throws SQLException {
        String sql = "Select id, device_id, lang From lang Where lang = ?";
        ArrayList<Lang> langs = new ArrayList<Lang>();
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, lang);
        ResultSet rs = null;
        try {
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int idx = 1;
                long id = rs.getLong(idx++);
                String deviceId = rs.getString(idx++);
                lang = rs.getString(idx++);
                langs.add(new Lang(id, deviceId, lang));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            pstmt.close();
        }
        return langs;
    }
}

