/*
 * Decompiled with CFR 0.152.
 */
package com.ahsay.pns.repository;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import org.sqlite.util.OSInfo;

public class DbConnection {
    private static Connection conn = null;
    private static boolean bStandlone = false;

    public static void init() {
        try {
            DbConnection.openDbConnection();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static synchronized Connection getConnection() {
        if (conn == null) {
            conn = DbConnection.openDbConnection();
        }
        return conn;
    }

    private static File getDbDir() {
        File fPns = bStandlone ? new File(System.getProperty("catalina.base")) : new File(System.getProperty("catalina.base"), "pns");
        File fDb = new File(fPns, "db");
        if (!fDb.exists()) {
            fDb.mkdirs();
        }
        return fDb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Connection openDbConnection() {
        try {
            System.out.println("[openDbConnection]" + new Date() + " " + Class.forName("org.sqlite.JDBC").getName());
            File fDb = new File(DbConnection.getDbDir(), "pns.db");
            String sDbPath = fDb.getCanonicalPath();
            sDbPath = "jdbc:sqlite:" + sDbPath;
            if (!fDb.exists()) {
                File fParent = fDb.getParentFile();
                if (!fParent.exists()) {
                    fParent.mkdirs();
                }
                conn = DriverManager.getConnection(sDbPath);
                String sSql = "CREATE TABLE lang (id INTEGER PRIMARY KEY AUTOINCREMENT, device_id varchar, lang varchar)";
                try (Statement stmt = conn.createStatement();){
                    stmt.execute(sSql);
                    sSql = "CREATE TABLE promo_token (id INTEGER PRIMARY KEY AUTOINCREMENT, customer_id varchar, device_id varchar, device_token varchar, platform varchar)";
                    stmt.execute(sSql);
                    sSql = "CREATE TABLE recovery (id INTEGER PRIMARY KEY AUTOINCREMENT, client_user_id varchar, customer_id varchar, device_id varchar, phone varchar)";
                    stmt.execute(sSql);
                    sSql = "CREATE TABLE sms_usage (id INTEGER PRIMARY KEY AUTOINCREMENT, create_time bigint, ip_addr varchar, license varchar, owner varchar, phone varchar, result integer, username varchar)";
                    stmt.execute(sSql);
                    sSql = "CREATE TABLE ver_code (id INTEGER PRIMARY KEY AUTOINCREMENT, email varchar, phone varchar, ver_code varchar)";
                    stmt.execute(sSql);
                    sSql = "CREATE TABLE user (id INTEGER PRIMARY KEY AUTOINCREMENT, account_order bigint, client_type integer not null, client_user_id varchar, device_id varchar, device_name varchar, device_token varchar, email varchar, manufacturer varchar, phone varchar, platform varchar, session_token varchar, status integer not null, totp_token varchar, totp_token_gendt bigint not null, version varchar, customer_id varchar, username varchar)";
                    stmt.execute(sSql);
                }
            } else {
                conn = DriverManager.getConnection(sDbPath);
                DbConnection.checkNewColumn(conn);
                DbConnection.checkMigrateColumn(conn, "user", "CREATE TABLE user (id INTEGER PRIMARY KEY AUTOINCREMENT, account_order bigint, client_type integer not null, client_user_id varchar, device_id varchar, device_name varchar, device_token varchar, email varchar, manufacturer varchar, phone varchar, platform varchar, session_token varchar, status integer not null, totp_token varchar, totp_token_gendt bigint not null, version varchar, customer_id varchar, username varchar)");
                DbConnection.checkMigrateColumn(conn, "lang", "CREATE TABLE lang (id INTEGER PRIMARY KEY AUTOINCREMENT, device_id varchar, lang varchar)");
                DbConnection.checkMigrateColumn(conn, "promo_token", "CREATE TABLE promo_token (id INTEGER PRIMARY KEY AUTOINCREMENT, customer_id varchar, device_id varchar, device_token varchar, platform varchar)");
                DbConnection.checkMigrateColumn(conn, "recovery", "CREATE TABLE recovery (id INTEGER PRIMARY KEY AUTOINCREMENT, client_user_id varchar, customer_id varchar, device_id varchar, phone varchar)");
                DbConnection.checkMigrateColumn(conn, "sms_usage", "CREATE TABLE sms_usage (id INTEGER PRIMARY KEY AUTOINCREMENT, create_time bigint, ip_addr varchar, license varchar, owner varchar, phone varchar, result integer, username varchar)");
                DbConnection.checkMigrateColumn(conn, "ver_code", "CREATE TABLE ver_code (id INTEGER PRIMARY KEY AUTOINCREMENT, email varchar, phone varchar, ver_code varchar)");
            }
            return conn;
        }
        catch (Exception e) {
            System.out.println("[openDbConnection]" + new Date() + " Error: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static void setLibraryPath() {
        String sLibPaths = System.getProperty("java.library.path");
        String[] alLibPath = DbConnection.stringSplit(sLibPaths, File.pathSeparator);
        if (alLibPath != null && alLibPath.length > 0) {
            for (String sLibPath : alLibPath) {
                String sLibraryPath = DbConnection.getLibraryPath(sLibPath);
                if (new File(sLibraryPath).exists()) {
                    System.setProperty("org.sqlite.lib.path", sLibraryPath);
                    break;
                }
                if (new File(sLibPath, DbConnection.getMappedLibraryName("sqlitejdbc")).exists()) {
                    System.setProperty("org.sqlite.lib.path", sLibPath);
                    break;
                }
                System.out.println(" [setLibraryPath] library path " + new File(sLibPath, DbConnection.getMappedLibraryName("sqlitejdbc")).getPath() + " does not exist");
            }
        }
    }

    private static final String[] stringSplit(String sWhole, String sSplitPattern) {
        Vector<String> vTmp = new Vector<String>(16, 16);
        int iLastIdx = 0;
        int iNextIdx = 0;
        if (sWhole == null || sSplitPattern == null || sSplitPattern.equals("")) {
            String[] asOneElement = new String[]{sWhole};
            return asOneElement;
        }
        while ((iNextIdx = sWhole.indexOf(sSplitPattern, iLastIdx)) != -1) {
            vTmp.addElement(sWhole.substring(iLastIdx, iNextIdx));
            iLastIdx = iNextIdx + sSplitPattern.length();
        }
        vTmp.addElement(sWhole.substring(iLastIdx));
        String[] asElement = new String[vTmp.size()];
        for (int i = 0; i < vTmp.size(); ++i) {
            asElement[i] = (String)vTmp.elementAt(i);
        }
        return asElement;
    }

    public static String getLibraryPath(String sLibPath) {
        return sLibPath + File.separator + "sqlite" + File.separator + OSInfo.getOSName() + File.separator + OSInfo.getArchName();
    }

    public static String getMappedLibraryName(String sLibName) {
        String sMappedLibName = System.mapLibraryName(sLibName);
        if (sMappedLibName != null && sMappedLibName.endsWith(".dylib")) {
            sMappedLibName = sMappedLibName.replace(".dylib", ".jnilib");
        }
        return sMappedLibName;
    }

    public static void closeAllDbConnection() {
        try {
            conn.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void checkNewColumn(Connection conn) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkColumnExists(Connection conn, String sTable, String sColumn) throws SQLException {
        String sSql = "SELECT COUNT(*) FROM pragma_table_info('" + sTable + "') WHERE name='" + sColumn + "'";
        boolean bExists = false;
        try (Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery(sSql);
            while (rs.next()) {
                if (rs.getInt(1) != 1) continue;
                bExists = true;
                break;
            }
        }
        return bExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addColumn(Connection conn, String sTable, String sNewColumn, String sValueColumn) throws SQLException {
        int iResult;
        String sSql = "ALTER TABLE " + sTable + " ADD COLUMN " + sNewColumn + " TEXT";
        try (Statement stmt = conn.createStatement();){
            iResult = stmt.executeUpdate(sSql);
            System.out.println("result = " + iResult);
        }
        if (sValueColumn != null && !sValueColumn.isEmpty()) {
            sSql = "UPDATE " + sTable + " SET " + sNewColumn + " = " + sValueColumn;
            stmt = conn.createStatement();
            try {
                iResult = stmt.executeUpdate(sSql);
                System.out.println("result = " + iResult);
            }
            finally {
                stmt.close();
            }
        }
    }

    private static void migrateTable(Connection conn, String sTableName, String sCreateQuery) throws SQLException {
        Statement stmt = conn.createStatement();
        String sTmpTableName = sTableName + "_TMP";
        String sCol = sCreateQuery.substring(sCreateQuery.indexOf("(") + 1, sCreateQuery.indexOf(")") - 1);
        String[] asCol = sCol.split(",");
        String sAllColName = "";
        for (int i = 0; i < asCol.length; ++i) {
            if (!sAllColName.isEmpty()) {
                sAllColName = sAllColName + ",";
            }
            sAllColName = sAllColName + asCol[i].trim().split(" ")[0];
        }
        String sTmpCreateQuery = sCreateQuery.replace("CREATE TABLE " + sTableName + " (", "CREATE TABLE " + sTmpTableName + " (");
        stmt.execute(sTmpCreateQuery);
        stmt.execute("insert into " + sTmpTableName + "(" + sAllColName + ") select " + sAllColName + " from  " + sTableName);
        stmt.execute("drop table " + sTableName);
        stmt.execute("alter table " + sTmpTableName + " rename to " + sTableName);
    }

    private static void checkMigrateColumn(Connection conn, String sTableName, String sCreateQuery) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet res = stmt.executeQuery("select ID from " + sTableName + "  limit 1");
        ResultSetMetaData rsmd = res.getMetaData();
        int iColType = rsmd.getColumnType(1);
        res.close();
        stmt.close();
        if (iColType != 4) {
            DbConnection.migrateTable(conn, sTableName, sCreateQuery);
        }
    }

    public static void main(String[] args) {
        try {
            System.out.println("[openDbConnection]" + new Date() + " " + Class.forName("org.sqlite.JDBC").getName());
            File fDb = new File("D:\\Departments\\MOB\\Alan\\pns.db");
            String sDbPath = fDb.getCanonicalPath();
            sDbPath = "jdbc:sqlite:" + sDbPath;
            conn = DriverManager.getConnection(sDbPath);
            DbConnection.checkMigrateColumn(conn, "user", "CREATE TABLE user (id INTEGER PRIMARY KEY AUTOINCREMENT, account_order bigint, client_type integer not null, client_user_id varchar, device_id varchar, device_name varchar, device_token varchar, email varchar, manufacturer varchar, phone varchar, platform varchar, session_token varchar, status integer not null, totp_token varchar, totp_token_gendt bigint not null, version varchar, customer_id varchar, username varchar)");
            DbConnection.checkMigrateColumn(conn, "lang", "CREATE TABLE lang (id INTEGER PRIMARY KEY AUTOINCREMENT, device_id varchar, lang varchar)");
            DbConnection.checkMigrateColumn(conn, "promo_token", "CREATE TABLE promo_token (id INTEGER PRIMARY KEY AUTOINCREMENT, customer_id varchar, device_id varchar, device_token varchar, platform varchar)");
            DbConnection.checkMigrateColumn(conn, "recovery", "CREATE TABLE recovery (id INTEGER PRIMARY KEY AUTOINCREMENT, client_user_id varchar, customer_id varchar, device_id varchar, phone varchar)");
            DbConnection.checkMigrateColumn(conn, "sms_usage", "CREATE TABLE sms_usage (id INTEGER PRIMARY KEY AUTOINCREMENT, create_time bigint, ip_addr varchar, license varchar, owner varchar, phone varchar, result integer, username varchar)");
            DbConnection.checkMigrateColumn(conn, "ver_code", "CREATE TABLE ver_code (id INTEGER PRIMARY KEY AUTOINCREMENT, email varchar, phone varchar, ver_code varchar)");
            conn.close();
        }
        catch (Exception e) {
            System.out.println("[openDbConnection]" + new Date() + " Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            File fCatalinaBase = new File(System.getProperty("catalina.base"));
            File fPnsProps = new File(new File(fCatalinaBase, "conf"), "application.properties");
            if (fPnsProps.exists()) {
                Properties props = new Properties();
                try {
                    try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(fPnsProps));){
                        props.load(is);
                    }
                    if ("standalone".equals(props.getProperty("spring.profiles.active"))) {
                        bStandlone = true;
                    }
                }
                catch (IOException e) {
                    System.out.println("[DbConnection] Fail to load properties from " + fPnsProps.getAbsolutePath() + " Reason=" + e.getMessage());
                }
            }
            DbConnection.setLibraryPath();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

