/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.keyvault.models.AccessPolicyEntry;
import com.azure.resourcemanager.keyvault.models.CreateMode;
import com.azure.resourcemanager.keyvault.models.NetworkRuleSet;
import com.azure.resourcemanager.keyvault.models.Sku;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.UUID;

public final class VaultPatchProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VaultPatchProperties.class);
    @JsonProperty(value="tenantId")
    private UUID tenantId;
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="accessPolicies")
    private List<AccessPolicyEntry> accessPolicies;
    @JsonProperty(value="enabledForDeployment")
    private Boolean enabledForDeployment;
    @JsonProperty(value="enabledForDiskEncryption")
    private Boolean enabledForDiskEncryption;
    @JsonProperty(value="enabledForTemplateDeployment")
    private Boolean enabledForTemplateDeployment;
    @JsonProperty(value="enableSoftDelete")
    private Boolean enableSoftDelete;
    @JsonProperty(value="enableRbacAuthorization")
    private Boolean enableRbacAuthorization;
    @JsonProperty(value="softDeleteRetentionInDays")
    private Integer softDeleteRetentionInDays;
    @JsonProperty(value="createMode")
    private CreateMode createMode;
    @JsonProperty(value="enablePurgeProtection")
    private Boolean enablePurgeProtection;
    @JsonProperty(value="networkAcls")
    private NetworkRuleSet networkAcls;

    public UUID tenantId() {
        return this.tenantId;
    }

    public VaultPatchProperties withTenantId(UUID tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public VaultPatchProperties withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public List<AccessPolicyEntry> accessPolicies() {
        return this.accessPolicies;
    }

    public VaultPatchProperties withAccessPolicies(List<AccessPolicyEntry> accessPolicies) {
        this.accessPolicies = accessPolicies;
        return this;
    }

    public Boolean enabledForDeployment() {
        return this.enabledForDeployment;
    }

    public VaultPatchProperties withEnabledForDeployment(Boolean enabledForDeployment) {
        this.enabledForDeployment = enabledForDeployment;
        return this;
    }

    public Boolean enabledForDiskEncryption() {
        return this.enabledForDiskEncryption;
    }

    public VaultPatchProperties withEnabledForDiskEncryption(Boolean enabledForDiskEncryption) {
        this.enabledForDiskEncryption = enabledForDiskEncryption;
        return this;
    }

    public Boolean enabledForTemplateDeployment() {
        return this.enabledForTemplateDeployment;
    }

    public VaultPatchProperties withEnabledForTemplateDeployment(Boolean enabledForTemplateDeployment) {
        this.enabledForTemplateDeployment = enabledForTemplateDeployment;
        return this;
    }

    public Boolean enableSoftDelete() {
        return this.enableSoftDelete;
    }

    public VaultPatchProperties withEnableSoftDelete(Boolean enableSoftDelete) {
        this.enableSoftDelete = enableSoftDelete;
        return this;
    }

    public Boolean enableRbacAuthorization() {
        return this.enableRbacAuthorization;
    }

    public VaultPatchProperties withEnableRbacAuthorization(Boolean enableRbacAuthorization) {
        this.enableRbacAuthorization = enableRbacAuthorization;
        return this;
    }

    public Integer softDeleteRetentionInDays() {
        return this.softDeleteRetentionInDays;
    }

    public VaultPatchProperties withSoftDeleteRetentionInDays(Integer softDeleteRetentionInDays) {
        this.softDeleteRetentionInDays = softDeleteRetentionInDays;
        return this;
    }

    public CreateMode createMode() {
        return this.createMode;
    }

    public VaultPatchProperties withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public Boolean enablePurgeProtection() {
        return this.enablePurgeProtection;
    }

    public VaultPatchProperties withEnablePurgeProtection(Boolean enablePurgeProtection) {
        this.enablePurgeProtection = enablePurgeProtection;
        return this;
    }

    public NetworkRuleSet networkAcls() {
        return this.networkAcls;
    }

    public VaultPatchProperties withNetworkAcls(NetworkRuleSet networkAcls) {
        this.networkAcls = networkAcls;
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.accessPolicies() != null) {
            this.accessPolicies().forEach(e -> e.validate());
        }
        if (this.networkAcls() != null) {
            this.networkAcls().validate();
        }
    }
}

