/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.redis.models.SkuFamily;
import com.azure.resourcemanager.redis.models.SkuName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class Sku {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(Sku.class);
    @JsonProperty(value="name", required=true)
    private SkuName name;
    @JsonProperty(value="family", required=true)
    private SkuFamily family;
    @JsonProperty(value="capacity", required=true)
    private int capacity;

    public SkuName name() {
        return this.name;
    }

    public Sku withName(SkuName name) {
        this.name = name;
        return this;
    }

    public SkuFamily family() {
        return this.family;
    }

    public Sku withFamily(SkuFamily family) {
        this.family = family;
        return this;
    }

    public int capacity() {
        return this.capacity;
    }

    public Sku withCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model Sku"));
        }
        if (this.family() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property family in model Sku"));
        }
    }
}

