/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.redis.fluent.models.RedisLinkedServerCreateProperties;
import com.azure.resourcemanager.redis.models.ReplicationRole;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class RedisLinkedServerCreateParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RedisLinkedServerCreateParameters.class);
    @JsonProperty(value="properties", required=true)
    private RedisLinkedServerCreateProperties innerProperties = new RedisLinkedServerCreateProperties();

    private RedisLinkedServerCreateProperties innerProperties() {
        return this.innerProperties;
    }

    public String linkedRedisCacheId() {
        return this.innerProperties() == null ? null : this.innerProperties().linkedRedisCacheId();
    }

    public RedisLinkedServerCreateParameters withLinkedRedisCacheId(String linkedRedisCacheId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisLinkedServerCreateProperties();
        }
        this.innerProperties().withLinkedRedisCacheId(linkedRedisCacheId);
        return this;
    }

    public String linkedRedisCacheLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().linkedRedisCacheLocation();
    }

    public RedisLinkedServerCreateParameters withLinkedRedisCacheLocation(String linkedRedisCacheLocation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisLinkedServerCreateProperties();
        }
        this.innerProperties().withLinkedRedisCacheLocation(linkedRedisCacheLocation);
        return this;
    }

    public ReplicationRole serverRole() {
        return this.innerProperties() == null ? null : this.innerProperties().serverRole();
    }

    public RedisLinkedServerCreateParameters withServerRole(ReplicationRole serverRole) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisLinkedServerCreateProperties();
        }
        this.innerProperties().withServerRole(serverRole);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model RedisLinkedServerCreateParameters"));
        }
        this.innerProperties().validate();
    }
}

