/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.redis.fluent.models.RedisCreateProperties;
import com.azure.resourcemanager.redis.models.PublicNetworkAccess;
import com.azure.resourcemanager.redis.models.Sku;
import com.azure.resourcemanager.redis.models.TlsVersion;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class RedisCreateParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RedisCreateParameters.class);
    @JsonProperty(value="properties", required=true)
    private RedisCreateProperties innerProperties = new RedisCreateProperties();
    @JsonProperty(value="zones")
    private List<String> zones;
    @JsonProperty(value="location", required=true)
    private String location;
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;

    private RedisCreateProperties innerProperties() {
        return this.innerProperties;
    }

    public List<String> zones() {
        return this.zones;
    }

    public RedisCreateParameters withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public String location() {
        return this.location;
    }

    public RedisCreateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public RedisCreateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Sku sku() {
        return this.innerProperties() == null ? null : this.innerProperties().sku();
    }

    public RedisCreateParameters withSku(Sku sku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withSku(sku);
        return this;
    }

    public String subnetId() {
        return this.innerProperties() == null ? null : this.innerProperties().subnetId();
    }

    public RedisCreateParameters withSubnetId(String subnetId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withSubnetId(subnetId);
        return this;
    }

    public String staticIp() {
        return this.innerProperties() == null ? null : this.innerProperties().staticIp();
    }

    public RedisCreateParameters withStaticIp(String staticIp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withStaticIp(staticIp);
        return this;
    }

    public Map<String, String> redisConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().redisConfiguration();
    }

    public RedisCreateParameters withRedisConfiguration(Map<String, String> redisConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withRedisConfiguration((Map)redisConfiguration);
        return this;
    }

    public String redisVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().redisVersion();
    }

    public RedisCreateParameters withRedisVersion(String redisVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withRedisVersion(redisVersion);
        return this;
    }

    public Boolean enableNonSslPort() {
        return this.innerProperties() == null ? null : this.innerProperties().enableNonSslPort();
    }

    public RedisCreateParameters withEnableNonSslPort(Boolean enableNonSslPort) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withEnableNonSslPort(enableNonSslPort);
        return this;
    }

    public Integer replicasPerMaster() {
        return this.innerProperties() == null ? null : this.innerProperties().replicasPerMaster();
    }

    public RedisCreateParameters withReplicasPerMaster(Integer replicasPerMaster) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withReplicasPerMaster(replicasPerMaster);
        return this;
    }

    public Integer replicasPerPrimary() {
        return this.innerProperties() == null ? null : this.innerProperties().replicasPerPrimary();
    }

    public RedisCreateParameters withReplicasPerPrimary(Integer replicasPerPrimary) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withReplicasPerPrimary(replicasPerPrimary);
        return this;
    }

    public Map<String, String> tenantSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().tenantSettings();
    }

    public RedisCreateParameters withTenantSettings(Map<String, String> tenantSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withTenantSettings((Map)tenantSettings);
        return this;
    }

    public Integer shardCount() {
        return this.innerProperties() == null ? null : this.innerProperties().shardCount();
    }

    public RedisCreateParameters withShardCount(Integer shardCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withShardCount(shardCount);
        return this;
    }

    public TlsVersion minimumTlsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minimumTlsVersion();
    }

    public RedisCreateParameters withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withMinimumTlsVersion(minimumTlsVersion);
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public RedisCreateParameters withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model RedisCreateParameters"));
        }
        this.innerProperties().validate();
        if (this.location() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property location in model RedisCreateParameters"));
        }
    }
}

