/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.PrivateLinkServiceConnectionProperties;
import com.azure.resourcemanager.network.models.PrivateLinkServiceConnectionState;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class PrivateLinkServiceConnection
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(PrivateLinkServiceConnection.class);
    @JsonProperty(value="properties")
    private PrivateLinkServiceConnectionProperties innerProperties;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;

    private PrivateLinkServiceConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public PrivateLinkServiceConnection withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String etag() {
        return this.etag;
    }

    public PrivateLinkServiceConnection withId(String id) {
        super.withId(id);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String privateLinkServiceId() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkServiceId();
    }

    public PrivateLinkServiceConnection withPrivateLinkServiceId(String privateLinkServiceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateLinkServiceConnectionProperties();
        }
        this.innerProperties().withPrivateLinkServiceId(privateLinkServiceId);
        return this;
    }

    public List<String> groupIds() {
        return this.innerProperties() == null ? null : this.innerProperties().groupIds();
    }

    public PrivateLinkServiceConnection withGroupIds(List<String> groupIds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateLinkServiceConnectionProperties();
        }
        this.innerProperties().withGroupIds(groupIds);
        return this;
    }

    public String requestMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().requestMessage();
    }

    public PrivateLinkServiceConnection withRequestMessage(String requestMessage) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateLinkServiceConnectionProperties();
        }
        this.innerProperties().withRequestMessage(requestMessage);
        return this;
    }

    public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkServiceConnectionState();
    }

    public PrivateLinkServiceConnection withPrivateLinkServiceConnectionState(PrivateLinkServiceConnectionState privateLinkServiceConnectionState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateLinkServiceConnectionProperties();
        }
        this.innerProperties().withPrivateLinkServiceConnectionState(privateLinkServiceConnectionState);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

