/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.VirtualRouterPropertiesFormat;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class VirtualRouterInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualRouterInner.class);
    @JsonProperty(value="properties")
    private VirtualRouterPropertiesFormat innerProperties;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="id")
    private String id;

    private VirtualRouterPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public VirtualRouterInner withId(String id) {
        this.id = id;
        return this;
    }

    public VirtualRouterInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VirtualRouterInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Long virtualRouterAsn() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualRouterAsn();
    }

    public VirtualRouterInner withVirtualRouterAsn(Long virtualRouterAsn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualRouterPropertiesFormat();
        }
        this.innerProperties().withVirtualRouterAsn(virtualRouterAsn);
        return this;
    }

    public List<String> virtualRouterIps() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualRouterIps();
    }

    public VirtualRouterInner withVirtualRouterIps(List<String> virtualRouterIps) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualRouterPropertiesFormat();
        }
        this.innerProperties().withVirtualRouterIps(virtualRouterIps);
        return this;
    }

    public SubResource hostedSubnet() {
        return this.innerProperties() == null ? null : this.innerProperties().hostedSubnet();
    }

    public VirtualRouterInner withHostedSubnet(SubResource hostedSubnet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualRouterPropertiesFormat();
        }
        this.innerProperties().withHostedSubnet(hostedSubnet);
        return this;
    }

    public SubResource hostedGateway() {
        return this.innerProperties() == null ? null : this.innerProperties().hostedGateway();
    }

    public VirtualRouterInner withHostedGateway(SubResource hostedGateway) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualRouterPropertiesFormat();
        }
        this.innerProperties().withHostedGateway(hostedGateway);
        return this;
    }

    public List<SubResource> peerings() {
        return this.innerProperties() == null ? null : this.innerProperties().peerings();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

