/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualApplianceNicProperties;
import com.azure.resourcemanager.network.models.VirtualApplianceSkuProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class NetworkVirtualAppliancePropertiesFormat {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(NetworkVirtualAppliancePropertiesFormat.class);
    @JsonProperty(value="nvaSku")
    private VirtualApplianceSkuProperties nvaSku;
    @JsonProperty(value="addressPrefix", access=JsonProperty.Access.WRITE_ONLY)
    private String addressPrefix;
    @JsonProperty(value="bootStrapConfigurationBlobs")
    private List<String> bootStrapConfigurationBlobs;
    @JsonProperty(value="virtualHub")
    private SubResource virtualHub;
    @JsonProperty(value="cloudInitConfigurationBlobs")
    private List<String> cloudInitConfigurationBlobs;
    @JsonProperty(value="cloudInitConfiguration")
    private String cloudInitConfiguration;
    @JsonProperty(value="virtualApplianceAsn")
    private Long virtualApplianceAsn;
    @JsonProperty(value="sshPublicKey")
    private String sshPublicKey;
    @JsonProperty(value="virtualApplianceNics", access=JsonProperty.Access.WRITE_ONLY)
    private List<VirtualApplianceNicProperties> virtualApplianceNics;
    @JsonProperty(value="virtualApplianceSites", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> virtualApplianceSites;
    @JsonProperty(value="inboundSecurityRules", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> inboundSecurityRules;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    public VirtualApplianceSkuProperties nvaSku() {
        return this.nvaSku;
    }

    public NetworkVirtualAppliancePropertiesFormat withNvaSku(VirtualApplianceSkuProperties nvaSku) {
        this.nvaSku = nvaSku;
        return this;
    }

    public String addressPrefix() {
        return this.addressPrefix;
    }

    public List<String> bootStrapConfigurationBlobs() {
        return this.bootStrapConfigurationBlobs;
    }

    public NetworkVirtualAppliancePropertiesFormat withBootStrapConfigurationBlobs(List<String> bootStrapConfigurationBlobs) {
        this.bootStrapConfigurationBlobs = bootStrapConfigurationBlobs;
        return this;
    }

    public SubResource virtualHub() {
        return this.virtualHub;
    }

    public NetworkVirtualAppliancePropertiesFormat withVirtualHub(SubResource virtualHub) {
        this.virtualHub = virtualHub;
        return this;
    }

    public List<String> cloudInitConfigurationBlobs() {
        return this.cloudInitConfigurationBlobs;
    }

    public NetworkVirtualAppliancePropertiesFormat withCloudInitConfigurationBlobs(List<String> cloudInitConfigurationBlobs) {
        this.cloudInitConfigurationBlobs = cloudInitConfigurationBlobs;
        return this;
    }

    public String cloudInitConfiguration() {
        return this.cloudInitConfiguration;
    }

    public NetworkVirtualAppliancePropertiesFormat withCloudInitConfiguration(String cloudInitConfiguration) {
        this.cloudInitConfiguration = cloudInitConfiguration;
        return this;
    }

    public Long virtualApplianceAsn() {
        return this.virtualApplianceAsn;
    }

    public NetworkVirtualAppliancePropertiesFormat withVirtualApplianceAsn(Long virtualApplianceAsn) {
        this.virtualApplianceAsn = virtualApplianceAsn;
        return this;
    }

    public String sshPublicKey() {
        return this.sshPublicKey;
    }

    public NetworkVirtualAppliancePropertiesFormat withSshPublicKey(String sshPublicKey) {
        this.sshPublicKey = sshPublicKey;
        return this;
    }

    public List<VirtualApplianceNicProperties> virtualApplianceNics() {
        return this.virtualApplianceNics;
    }

    public List<SubResource> virtualApplianceSites() {
        return this.virtualApplianceSites;
    }

    public List<SubResource> inboundSecurityRules() {
        return this.inboundSecurityRules;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.nvaSku() != null) {
            this.nvaSku().validate();
        }
        if (this.virtualApplianceNics() != null) {
            this.virtualApplianceNics().forEach(e -> e.validate());
        }
    }
}

