/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.IpAllocationPropertiesFormat;
import com.azure.resourcemanager.network.models.IpAllocationType;
import com.azure.resourcemanager.network.models.IpVersion;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class IpAllocationInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(IpAllocationInner.class);
    @JsonProperty(value="properties")
    private IpAllocationPropertiesFormat innerProperties;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="id")
    private String id;

    private IpAllocationPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public IpAllocationInner withId(String id) {
        this.id = id;
        return this;
    }

    public IpAllocationInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public IpAllocationInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public SubResource subnet() {
        return this.innerProperties() == null ? null : this.innerProperties().subnet();
    }

    public SubResource virtualNetwork() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetwork();
    }

    public IpAllocationType typePropertiesType() {
        return this.innerProperties() == null ? null : this.innerProperties().type();
    }

    public IpAllocationInner withTypePropertiesType(IpAllocationType type) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IpAllocationPropertiesFormat();
        }
        this.innerProperties().withType(type);
        return this;
    }

    public String prefix() {
        return this.innerProperties() == null ? null : this.innerProperties().prefix();
    }

    public IpAllocationInner withPrefix(String prefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IpAllocationPropertiesFormat();
        }
        this.innerProperties().withPrefix(prefix);
        return this;
    }

    public Integer prefixLength() {
        return this.innerProperties() == null ? null : this.innerProperties().prefixLength();
    }

    public IpAllocationInner withPrefixLength(Integer prefixLength) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IpAllocationPropertiesFormat();
        }
        this.innerProperties().withPrefixLength(prefixLength);
        return this;
    }

    public IpVersion prefixType() {
        return this.innerProperties() == null ? null : this.innerProperties().prefixType();
    }

    public IpAllocationInner withPrefixType(IpVersion prefixType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IpAllocationPropertiesFormat();
        }
        this.innerProperties().withPrefixType(prefixType);
        return this;
    }

    public String ipamAllocationId() {
        return this.innerProperties() == null ? null : this.innerProperties().ipamAllocationId();
    }

    public IpAllocationInner withIpamAllocationId(String ipamAllocationId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IpAllocationPropertiesFormat();
        }
        this.innerProperties().withIpamAllocationId(ipamAllocationId);
        return this;
    }

    public Map<String, String> allocationTags() {
        return this.innerProperties() == null ? null : this.innerProperties().allocationTags();
    }

    public IpAllocationInner withAllocationTags(Map<String, String> allocationTags) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IpAllocationPropertiesFormat();
        }
        this.innerProperties().withAllocationTags(allocationTags);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

