/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCrossConnectionPeeringInner;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitReference;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.ServiceProviderProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ExpressRouteCrossConnectionProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ExpressRouteCrossConnectionProperties.class);
    @JsonProperty(value="primaryAzurePort", access=JsonProperty.Access.WRITE_ONLY)
    private String primaryAzurePort;
    @JsonProperty(value="secondaryAzurePort", access=JsonProperty.Access.WRITE_ONLY)
    private String secondaryAzurePort;
    @JsonProperty(value="sTag", access=JsonProperty.Access.WRITE_ONLY)
    private Integer stag;
    @JsonProperty(value="peeringLocation", access=JsonProperty.Access.WRITE_ONLY)
    private String peeringLocation;
    @JsonProperty(value="bandwidthInMbps", access=JsonProperty.Access.WRITE_ONLY)
    private Integer bandwidthInMbps;
    @JsonProperty(value="expressRouteCircuit")
    private ExpressRouteCircuitReference expressRouteCircuit;
    @JsonProperty(value="serviceProviderProvisioningState")
    private ServiceProviderProvisioningState serviceProviderProvisioningState;
    @JsonProperty(value="serviceProviderNotes")
    private String serviceProviderNotes;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="peerings")
    private List<ExpressRouteCrossConnectionPeeringInner> peerings;

    public String primaryAzurePort() {
        return this.primaryAzurePort;
    }

    public String secondaryAzurePort() {
        return this.secondaryAzurePort;
    }

    public Integer stag() {
        return this.stag;
    }

    public String peeringLocation() {
        return this.peeringLocation;
    }

    public Integer bandwidthInMbps() {
        return this.bandwidthInMbps;
    }

    public ExpressRouteCircuitReference expressRouteCircuit() {
        return this.expressRouteCircuit;
    }

    public ExpressRouteCrossConnectionProperties withExpressRouteCircuit(ExpressRouteCircuitReference expressRouteCircuit) {
        this.expressRouteCircuit = expressRouteCircuit;
        return this;
    }

    public ServiceProviderProvisioningState serviceProviderProvisioningState() {
        return this.serviceProviderProvisioningState;
    }

    public ExpressRouteCrossConnectionProperties withServiceProviderProvisioningState(ServiceProviderProvisioningState serviceProviderProvisioningState) {
        this.serviceProviderProvisioningState = serviceProviderProvisioningState;
        return this;
    }

    public String serviceProviderNotes() {
        return this.serviceProviderNotes;
    }

    public ExpressRouteCrossConnectionProperties withServiceProviderNotes(String serviceProviderNotes) {
        this.serviceProviderNotes = serviceProviderNotes;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<ExpressRouteCrossConnectionPeeringInner> peerings() {
        return this.peerings;
    }

    public ExpressRouteCrossConnectionProperties withPeerings(List<ExpressRouteCrossConnectionPeeringInner> peerings) {
        this.peerings = peerings;
        return this;
    }

    public void validate() {
        if (this.expressRouteCircuit() != null) {
            this.expressRouteCircuit().validate();
        }
        if (this.peerings() != null) {
            this.peerings().forEach(e -> e.validate());
        }
    }
}

