/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.BgpConnectionProperties;
import com.azure.resourcemanager.network.models.HubBgpConnectionStatus;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class BgpConnectionInner
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(BgpConnectionInner.class);
    @JsonProperty(value="properties")
    private BgpConnectionProperties innerProperties;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;

    private BgpConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public BgpConnectionInner withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public BgpConnectionInner withId(String id) {
        super.withId(id);
        return this;
    }

    public Long peerAsn() {
        return this.innerProperties() == null ? null : this.innerProperties().peerAsn();
    }

    public BgpConnectionInner withPeerAsn(Long peerAsn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BgpConnectionProperties();
        }
        this.innerProperties().withPeerAsn(peerAsn);
        return this;
    }

    public String peerIp() {
        return this.innerProperties() == null ? null : this.innerProperties().peerIp();
    }

    public BgpConnectionInner withPeerIp(String peerIp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BgpConnectionProperties();
        }
        this.innerProperties().withPeerIp(peerIp);
        return this;
    }

    public SubResource hubVirtualNetworkConnection() {
        return this.innerProperties() == null ? null : this.innerProperties().hubVirtualNetworkConnection();
    }

    public BgpConnectionInner withHubVirtualNetworkConnection(SubResource hubVirtualNetworkConnection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BgpConnectionProperties();
        }
        this.innerProperties().withHubVirtualNetworkConnection(hubVirtualNetworkConnection);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public HubBgpConnectionStatus connectionState() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

