/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.util;

import com.backblaze.b2.util.B2StringUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public interface B2Md5 {
    public static final int MD5_SIZE = 16;
    public static final int HEX_MD5_SIZE = 32;

    public static MessageDigest getMd5MessageDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("No MD5 installed!", e);
        }
    }

    public static byte[] binaryMd5OfBytes(byte[] bytes) {
        return B2Md5.binaryMd5OfBytes(bytes, 0, bytes.length);
    }

    public static byte[] binaryMd5OfBytes(byte[] bytes, int offset, int length) {
        MessageDigest digest = B2Md5.getMd5MessageDigest();
        digest.update(bytes, offset, length);
        return digest.digest();
    }

    public static String hexMd5OfBytes(byte[] bytes) {
        return B2Md5.hexMd5OfBytes(bytes, 0, bytes.length);
    }

    public static String hexMd5OfBytes(byte[] bytes, int offset, int length) {
        return B2StringUtil.toHexString(B2Md5.binaryMd5OfBytes(bytes, offset, length));
    }
}

