/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.json.B2JsonNonUrlTypeHandler;
import com.backblaze.b2.json.B2JsonOptions;
import com.backblaze.b2.json.B2JsonReader;
import com.backblaze.b2.json.B2JsonTypeHandler;
import com.backblaze.b2.json.B2JsonUtil;
import com.backblaze.b2.json.B2JsonWriter;
import com.backblaze.b2.json.B2TypeResolver;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.TreeMap;

public class B2JsonMapHandler
extends B2JsonNonUrlTypeHandler<Map> {
    private final B2JsonTypeHandler keyHandler;
    private final B2JsonTypeHandler valueHandler;

    public B2JsonMapHandler(B2JsonTypeHandler keyHandler, B2JsonTypeHandler valueHandler) throws B2JsonException {
        if (!keyHandler.isStringInJson()) {
            throw new B2JsonException("Map key is not a string: " + keyHandler.getHandledType());
        }
        this.keyHandler = keyHandler;
        this.valueHandler = valueHandler;
    }

    @Override
    public Type getHandledType() {
        return new B2TypeResolver.ResolvedParameterizedType((Type)((Object)Map.class), new Type[]{this.keyHandler.getHandledType(), this.valueHandler.getHandledType()});
    }

    @Override
    public void serialize(Map obj, B2JsonOptions options, B2JsonWriter out) throws IOException, B2JsonException {
        out.startObject();
        for (Map.Entry entry : obj.entrySet()) {
            if (entry.getKey() == null) {
                throw new B2JsonException("Map key is null");
            }
            out.startObjectFieldName();
            this.keyHandler.serialize(entry.getKey(), options, out);
            out.writeFieldNameValueSeparator();
            B2JsonUtil.serializeMaybeNull(this.valueHandler, entry.getValue(), out, options);
        }
        out.finishObject();
    }

    @Override
    public Map deserialize(B2JsonReader in, B2JsonOptions options) throws B2JsonException, IOException {
        TreeMap result = new TreeMap();
        if (in.startObjectAndCheckForContents()) {
            do {
                Object key = this.keyHandler.deserialize(in, options);
                in.skipObjectColon();
                Object value = B2JsonUtil.deserializeMaybeNull(this.valueHandler, in, options);
                result.put(key, value);
            } while (in.objectHasMoreFields());
        }
        in.finishObject();
        return result;
    }

    @Override
    public Map defaultValueForOptional() {
        return null;
    }

    @Override
    public boolean isStringInJson() {
        return false;
    }
}

