/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.json.B2JsonOptions;
import com.backblaze.b2.json.B2JsonReader;
import com.backblaze.b2.json.B2JsonTypeHandler;
import com.backblaze.b2.json.B2JsonWriter;
import com.backblaze.b2.util.B2DateTimeUtil;
import com.backblaze.b2.util.B2StringUtil;
import java.io.IOException;
import java.lang.reflect.Type;
import java.time.LocalDate;

public class B2JsonLocalDateHandler
implements B2JsonTypeHandler<LocalDate> {
    @Override
    public Type getHandledType() {
        return LocalDate.class;
    }

    @Override
    public void serialize(LocalDate obj, B2JsonOptions options, B2JsonWriter out) throws IOException, B2JsonException {
        out.writeString(B2DateTimeUtil.formatSolidDate(obj));
    }

    @Override
    public LocalDate deserialize(B2JsonReader in, B2JsonOptions options) throws B2JsonException, IOException {
        String str = in.readString();
        int len = str.length();
        if (len == 10 && B2StringUtil.decimalNumberInRange(str, 0, 4, 1970, 2999) && B2StringUtil.decimalNumberInRange(str, 5, 2, 1, 12) && B2StringUtil.decimalNumberInRange(str, 8, 2, 1, 31)) {
            return LocalDate.parse(str);
        }
        if (len == 8 && B2StringUtil.decimalNumberInRange(str, 0, 4, 1970, 2999) && B2StringUtil.decimalNumberInRange(str, 4, 2, 1, 12) && B2StringUtil.decimalNumberInRange(str, 6, 2, 1, 31)) {
            return LocalDate.of(B2StringUtil.decimalSubstringToInt(str, 0, 4), B2StringUtil.decimalSubstringToInt(str, 4, 6), B2StringUtil.decimalSubstringToInt(str, 6, 8));
        }
        throw new B2JsonException("not a valid date: " + str);
    }

    @Override
    public LocalDate deserializeUrlParam(String str) throws B2JsonException {
        int len = str.length();
        if (len == 10 && B2StringUtil.decimalNumberInRange(str, 0, 4, 1970, 2999) && B2StringUtil.decimalNumberInRange(str, 5, 2, 1, 12) && B2StringUtil.decimalNumberInRange(str, 8, 2, 1, 31)) {
            return LocalDate.parse(str);
        }
        if (len == 8 && B2StringUtil.decimalNumberInRange(str, 0, 4, 1970, 2999) && B2StringUtil.decimalNumberInRange(str, 4, 2, 1, 12) && B2StringUtil.decimalNumberInRange(str, 6, 2, 1, 31)) {
            return LocalDate.of(B2StringUtil.decimalSubstringToInt(str, 0, 4), B2StringUtil.decimalSubstringToInt(str, 4, 6), B2StringUtil.decimalSubstringToInt(str, 6, 8));
        }
        throw new B2JsonException("not a valid date: " + str);
    }

    @Override
    public LocalDate defaultValueForOptional() {
        return null;
    }

    @Override
    public boolean isStringInJson() {
        return true;
    }
}

