/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2Json;
import com.backblaze.b2.json.B2JsonBigDecimalHandler;
import com.backblaze.b2.json.B2JsonBigIntegerHandler;
import com.backblaze.b2.json.B2JsonBooleanArrayHandler;
import com.backblaze.b2.json.B2JsonBooleanHandler;
import com.backblaze.b2.json.B2JsonByteArrayHandler;
import com.backblaze.b2.json.B2JsonByteHandler;
import com.backblaze.b2.json.B2JsonCharArrayHandler;
import com.backblaze.b2.json.B2JsonCharSquenceHandler;
import com.backblaze.b2.json.B2JsonCharacterHandler;
import com.backblaze.b2.json.B2JsonConcurrentMapHandler;
import com.backblaze.b2.json.B2JsonDoubleArrayHandler;
import com.backblaze.b2.json.B2JsonDoubleHandler;
import com.backblaze.b2.json.B2JsonDurationHandler;
import com.backblaze.b2.json.B2JsonEnumHandler;
import com.backblaze.b2.json.B2JsonEnumSetHandler;
import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.json.B2JsonFloatArrayHandler;
import com.backblaze.b2.json.B2JsonFloatHandler;
import com.backblaze.b2.json.B2JsonInitializedTypeHandler;
import com.backblaze.b2.json.B2JsonIntArrayHandler;
import com.backblaze.b2.json.B2JsonIntegerHandler;
import com.backblaze.b2.json.B2JsonLinkedHashSetHandler;
import com.backblaze.b2.json.B2JsonListHandler;
import com.backblaze.b2.json.B2JsonLocalDateHandler;
import com.backblaze.b2.json.B2JsonLocalDateTimeHandler;
import com.backblaze.b2.json.B2JsonLongArrayHandler;
import com.backblaze.b2.json.B2JsonLongHandler;
import com.backblaze.b2.json.B2JsonMapHandler;
import com.backblaze.b2.json.B2JsonObjectArrayHandler;
import com.backblaze.b2.json.B2JsonObjectHandler;
import com.backblaze.b2.json.B2JsonSetHandler;
import com.backblaze.b2.json.B2JsonStringHandler;
import com.backblaze.b2.json.B2JsonTreeSetHandler;
import com.backblaze.b2.json.B2JsonTypeHandler;
import com.backblaze.b2.json.B2JsonTypeHandlerWithDefaults;
import com.backblaze.b2.json.B2JsonUnionBaseHandler;
import com.backblaze.b2.json.FieldInfo;
import com.backblaze.b2.util.B2Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;

public class B2JsonHandlerMap {
    private final Map<Type, B2JsonTypeHandler<?>> map = new HashMap();
    private boolean inGetHandler = false;
    private final List<B2JsonTypeHandler> handlersAddedToMap = new ArrayList<B2JsonTypeHandler>();

    public B2JsonHandlerMap() {
        this(null);
    }

    private B2JsonHandlerMap(Map<Type, B2JsonTypeHandler<?>> initialMapOrNull) {
        this.map.put((Type)((Object)BigDecimal.class), new B2JsonBigDecimalHandler());
        this.map.put((Type)((Object)BigInteger.class), new B2JsonBigIntegerHandler());
        this.map.put(Boolean.TYPE, new B2JsonBooleanHandler(true));
        this.map.put((Type)((Object)Boolean.class), new B2JsonBooleanHandler(false));
        this.map.put(Byte.TYPE, new B2JsonByteHandler(true));
        this.map.put((Type)((Object)Byte.class), new B2JsonByteHandler(false));
        this.map.put(Character.TYPE, new B2JsonCharacterHandler(true));
        this.map.put((Type)((Object)Character.class), new B2JsonCharacterHandler(false));
        this.map.put(Integer.TYPE, new B2JsonIntegerHandler(true));
        this.map.put((Type)((Object)Integer.class), new B2JsonIntegerHandler(false));
        this.map.put((Type)((Object)LocalDate.class), new B2JsonLocalDateHandler());
        this.map.put((Type)((Object)LocalDateTime.class), new B2JsonLocalDateTimeHandler());
        this.map.put((Type)((Object)Duration.class), new B2JsonDurationHandler());
        this.map.put(Long.TYPE, new B2JsonLongHandler(true));
        this.map.put((Type)((Object)Long.class), new B2JsonLongHandler(false));
        this.map.put(Float.TYPE, new B2JsonFloatHandler(true));
        this.map.put((Type)((Object)Float.class), new B2JsonFloatHandler(false));
        this.map.put(Double.TYPE, new B2JsonDoubleHandler(true));
        this.map.put((Type)((Object)Double.class), new B2JsonDoubleHandler(false));
        this.map.put((Type)((Object)String.class), new B2JsonStringHandler());
        this.map.put((Type)((Object)CharSequence.class), new B2JsonCharSquenceHandler());
        this.map.put((Type)((Object)boolean[].class), new B2JsonBooleanArrayHandler(this.map.get(Boolean.TYPE)));
        this.map.put((Type)((Object)char[].class), new B2JsonCharArrayHandler(this.map.get(Character.TYPE)));
        this.map.put((Type)((Object)byte[].class), new B2JsonByteArrayHandler(this.map.get(Byte.TYPE)));
        this.map.put((Type)((Object)int[].class), new B2JsonIntArrayHandler(this.map.get(Integer.TYPE)));
        this.map.put((Type)((Object)long[].class), new B2JsonLongArrayHandler(this.map.get(Long.TYPE)));
        this.map.put((Type)((Object)float[].class), new B2JsonFloatArrayHandler(this.map.get(Float.TYPE)));
        this.map.put((Type)((Object)double[].class), new B2JsonDoubleArrayHandler(this.map.get(Double.TYPE)));
        if (initialMapOrNull != null) {
            initialMapOrNull.forEach(this::putHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <T> B2JsonTypeHandler<T> getHandler(Type type) throws B2JsonException {
        ArrayList<B2JsonTypeHandler> handlersToCheckDefaults;
        B2JsonTypeHandler<T> handler;
        B2Preconditions.checkState(!this.inGetHandler);
        B2Preconditions.checkState(this.handlersAddedToMap.isEmpty());
        B2JsonTypeHandler<T> existingHandlerOrNull = this.lookupHandler(type);
        if (existingHandlerOrNull != null) {
            return existingHandlerOrNull;
        }
        this.inGetHandler = true;
        try {
            handler = this.getUninitializedHandler(type);
            for (int i = 0; i < this.handlersAddedToMap.size(); ++i) {
                B2JsonTypeHandler handlerAdded = this.handlersAddedToMap.get(i);
                if (!(handlerAdded instanceof B2JsonInitializedTypeHandler)) continue;
                ((B2JsonInitializedTypeHandler)handlerAdded).initialize(this);
            }
            handlersToCheckDefaults = new ArrayList<B2JsonTypeHandler>(this.handlersAddedToMap);
        }
        catch (Throwable t) {
            for (B2JsonTypeHandler handlerAdded : this.handlersAddedToMap) {
                this.map.remove(handlerAdded.getHandledType());
            }
            throw new B2JsonException(t.getMessage());
        }
        finally {
            this.handlersAddedToMap.clear();
            B2Preconditions.checkState(this.inGetHandler);
            this.inGetHandler = false;
        }
        try {
            for (B2JsonTypeHandler handlerToCheck : handlersToCheckDefaults) {
                if (!(handlerToCheck instanceof B2JsonTypeHandlerWithDefaults)) continue;
                B2JsonTypeHandlerWithDefaults handlerWithDefaults = (B2JsonTypeHandlerWithDefaults)handlerToCheck;
                handlerWithDefaults.checkDefaultValuesAndRememberResult();
            }
        }
        finally {
            this.handlersAddedToMap.clear();
        }
        return handler;
    }

    synchronized <T> B2JsonTypeHandler<T> getUninitializedHandler(Type type) throws B2JsonException {
        B2JsonTypeHandler handler = this.lookupHandler(type);
        if (handler != null) {
            return handler;
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            handler = this.getUninitializedHandlerForClass(clazz);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            handler = this.getUninitializedHandlerForParameterizedType(parameterizedType);
        } else if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            handler = this.getUninitializedHandlerForGenericArrayType(genericArrayType);
        } else {
            throw new B2JsonException("do not know how to get handler for type " + type.getTypeName());
        }
        this.rememberHandler(type, handler);
        return handler;
    }

    private synchronized <T> B2JsonTypeHandler<T> getUninitializedHandlerForClass(Class<T> clazz) throws B2JsonException {
        B2JsonTypeHandler<T> result = this.findCustomHandler(clazz);
        if (result != null) {
            return result;
        }
        if (clazz.isEnum()) {
            return new B2JsonEnumHandler<T>(clazz);
        }
        if (clazz.isArray()) {
            Class<?> eltClazz = clazz.getComponentType();
            B2JsonTypeHandler<T> eltClazzHandler = this.getUninitializedHandler(eltClazz);
            return new B2JsonObjectArrayHandler<T>(clazz, eltClazz, eltClazzHandler);
        }
        if (B2JsonHandlerMap.isUnionBase(clazz)) {
            return new B2JsonUnionBaseHandler<T>(clazz);
        }
        return new B2JsonObjectHandler<T>(clazz);
    }

    private synchronized B2JsonTypeHandler getUninitializedHandlerForParameterizedType(ParameterizedType parameterizedType) throws B2JsonException {
        Type rawType = parameterizedType.getRawType();
        if (rawType.equals(LinkedHashSet.class)) {
            Type itemType = parameterizedType.getActualTypeArguments()[0];
            B2JsonTypeHandler itemHandler = this.getUninitializedHandler(itemType);
            return new B2JsonLinkedHashSetHandler(itemHandler);
        }
        if (rawType.equals(List.class)) {
            Type itemType = parameterizedType.getActualTypeArguments()[0];
            B2JsonTypeHandler itemHandler = this.getUninitializedHandler(itemType);
            return new B2JsonListHandler(itemHandler);
        }
        if (rawType.equals(TreeSet.class)) {
            Type itemType = parameterizedType.getActualTypeArguments()[0];
            B2JsonTypeHandler itemHandler = this.getUninitializedHandler(itemType);
            return new B2JsonTreeSetHandler(itemHandler);
        }
        if (rawType.equals(Set.class)) {
            Type itemType = parameterizedType.getActualTypeArguments()[0];
            B2JsonTypeHandler itemHandler = this.getUninitializedHandler(itemType);
            return new B2JsonSetHandler(itemHandler);
        }
        if (rawType.equals(EnumSet.class)) {
            Type itemType = parameterizedType.getActualTypeArguments()[0];
            B2JsonTypeHandler itemHandler = this.getUninitializedHandler(itemType);
            return new B2JsonEnumSetHandler(itemHandler);
        }
        if (rawType.equals(Map.class) || rawType.equals(SortedMap.class) || rawType.equals(TreeMap.class)) {
            Type keyType = parameterizedType.getActualTypeArguments()[0];
            Type valueType = parameterizedType.getActualTypeArguments()[1];
            B2JsonTypeHandler keyHandler = this.getUninitializedHandler(keyType);
            B2JsonTypeHandler valueHandler = this.getUninitializedHandler(valueType);
            return new B2JsonMapHandler(keyHandler, valueHandler);
        }
        if (rawType.equals(ConcurrentMap.class)) {
            Type keyType = parameterizedType.getActualTypeArguments()[0];
            Type valueType = parameterizedType.getActualTypeArguments()[1];
            B2JsonTypeHandler keyHandler = this.getUninitializedHandler(keyType);
            B2JsonTypeHandler valueHandler = this.getUninitializedHandler(valueType);
            return new B2JsonConcurrentMapHandler(keyHandler, valueHandler);
        }
        Type resolvedRawType = parameterizedType.getRawType();
        B2Preconditions.checkArgument(resolvedRawType instanceof Class);
        Class resolvedRawTypeClass = (Class)resolvedRawType;
        return new B2JsonObjectHandler(resolvedRawTypeClass, parameterizedType.getActualTypeArguments());
    }

    private synchronized B2JsonTypeHandler getUninitializedHandlerForGenericArrayType(GenericArrayType genericArrayType) throws B2JsonException {
        return new B2JsonObjectArrayHandler(genericArrayType.getClass(), genericArrayType.getGenericComponentType().getClass(), this.getUninitializedHandler(genericArrayType.getGenericComponentType()));
    }

    static List<Field> getObjectFieldsForJson(Class<?> clazz) throws B2JsonException {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            FieldInfo.FieldRequirement requirement = B2JsonHandlerMap.getFieldRequirement(clazz, field);
            if (Modifier.isStatic(field.getModifiers()) || requirement == FieldInfo.FieldRequirement.IGNORED) continue;
            result.add(field);
        }
        return result;
    }

    static FieldInfo.FieldRequirement getFieldRequirement(Class<?> clazz, Field field) throws B2JsonException {
        int modifiers = field.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            return FieldInfo.FieldRequirement.IGNORED;
        }
        FieldInfo.FieldRequirement result = null;
        int count = 0;
        if (field.getAnnotation(B2Json.required.class) != null) {
            result = FieldInfo.FieldRequirement.REQUIRED;
            ++count;
        }
        if (field.getAnnotation(B2Json.optional.class) != null) {
            result = FieldInfo.FieldRequirement.OPTIONAL;
            ++count;
        }
        if (field.getAnnotation(B2Json.optionalWithDefault.class) != null) {
            result = FieldInfo.FieldRequirement.OPTIONAL;
            ++count;
        }
        if (field.getAnnotation(B2Json.ignored.class) != null) {
            result = FieldInfo.FieldRequirement.IGNORED;
            ++count;
        }
        if (count != 1) {
            throw new B2JsonException(clazz.getName() + "." + field.getName() + " should have exactly one annotation: required, optional, optionalWithDefault, or ignored");
        }
        return result;
    }

    static <T> boolean isUnionBase(Class<T> clazz) {
        return clazz.getAnnotation(B2Json.union.class) != null;
    }

    private <T> B2JsonTypeHandler<T> findCustomHandler(Class<T> clazz) throws B2JsonException {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod("getJsonTypeHandler", new Class[0]);
            method.setAccessible(true);
            Object obj = method.invoke(null, new Object[0]);
            if (obj instanceof B2JsonTypeHandler) {
                return (B2JsonTypeHandler)obj;
            }
            String objType = obj == null ? "null" : obj.getClass().getName();
            throw new B2JsonException(clazz.getSimpleName() + "." + method.getName() + "() returned an unexpected type of object (" + objType + ")");
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            throw new B2JsonException("failed to invoke " + method + ": " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new B2JsonException("illegal access to " + method + ": " + e.getMessage(), e);
        }
    }

    private synchronized <T> B2JsonTypeHandler<T> lookupHandler(Type type) {
        return this.map.get(type);
    }

    private synchronized <T> void rememberHandler(Type type, B2JsonTypeHandler<T> handler) {
        B2Preconditions.checkState(!this.map.containsKey(type));
        this.putHandler(type, handler);
        this.handlersAddedToMap.add(handler);
    }

    private synchronized <T> void putHandler(Type type, B2JsonTypeHandler<T> handler) {
        this.map.put(type, handler);
    }
}

