/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2Json;
import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.json.B2JsonOptions;
import com.backblaze.b2.json.B2JsonReader;
import com.backblaze.b2.json.B2JsonTypeHandler;
import com.backblaze.b2.json.B2JsonWriter;
import com.backblaze.b2.util.B2Preconditions;
import com.backblaze.b2.util.B2StringUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class B2JsonEnumHandler<T>
implements B2JsonTypeHandler<T> {
    private final Class<T> enumClass;
    private final Method valueOfMethod;
    private final T defaultForInvalidValue;

    public B2JsonEnumHandler(Class<T> enumClass) throws B2JsonException {
        this.enumClass = enumClass;
        this.valueOfMethod = this.getValueOfMethod(enumClass);
        this.defaultForInvalidValue = this.getDefaultForInvalidValue(enumClass);
    }

    private Method getValueOfMethod(Class<T> enumClass) throws B2JsonException {
        B2Preconditions.checkArgument(enumClass.isEnum());
        try {
            return enumClass.getMethod("valueOf", String.class);
        }
        catch (NoSuchMethodException e) {
            throw new B2JsonException("enum class " + enumClass + " has no valueOf method");
        }
    }

    private T getDefaultForInvalidValue(Class<T> enumClass) throws B2JsonException {
        Enum defaultForInvalid = null;
        for (T valueConstant : enumClass.getEnumConstants()) {
            try {
                Enum value = (Enum)valueConstant;
                Field field = enumClass.getField(value.name());
                if (field.getAnnotation(B2Json.defaultForInvalidEnumValue.class) == null) continue;
                if (defaultForInvalid != null) {
                    throw new B2JsonException("more than one @B2Json.defaultForInvalidEnumValue annotation in enum class " + enumClass.getCanonicalName());
                }
                defaultForInvalid = value;
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("failed to get field for enum value constant (" + valueConstant + ") in enum class " + enumClass.getCanonicalName());
            }
        }
        return (T)defaultForInvalid;
    }

    @Override
    public Type getHandledType() {
        return this.enumClass;
    }

    @Override
    public void serialize(T obj, B2JsonOptions options, B2JsonWriter out) throws IOException, B2JsonException {
        out.writeString(obj.toString());
    }

    @Override
    public T deserialize(B2JsonReader in, B2JsonOptions options) throws B2JsonException, IOException {
        String str = in.readString();
        return this.deserializeUrlParam(str);
    }

    @Override
    public T deserializeUrlParam(String urlValue) throws B2JsonException {
        try {
            return (T)this.valueOfMethod.invoke(null, urlValue);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof IllegalArgumentException) {
                if (this.defaultForInvalidValue != null) {
                    return this.defaultForInvalidValue;
                }
                String validValues = B2StringUtil.join(", ", this.enumClass.getEnumConstants());
                throw new B2JsonException(urlValue + " is not a valid value.  Valid values are: " + validValues);
            }
            throw new B2JsonException("error calling " + this.enumClass + ".valueOf", e);
        }
        catch (IllegalAccessException e) {
            throw new B2JsonException("error calling " + this.enumClass + ".valueOf", e);
        }
    }

    @Override
    public T defaultValueForOptional() {
        return null;
    }

    @Override
    public boolean isStringInJson() {
        return true;
    }
}

