/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.json.B2JsonOptions;
import com.backblaze.b2.json.B2JsonReader;
import com.backblaze.b2.json.B2JsonTypeHandler;
import com.backblaze.b2.json.B2JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigInteger;

public class B2JsonBigIntegerHandler
implements B2JsonTypeHandler<BigInteger> {
    @Override
    public Type getHandledType() {
        return BigInteger.class;
    }

    @Override
    public void serialize(BigInteger obj, B2JsonOptions options, B2JsonWriter out) throws IOException, B2JsonException {
        out.writeText(obj.toString());
    }

    @Override
    public BigInteger deserialize(B2JsonReader in, B2JsonOptions options) throws B2JsonException, IOException {
        return new BigInteger(in.readNumberAsString());
    }

    @Override
    public BigInteger deserializeUrlParam(String urlValue) throws B2JsonException {
        return new BigInteger(urlValue);
    }

    @Override
    public BigInteger defaultValueForOptional() {
        return null;
    }

    @Override
    public boolean isStringInJson() {
        return false;
    }
}

