/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.client.structures.B2UploadState;
import java.util.Objects;

public class B2UploadProgress {
    public static final long UNKNOWN_PART_SIZE_PLACEHOLDER = 1L;
    public static final long UNKNOWN_PART_START_BYTE = -1L;
    private final int partIndex;
    private final int partCount;
    private final long startByte;
    private final long length;
    private final long bytesSoFar;
    private final B2UploadState state;

    public B2UploadProgress(int partIndex, int partCount, long startByte, long length, long bytesSoFar, B2UploadState state) {
        this.partIndex = partIndex;
        this.partCount = partCount;
        this.startByte = startByte;
        this.length = length;
        this.bytesSoFar = bytesSoFar;
        this.state = state;
    }

    public int getPartIndex() {
        return this.partIndex;
    }

    public int getPartCount() {
        return this.partCount;
    }

    public boolean isStartByteKnown() {
        return this.startByte != -1L;
    }

    public long getStartByte() {
        return this.startByte;
    }

    public long getLength() {
        return this.length;
    }

    public long getBytesSoFar() {
        return this.bytesSoFar;
    }

    public B2UploadState getState() {
        return this.state;
    }

    public String toString() {
        return "B2UploadProgress{partIndex=" + this.partIndex + ", partCount=" + this.partCount + ", startByte=" + this.startByte + ", length=" + this.length + ", bytesSoFar=" + this.bytesSoFar + ", state=" + (Object)((Object)this.state) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2UploadProgress progress = (B2UploadProgress)o;
        return this.partIndex == progress.partIndex && this.partCount == progress.partCount && this.startByte == progress.startByte && this.length == progress.length && this.bytesSoFar == progress.bytesSoFar && this.state == progress.state;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.partIndex, this.partCount, this.startByte, this.length, this.bytesSoFar, this.state});
    }
}

